@extends('layouts.app')

@section('title')
Bill Detail 
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-expense')
        <li ><a href="{{route('expense.all')}}">Bills</a></li>
        @endpermission
        <li class="active">Bill Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Bill : BILL-00{{$expense->id}}</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Vendor</td>
                                                    <td> {{$expense->vendor->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Expense Name</td>
                                                    <td> {{$expense->category->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Due Amount</td>
                                                    <td> {{$expense->amount}} </td>
                                                </tr>
                                            
                                                <tr>
                                                    <td>Bill Date</td>
                                                    <td> {{date('d-m-Y', strtotime($expense->billed_at)) }} </td>
                                                </tr>
                                                <tr>
                                                    <td>Due Date</td>
                                                    <td> {{date('d-m-Y', strtotime($expense->due_at)) }} </td>
                                                </tr>
                                                <tr>
                                                    <td>Status</td>
                                                    @if($expense->status == true)
                                            <td><span class="label label-success">PAID</span></td>
                                            @else
                                            <td><span class="label label-danger">UNPAID</span></td>
                                            @endif
                                                </tr>

                                                <tr>
                                                    <td>Notes</td>
                                                    <td> {{$expense->notes}} </td>
                                                </tr>

                                                <tr>
                                                <td>Expense Image</td>
                                                <td>
                                                    <img src="{{asset('uploads/'.$expense->image_url)}}" height="300px" width="300px" alt="user-img" >
                                                </td>
                                            </tr>

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$expense->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$expense->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop