@extends('layouts.app')

@section('title')
Bills
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Bills</li>
      </ol>
@stop

@section('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection

@section('content')


            <div class="container-fluid">

                 <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Bills</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Vendor</label>
                                                        <select id="vendor" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($vendors as $v)
                                                        <option value="{{$v->id}}">{{$v->name}}</option>
                                                        @endforeach
                                                        </select>

                                                         </div>
                                                </div>
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Category</label>
                                                        
                                                        <select id="category" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($categories as $c)
                                                        <option value="{{$c->id}}">{{$c->name}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Date</label>
                                                        
                                                         <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" class="form-control " id="daterange-btn"  name='date_range'>
                @if($errors->has('date_range'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('date_range') }}</strong>
                                    </span>
                                @endif
                </div>
                                                         </div>
                                                </div>
                                                <!--/span-->

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By status</label>
                                                        <select id="status" class="form-control select2">
                                                            <option  value="0">None</option>
                                                            
                                                        <option  value="{{\App\Expense::PAID}}">PAID</option>
                                                        <option  value="{{\App\Expense::PARTIALLY}}">PARTIALLY PAID</option>
                                                        
                                                        <option  value="{{\App\Expense::UNPAID}}">UNPAID</option>
                                                        
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>
                                            
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->

                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('create-expense')
								<a href="{{route('expense.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add New
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">Bills ({{number_format($amount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Number</th>

                                            <th>Vendor</th>
                                            <th>Amount</th>




                                            <th>Bill Date</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allExpenses as $expense)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>BILL-000{{$expense->id}}</td>
                                             <td>{{$expense->vendor->name}}</td>

                                              <td>{{number_format($expense->amount)}}</td>
                                               <td>{{date('d-m-Y', strtotime($expense->billed_at)) }}</td>
                                               <td>{{date('d-m-Y', strtotime($expense->due_at)) }}</td>
                                               @if($expense->status == 1)
                                            <td><span class="label label-success">PAID</span></td>
                                            @elseif($expense->status == 2)
                                            <td><span class="label label-primary">PARTIALY</span></td>
                                            @else
                                            <td><span class="label label-danger">UNPAID</span></td>
                                            @endif
                                            <td class="text-nowrap">
                                                @permission('view-expense')
                                                <a href="{{route('expense.detail',['id'=>$expense->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('edit-expense')
                                                <a href="{{route('expense.editView',['id'=>$expense->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('delete-expense')
                                                <a href="{{route('expense.delete',['id'=>$expense->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });

    });
       

    $('#daterange-btn').daterangepicker(
        {
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
          },
          startDate: moment(),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('D MMMM, YYYY') + ' - ' + end.format('D MMMM, YYYY'));
        }
    );

    $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            vendor = $('#vendor').val();
            category = $('#category').val();
            status = $('#status').val();
            date = $('#daterange-btn').val();

            if(vendor == 0 && category == 0 && status == 0 && date == 0) {
                $('.preloader').fadeOut();
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'vendor':vendor,'category':category,'date':date,'status':status};
            $.get('/expense/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });

    </script>
@stop