@extends('layouts.app' )

@section('title')
Add New Category 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('view-expense')
        <li ><a href="{{route('expense.category.all')}}">Expense Categories</a></li>
        @endpermission

        <li class="active">Add Category</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <!--.row-->
                <div class="row">

                    <div class="col-md-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0"><i class="icon-user fa-fw"></i> Add New Category</h3>
                            <p class="text-muted m-b-30 font-13"> Add  Information </p>
                            <form class="form-horizontal" action="{{route('expense.category.insert')}}" method="post">
                               {{csrf_field()}}
                                <div class="form-group">
                                    <label for="exampleInputuname" class="col-sm-2 control-label"> Name <span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group" style="width:300px">

                                            <input  type="text" class="form-control" name="name" value="{{old('name')}}" id="exampleInputuname" placeholder="Name">
                                        @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group" >
                                    <label for="inputPassword3" class="col-sm-2 control-label">Status<span style="color: red">*</span></label>
                                    <div class="col-sm-10">
                                        <div class="input-group">
                                            <select class="form-control" style="width:300px" name="status">
                                                @if(old('status'))
                                                @if(old('status') == true)
                                                <option value='1' selected="">Active</option>
                                                <option value="0">InActive</option>
                                                @else
                                                <option value='1' >Active</option>
                                                <option value="0"selected="">InActive</option>
                                                @endif
                                                @else
                                               <option value='1' selected="">Active</option>
                                                <option value="0">InActive</option>
                                                @endif

                                            </select>

                                        @if ($errors->has('status'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('status') }}</strong>
                                    </span>
                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group m-b-0">
                                    <div class="col-sm-offset-3 col-sm-9">
                                        <button type="submit" class="btn btn-info waves-effect waves-light m-t-10">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!--./row-->
            </div>
            <!-- /.container-fluid -->

@stop