@extends('layouts.app')

@section('title')
All Expense Categories
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Expense Categories</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                 @permission('create-department')
								<a href="{{route('expense.category.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Category
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">All Expense Categories</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Bill Amt.</th>
                                            <th>Paid Amt.</th>
                                            <th>Balance</th>

                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allExpenseCategories as $category)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$category->name}}</td>
                                            <td>{{number_format($billAmount[$category->id])}}</td>
                                            <td>{{number_format($paidAmount[$category->id])}}</td>
                                            <td>{{number_format($billAmount[$category->id] - $paidAmount[$category->id])}}</td>

                                           @if($category->status == true)
                                            <td><span class="label label-success">Active</span></td>
                                            @else
                                            <td><span class="label label-danger">InActive</span></td>
                                            @endif
                                            <td class="text-nowrap">
                                                

                                                @permission('edit-expense')
                                                <a href="{{route('expense.category.editView',['id'=>$category->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>
                                                @endpermission

                                                @permission('delete-expense')
                                                <a href="{{route('expense.category.delete',['id'=>$category->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop