@extends('layouts.app')

@section('title')
Payments
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Payments</li>
      </ol>
@stop

@section('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection

@section('content')


            <div class="container-fluid">

                 <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Search Payments</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                    <form >
                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Vendor</label>
                                                        <select id="vendor" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($vendors as $v)
                                                        <option value="{{$v->id}}">{{$v->name}}</option>
                                                        @endforeach
                                                        </select>

                                                         </div>
                                                </div>
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Category</label>
                                                        
                                                        <select id="category" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($categories as $c)
                                                        <option value="{{$c->id}}">{{$c->name}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Date</label>
                                                        
                                                         <div class="input-group">
                  <div class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                  </div>
                  <input type="text" class="form-control " id="daterange-btn"  name='date_range'>
                @if($errors->has('date_range'))
                                    <span class="help-block" >
                                        <strong>{{ $errors->first('date_range') }}</strong>
                                    </span>
                                @endif
                </div>
                                                         </div>
                                                </div>
                                                <!--/span-->

                                                <!--/span-->
                                                <div class="col-md-3">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                        <label class="control-label">By Account</label>
                                                        <select id="account" class="form-control select2">
                                                        <option  value="0">None</option>
                                                        @foreach($accounts as $a)
                                                        <option value="{{$a->id}}">{{$a->name}}</option>
                                                        @endforeach
                                                        </select> </div>
                                                </div>
                                                <!--/span-->
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="button" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Search</button>
                                            
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->

                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                @permission('create-expense')
								<a href="{{route('payment.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add New
								</a>
                                @endpermission
							</div>
                            <h3 class="box-title">Payments ({{number_format($totalAmount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>DATE</th>
                                            <th>NUMBER</th>

                                            <th>AMOUNT</th>
                                            <th>VENDOR</th>




                                            <th>CATEGORY</th>
                                            <th>ACCOUNT</th>
                                            
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allPayments as $payment)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{date('d-m-Y', strtotime($payment->date)) }}</td>
                                            <td>BILL-000{{$payment->bill->id}}</td>
                                            <td>{{number_format($payment->amount)}}</td>
                                             <td>{{$payment->bill->vendor->name}}</td>
                                             <td>{{$payment->bill->category->name}}</td>
                                             <td>{{$payment->account->name}}</td>

                                            
                                            <td class="text-nowrap">
                                                

                                                @permission('edit-expense')
                                                <!-- <a href="{{route('payment.editView',['id'=>$payment->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a> -->
                                                @endpermission

                                                @permission('delete-expense')
                                                <a href="{{route('payment.delete',['id'=>$payment->id])}}" data-toggle="tooltip" data-original-title="Delete"> <i class="fa fa-close text-danger"></i> </a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')

<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        
        $('#daterange-btn').daterangepicker(
        {
          ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
          },
          startDate: moment(),
          endDate: moment()
        },
        function (start, end) {
          $('#daterange-btn span').html(start.format('D MMMM, YYYY') + ' - ' + end.format('D MMMM, YYYY'));
        }
    );

    $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            vendor = $('#vendor').val();
            category = $('#category').val();
            account = $('#account').val();
            date = $('#daterange-btn').val();

            if(vendor == 0 && category == 0 && account == 0 && date == 0) {
                $('.preloader').fadeOut();
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'vendor':vendor,'category':category,'date':date,'account':account};
            $.get('/payment/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });

});

    </script>
@stop