@extends('layouts.app' )


@section('title')
Due Properties 
@stop

@section('css')
    <link href="{{asset('plugins/components/chartist-js/dist/chartist.min.css')}}" rel="stylesheet">
@stop


@section('content')

<div class=" container-fluid">

<div class="row">

                    <div class="col-sm-12">
                        <div class="white-box">

                            <h3 class="box-title">Due Amounts Properties</h3>


                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Unit No.</th>
                                            
                                            <th>Member Name</th>
                                            <th>Dealer</th>
                                            <th>Net Amount</th>
                                            <th>Received Amount</th>
                                            <th>Due Amount</th>
                                            <th>Due Date</th>
                                            <th>Number</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @permission('view-membership')
                                        <?php $view_membership = true;?>
                                        @else
                                        <?php $view_membership = false;?>
                                        @endpermission

                                        @foreach($due['properties'] as $statement)

                                      @if($due['dueAmt'][$statement->id] > 0)


                                              @if($due['color'][$statement->id] == 'red')
                                                  <tr style="color:red;">
                                              @elseif($due['color'][$statement->id] == 'orange')
                                                  <tr style="color:orange;">
                                              @else
                                                  <tr style="color:black;">
                                                      @endif
                                            <td>{{$count++}}</td>
                                            
                                            <td>
                                            {{$statement->inventory ? $statement->inventory->unit_number : ''}}</td>

                                        
                                            

                                            <td>{{$statement->customer ? $statement->customer->name: ''}}</td>
                                            <td >
                                                @if($statement->dealer)
                                            {{$statement->dealer->name}}
                                        @endif</td>

                                            <td>{{number_format($statement->net_pay)}} PKR</td>


                                            <td>{{number_format($due['receivedAmt'][$statement->id])}} PKR</td>

                                             <td>{{number_format($due['dueAmt'][$statement->id])}} PKR</td>
                                            <td>{{$due['dueDate'][$statement->id] ? date('d-m-Y', strtotime($due['dueDate'][$statement->id]->due_date)) : '' }}
                                                 <br>
                                                @foreach($due['dueMonth'][$statement->id] as $s)

                                                @if($loop->last)
                                                {{date('M', strtotime($s->due_date))}}
                                                @else
                                                {{date('M', strtotime($s->due_date))}} - 

                                                @endif
                                                @endforeach
                                        </td>
                                        <td>{{$statement->customer->mobile_number}}</td>
                                        <td>
                                            @if($view_membership)
                                                <a href="{{route('statement.detail',['id'=>$statement->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                            @endif
                                        </td>



                                        </tr>
                                       @endif

                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

</div>
@stop

@section('js')
<script src="{{asset('plugins/components/chartist-js/dist/chartist.min.js')}}"></script>
<script src="{{asset('plugins/components/chartist-plugin-tooltip-master/dist/chartist-plugin-tooltip.min.js')}}"></script>
<script src="{{asset('plugins/components/knob/jquery.knob.js')}}"></script>
<script src="{{asset('plugins/components/custom-chart/chart.js')}}"></script>
<script src="{{asset('js/db3.js')}}"></script>

<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            
        });
        });
</script>
@stop