@extends('layouts.app')

@section('title')
Update Statement 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        @permission('list-membership')
        <li ><a href="{{route('statement.all')}}">Statements</a></li>
        @endpermission
        <li class="active">Edit Statement</li>
      </ol>
@stop
@section('css')
<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css"> -->
<style type="text/css">
    
</style>

@stop

@section('content')

<div class="container-fluid">
	<div class="row">

            <form class="form-horizontal" method='post' action="{{route('statement.update.installment')}}" enctype="multipart/form-data">
                {{csrf_field()}}
                 @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif
                <input type="hidden" value="{{$property->id}}" name="id">
                <div class="col-lg-12 col-sm-12 col-xs-12">


                    <div class="col-lg-12 col-sm-12 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title">Property Information</h3>
                            <hr>
                            <div class="col-lg-12">
            <div class="white-box">
                <h4 class="box-title">Unit's Details</h4>
                <hr>
                <div class="table-responsive pull-left" >
                    <table class="table" >
                        <tbody>
                            <tr>
                                <td style="font-weight: 600;">Floor:</td>
                                <td > @if($property->inventory->floor){{$property->inventory->floor->name}}@endif </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Category:</td>
                                <td>@foreach($property->inventory->categories as $c)

                                                        @if($loop->last)
                                                        {{$c->category->name}} ({{$c->category->percent}} %)
                                                        @else
                                                        {{$c->category->name}} ({{$c->category->percent}} %),
                                                        @endif
                                                    @endforeach</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Size:</td>
                                <td>
                                                    {{$property->inventory->size->name}}  {{env('SIZE')}}</td>

                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Total Price:</td>
                                <td> {{number_format($property->inventory->total_price - $property->inventory->extra_amount)}} </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Net Amt.:</td>
                                <td> {{number_format($property->net_pay)}} </td>
                            </tr>




                            <!-- <tr>
                                <td>Discount:</td>
                                <td> {{$property->discount}} </td>
                            </tr> -->

                        </tbody>
                    </table>
                </div>
                <div class="table-responsive pull-right">
                    <table class="table">
                        <tbody>
                           <tr>
                                <td style="font-weight: 600;" >Unit #:</td>
                                <td>{{$property->inventory->unit_number}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Unit Type:</td>
                                <td>{{$property->inventory->type->name}}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Discount:</td>
                                <td> {{$property->discount }} </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Category Cost:</td>
                                <td> {{number_format($property->inventory->extra_amount) }} </td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Booking Date:</td>
                                <td> {{date('d-m-Y', strtotime($property->booking_date)) }}</td>
                            </tr>
                            <tr>
                                <td style="font-weight: 600;">Schedule Start Date:</td>
                                <td>@if($property->schedule_start_date) {{date('d-m-Y', strtotime($property->schedule_start_date)) }} @endif</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>
        </div>

                            <div class="clearfix"></div>
                            <div class="col-lg-12">
            <div class="white-box" style="padding:0">
                <h3 class="box-title">Payment Information</h3>
                            <hr>
                <div class="table-responsive" style="clear: both;">
                    <table  class="table table-bordered printFW1">
                        <thead class="printFH11">
                            <tr style="text-align: center">
                                <th style="color: #fff;">Payment Head</th>
                                <th style="color: #fff;">Due Date</th>
                                <th style="color: #fff;">Due Amt.</th>
                                <th style="color: #fff;">Received Amt.</th>
                                <th style="color: #fff;">Payment Mode</th>
                                <!-- <th class="no-print">Detail</th> -->
                                <th style="color: #fff;">Receipt #</th>
                                <!-- <th>Ref#</th> -->
                                <th style="color: #fff;">Receipt Date</th>
                                <th style="color: #fff;">Balance Amt.</th>
                                <!-- <th>Surcharge Amt</th>
                                <th>Net Amt</th> -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php $due = 0;
                            $down_payment = 0;
                            $received = 0;
                            $balance = 0;
                            $surcharge = 0;
                            $net_payable = 0;
                            $count = 1;
                            $total = $property->net_pay;
                            $total_installment = 60;
                            $paid_installment = 0;
                            $per_installment = 8500;
                            $i =0;
                            $rem_amount = $property->net_pay;;
                            ?>
                            @foreach($property->statement as $statement)
                            <tr>
                      

                        @if($statement->payment_head == \App\CustomerStatement::down_payment)
                        <td class="printFV">Down Payment</td>
                        <?php $down_payment = $statement->due;
                        $down_payment_s = $statement->due;
                        ?>
                        @elseif($statement->payment_head == \App\CustomerStatement::possession)
                        <td class="printFV">Possession Fee</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::installment)
                        @if($i == 0)
                        <?php $per_installment = $statement->due;
                        $i=1;
                        $total_installment = 0;?>
                        @endif
                        <td class="printFV">Installment - {{$count++}}</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::other)
                        <td class="printFV">Other</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::allotment)
                        <td class="printFV">Allotment</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::confirmation)
                        <td class="printFV">Confirmation</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::booking)
                        <td class="printFV">Booking</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::development)
                        <td class="printFV">Development</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::file_processing)
                        <td class="printFV">File Processing</td>
                        @elseif($statement->payment_head == \App\CustomerStatement::registration)
                        <td class="printFV">Registration</td>
                        @else
                        <td class="printFV"></td>
                        @endif


                                <!-- <td class="printFV">{{$statement->inst_no}}</td> -->
                                <td class="printFV">{{date('d-m-Y', strtotime($statement->due_date)) }}</td>
                                <td class="printFV">{{number_format($statement->due)}}</td><?php $due += $statement->due; ?>
                                <td class="printFV">{{number_format($statement->received)}}</td><?php $received += $statement->received; ?>
                                @if($statement->receipt)
                                @if($statement->receipt->payment_mode == \App\Receipt::cash)
                                <td class="printFV">Cash</td>
                                @elseif($statement->receipt->payment_mode == \App\Receipt::bank)
                                <td class="printFV">Bank transfer</td>
                                @elseif($statement->receipt->payment_mode == \App\Receipt::cheque)
                                <td class="printFV">Cheque</td>
                                @elseif($statement->receipt->payment_mode == \App\Receipt::adjacement)
                                <td class="printFV">Adjustment</td>
                                @else
                                <td class="printFV"></td>
                                @endif

                                <!-- <td class="no-print">{{$statement->receipt->adjacement_detail}}</td> -->
                                @else
                                <td class="printFV"></td>
                                <!-- <td class="no-print"></td> -->
                                @endif
                                <td class="printFV"> {{$statement->rcpt_no}} </td>
                                <!-- <td class="printFV"> {{$statement->ref_no}} </td> -->
                                <td class="printFV">  {{ $statement->rcpt_date ? date('d-m-Y', strtotime($statement->rcpt_date)) : '' }}</td>
                                @if($statement->received)
                                <?php $total -=$statement->received;?>
                                <?php $rem_amount -= $statement->received;?>
                                <td class="printFV">{{number_format($total)}}</td>
                                @if($statement->payment_head == \App\CustomerStatement::installment)
                                <?php $paid_installment++;?>
                                @endif
                                 @if($statement->payment_head == \App\CustomerStatement::down_payment)
                                <?php $down_payment_s = $statement->balance;?>
                                @endif
                                @else
                                <td class="printFV"></td>
                                @endif
                                @if($statement->payment_head == \App\CustomerStatement::installment)
                                <?php $total_installment++;?>
                                @endif
                            </tr>
                            @endforeach
                            <tr>
                                <td colspan="2" class="printFV text-center"><b>Total</b></td>
                                <td class="printFV"><b>{{number_format($due)}}</b></td>
                                <td  class="printFV"><b>{{number_format($received)}}</b></td>
                                <td colspan="3"></td>
                                <td class="printFV"><b>{{number_format($total)}}</b></td>
                            </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
                            <div class="clearfix"></div>
                            <input type="hidden" name="id" value="{{$property->id}}">

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5"><b>Remaining Balance</b></label>
                                                        <div class="col-md-7">

                                                            <input readonly="" type="integer" class="form-control" value="{{$rem_amount}}"  placeholder="Remaining amount">

                                <div style="color:black;font-size: 11px;" class="help-block" id='remaining-amount-label'></div>
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5"><b>Down Payment</b></label>
                                                        <div class="col-md-7">

                                                            <input readonly="" id="down_payment" type="integer" class="form-control" value="{{$down_payment}}"  placeholder="Remaining amount">

                                <div style="color:black;font-size: 11px;" class="help-block" id='remaining-amount-label'></div>
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Downpayment Notes (optional) </label>
                                                        <div class="col-md-8">
                                                            <textarea class="form-control"  placeholder="Enter Note" name="down_payment_note">{{$property->down_payment_note}}</textarea>


                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Schedule Start Date <span style="color:red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input type="date" class="form-control" name="schedule_start_date" value="{{$property->schedule_start_date}}" id="exampleInputEmail1" placeholder="Enter Schedule Start Date">
                                        @if ($errors->has('schedule_start_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_start_date') }}</strong>
                                    </span>
                                @endif</div>
                                                    </div>
                            </div>
                            <div class="clearfix"></div>


                            @if($property->sms_alert)
                            <input type="checkbox" name="sms_alert" value="1" checked=""> Automatic Sms Alerts<br>
                            @else
                            <input type="checkbox" name="sms_alert" value="1"> Automatic Sms Alerts<br>
                            @endif

                            @if($property->email_alert)
                            <input type="checkbox" name="email_alert" value="1" checked=""> Automatic Email Alerts
                            @else
                            <input type="checkbox" name="email_alert" value="1"> Automatic Email Alerts
                            @endif
                           <div class="clearfix"></div>

                       </div>
                   </div>

                   <div class="col-lg-12 col-sm-12 col-xs-12"  >
                        <div class="white-box">
                            <h3 class="box-title">Update Schedule <input type = "checkbox" name="update_schedule" value="1" id="update_schedule"  ></h3>

                            <hr>
                            <div id="update_schedule_div" style="display: none">
                            <div class="col-md-12" >

                                <div class="form-group">
                                  <label class="control-label col-md-2">Schedular Type<span style="color: red">*</span></label>
                                    <div class="col-md-10">
                                        <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type" value='{{\App\CustomerProperty::inst_mon}}' > Monthly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="enableQuar()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_quar}}' > Monthly with Quarterly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="enableSemi()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_semi}}'  > Monthly with Semi Annually
                                    </div>
                                     <div class="col-md-3">
                                        <input type='radio' onchange="enableAnn()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_ann}}' > Monthly with Annually
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_quar}}'  > Quarterly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_semi}}'  > SemiAnnually
                                    </div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_ann}}'> Annually
                                    </div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="enableCustom(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_custom}}'  > Custom
                                    </div>
                                        @if ($errors->has('schedule_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                                                    </div>
                            </div>





                            <div class="clearfix"></div>
                            <hr>
 <div id = "auto">
                           <div class="col-md-10">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Per Installment <span style="color: red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input style="display: inline-block;width: 49%;" type="integer" id='installment' class="form-control" name="installment" value="{{old('installment')}}" id="exampleInputEmail1" placeholder="Per installment">

                                                            <input style="display: inline-block;width: 49%;" type="integer" readonly="" id='total_installment' class="form-control" name="total_installment" value="{{old('total_installment')}}" placeholder="Total amount">
                                                            <div style="display: inline-block;width: 49%;color:black;font-size: 11px;" class="help-block" id='installment-label'></div>
                                                            <div style="display: inline-block;width: 49%;color:black;font-size: 11px;" class="help-block" id='total-installment-label'></div>
                                        @if ($errors->has('installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>

                                                        <div class="col-md-2">
                                                    <div class="form-group">
                                                        <!-- <label class="control-label col-md-5">Total Installments (Months) <span style="color: red">*</span></label> -->
                                                        <div class="col-md-12">

                                                            <input type="integer" id='total-months' class="form-control" name="installment_plan" value="{{old('installment_plan')}}" id="exampleInputEmail1" placeholder="total installments">
                                        @if ($errors->has('installment_plan'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('installment_plan') }}</strong>
                                    </span>
                                @endif
                                <div style="color:black;font-size: 11px;" class="help-block" id='total-months-label'></div>
                                                        </div>
                                                    </div>
                            </div>
                                                    </div>
                            </div>


                                 <div class="col-md-10" id="ann_div">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Annual Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='annual-installment' class="form-control" name="annual_installment" value="{{old('annual_installment')}}" id="exampleInputEmail1" placeholder=" Annual">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_annual_installment' class="form-control" name="total_annual_installment" value="{{old('total_annual_installment')}}" id="exampleInputEmail1" placeholder="Total Annual">
                          <input style="display: inline-block;width: 15%;" type="integer" id='total_annual_installment_count' class="form-control" name="total_annual_installment_count" value="{{old('total_annual_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='annual-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-annual-installment-label'></div>
                                        @if ($errors->has('annual_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('annual_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>

                                 <div class="col-md-10" id="semi_div" style="display: none">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Semi Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='semi-installment' class="form-control" name="semi_installment" value="{{old('semi_installment')}}" id="exampleInputEmail1" placeholder=" Semi">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_semi_installment' class="form-control" name="total_semi_installment" value="{{old('total_semi_installment')}}" id="exampleInputEmail1" placeholder="Total Semi Annually">
                          <input style="display: inline-block;width: 15%;" type="integer" id='total_semi_installment_count' class="form-control" name="total_semi_installment_count" value="{{old('total_semi_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='semi-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-semi-installment-label'></div>
                                        @if ($errors->has('semi_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('semi_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>

                                 <div class="col-md-10" id="quar_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Quarterly Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='quarterly-installment' class="form-control" name="quarterly_installment" value="{{old('quarterly_installment')}}" id="exampleInputEmail1" placeholder=" Quarterly">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_quarterly_installment' class="form-control" name="total_quarterly_installment" value="{{old('total_quarterly_installment')}}" id="exampleInputEmail1" placeholder="Total Quarterly">
                          <input style="display: inline-block;width: 15%;" type="integer" readonly="" id='total_quarterly_installment_count' class="form-control" name="total_quarterly_installment_count" value="{{old('total_quarterly_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='quarterly-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-quarterly-installment-label'></div>
                                        @if ($errors->has('quarterly_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('quarterly_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>

                                 <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Remaining Amount</label>
                                                        <div class="col-md-7">

                                                            <input readonly="" type="integer" id='remaining_amount' class="form-control" value=""  placeholder="Remaining amount">
                                                            Adjust to <br>
                                                            <ul>
                                                                <li><input type="radio" id="adjust" name="adjust" onclick="adjustAmount(1)" > Installment</li>
                                                                <li><input type="radio" name="adjust" id="adjust" onclick="adjustAmount(2)"> Semi-Installment</li>
                                                            </ul>

                                <div style="color:black;font-size: 11px;" class="help-block" id='remaining-amount-label'></div>
                                                        </div>
                                                    </div>
                            </div>

                            <div class="clearfix"></div>



                            <div class="input_fields_wrap1">

        <button type="button" style="float: left!important;" class="btn btn-primary add_field_button" >Add Payment</button>
        <div class="clearfix"></div>
        @foreach($property->statement as $statement)
        @if($statement->payment_head == \App\CustomerStatement::other && $statement->received == 0)

         <div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Add Extra Payment<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="add_amount[]" value="{{$statement->due}}" onkeyup="addPayment()" placeholder="Amount"><input style="display: inline-block;width: 49%;" type="date" value="{{$statement->due_date}}" class="form-control" name="add_date[]"  placeholder="Total Quarterly"></div> </div><a href="#" class="remove_field">Remove</a>
         @endif
         @endforeach
    </div>
 <div class="clearfix"></div>
   

                        </div>
                    

                

<!---Custom-->
@if($property->schedular_type == \App\CustomerProperty::inst_custom)
<div id="custom" >
    <?php $count = 1;?>
    <div class="clearfix"></div>
        <div class="input_fields_wrap2">
    
@foreach($property->statement as $statement)

@if($statement->payment_head == \App\Receipt::installment)
@if($statement->balance > 0)
    <div class="col-md-10">
                <div class="form-group">
                                                        <label class="control-label col-md-3">Installment-{{$count++}} <span style="color: red">*</span></label>
                                                        <div class="col-md-9">

                                                            <input style="display: inline-block;width: 49%;" type="date" id='installment' class="form-control" name="custom_date[]" value="{{$statement->due_date}}"  placeholder="Date">

                                                            <input style="display: inline-block;width: 49%;" type="integer"  class="form-control" value="{{$statement->due}}" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount">
                                                            
                                        

                                                        </div>
                                                    </div>
                                                    <a href="#" class="remove_field">Remove</a>
                            </div>
                            
                            @endif
                            @endif
                            @endforeach

    

    

        
        <div class="clearfix"></div>
    </div>
    <button type="button" style="float: left!important;" class="btn btn-primary add_field_button2" >Add Installment</button>&nbsp;&nbsp;&nbsp;
    <input style="display: inline-block;width: 30%;" type="integer" readonly="" id='custome_rem' class="form-control"   placeholder="Remaining amount">
 <div class="clearfix"></div>
</div>

@else
<div id="custom" style="display: none;">
    

    <div class="col-md-10">
                <div class="form-group">
                                                        <label class="control-label col-md-3">Installment <span style="color: red">*</span></label>
                                                        <div class="col-md-9">

                                                            <input style="display: inline-block;width: 49%;" type="date" id='installment' class="form-control" name="custom_date[]"  placeholder="Date">

                                                            <input style="display: inline-block;width: 49%;" type="integer"  class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount">
                                                            
                                        

                                                        </div>
                                                    </div>
                            </div>
    

    <div class="clearfix"></div>
        <div class="input_fields_wrap2">

        
        <div class="clearfix"></div>
    </div>
    <button type="button" style="float: left!important;" class="btn btn-primary add_field_button2" >Add Installment</button>&nbsp;&nbsp;&nbsp;
    <input style="display: inline-block;width: 30%;" type="integer" readonly="" id='custome_rem' class="form-control"   placeholder="Remaining amount">
 <div class="clearfix"></div>
</div>


@endif



<!-- Custom End -->
</div>
                              
                        </div>
                    </div>

                    

<input type="hidden" name="rem_amount" id="rem_amount" value="{{$rem_amount}}">
<input type="hidden" id="t_inst" value="{{$total_installment}}">
<input type="hidden" id="p_inst" value="{{$paid_installment}}">
<input type="hidden" id="per_inst" value="{{$per_installment}}">
<input type="hidden" id="down_payment_s" value="{{$down_payment_s}}">



	</div>
</div>

<div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9" style="z-index:9999;">
                        <button type="submit" style="margin-right: 60px;" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
          
              </div>
</div>

</form>


@stop

@section('js')
<script>

    $(document).ready(function() {
    var max_fields      = 50; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap1"); //Fields wrapper
    var wrapper1         = $(".input_fields_wrap"); //Fields wrapper
    var add_button      = $(".add_field_button"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Add Extra Payment<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="add_amount[]"  placeholder="Amount"><input style="display: inline-block;width: 49%;" type="date" class="form-control" onkeyup="addPayment()" name="add_date[]"  placeholder="Total Quarterly"></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker({
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});

    //custom
$(document).ready(function() {
    var max_fields      = 100; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap2"); //Fields wrapper
    var wrapper1         = $(".input_fields_wrap2"); //Fields wrapper
    var add_button      = $(".add_field_button2"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Installment-'+ x +'<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker(
            {
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
        customPayment();
    })
});

//end custom

    function enableCustom(val) {
    document.getElementById('custom').style.display = 'block';
    document.getElementById('auto').style.display = 'none';

}

function customPayment() {

    net_amount = parseInt($('#rem_amount').val());

    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    
    if($('#registration').val())
        registration = parseInt($('#registration').val());
    else
        registration = 0;
    
    var cus_amount = 0;

    $("input[name='custom_amount[]']").each(function() {
        if(!this.value){
            cus_amount += 0;
        }
        else {
            cus_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - down_payment - registration - cus_amount;

    $('#custome_rem').val(Math.round(remaining_amount));

}

    function addPayment() {

    net_amount = parseInt($('#rem_amount').val());
    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    
    if($('#registration').val())
        registration = parseInt($('#registration').val());
    else
        registration = 0;

    monthly_installment = parseInt($('#total_installment').val());

    annual_installment = 0;

    type = parseInt($('input[name="schedule_type"]:checked').val());

    if(type == {!! \App\CustomerProperty::inst_mon_w_ann !!}) {
        annual_installment = parseInt($('#total_annual_installment').val());
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_semi !!}) {
        annual_installment = parseInt($('#total_semi_installment').val());
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_quar !!}) {
        annual_installment = parseInt($('#total_quarterly_installment').val());
    } 

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });
    

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(remaining_amount);

}

    //update the total months label
    $("#total-months").keyup(function(){

        num = $("#installment").val();
      //  $("#installment-label").text(number2TextConversion(num));

        $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months').val())));
        
        num = $("#total_installment").val();
     //   $("#total-installment-label").text(number2TextConversion(num));

     net_amount = parseInt($('#rem_amount').val());
    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    
    if($('#registration').val())
        registration = parseInt($('#registration').val());
    else
        registration = 0;

    monthly_installment = parseInt($('#total_installment').val());

    annual_installment = 0;

    if(type == {!! \App\CustomerProperty::inst_mon_w_ann !!}) {
        annual_installment = parseInt($('#total_annual_installment').val());
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_semi !!}) {
        annual_installment = parseInt($('#total_semi_installment').val());
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_quar !!}) {
        annual_installment = parseInt($('#total_quarterly_installment').val());
    } 

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });
    

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(remaining_amount);


    });

    var type = {!! $property->schedular_type !!};

    $('#total-months').val(parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()) );

    $('#total_annual_installment_count').val(Math.round((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val())) / 12));

    $('#total_semi_installment_count').val(Math.round((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val())) / 6));

    $('#total_quarterly_installment_count').val(Math.round((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val())) / 3));

    $('#installment').val(parseInt($('#per_inst').val()));
    $('#total_installment').val(parseInt($('#per_inst').val()) * parseInt($('#total-months').val()));

    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

    remaining_amount = parseInt($('#rem_amount').val()) - ( parseInt($('#per_inst').val()) * parseInt($('#total-months').val())) - down_payment;

    $('#annual-installment').val( Math.round(remaining_amount / parseInt($('#total_annual_installment_count').val())));
    $('#total_annual_installment').val( Math.round(remaining_amount));

    $('#semi-installment').val( Math.round(remaining_amount / parseInt($('#total_semi_installment_count').val())));
    $('#total_semi_installment').val( Math.round(remaining_amount));

    $('#quarterly-installment').val( Math.round(remaining_amount / parseInt($('#total_quarterly_installment_count').val())));
    $('#total_quarterly_installment').val( Math.round(remaining_amount));

    $('#remaining_amount').val(0);


    if(type == {!! \App\CustomerProperty::inst_mon !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_mon !!} + "]").prop('checked', true);
        disableAnn({!! \App\CustomerProperty::inst_mon !!});
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_ann !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_mon_w_ann !!} + "]").prop('checked', true);
        enableAnn();
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_semi !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_mon_w_semi !!} + "]").prop('checked', true);
       enableSemi();
    }
    else if(type == {!! \App\CustomerProperty::inst_mon_w_quar !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_mon_w_quar !!} + "]").prop('checked', true);
        enableQuar();
    }
    else if(type == {!! \App\CustomerProperty::inst_semi !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_semi !!} + "]").prop('checked', true);
       disableAnn({!! \App\CustomerProperty::inst_semi !!});
    }
    else if(type == {!! \App\CustomerProperty::inst_quar !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_quar !!} + "]").prop('checked', true);
        disableAnn({!! \App\CustomerProperty::inst_quar !!});
    }
    else if(type == {!! \App\CustomerProperty::inst_ann !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_ann !!} + "]").prop('checked', true);
        disableAnn({!! \App\CustomerProperty::inst_ann !!});
    }
    else if(type == {!! \App\CustomerProperty::inst_custom !!}) {
        $("input[name=schedule_type][value=" + {!! \App\CustomerProperty::inst_custom !!} + "]").prop('checked', true);
        enableCustom({!! \App\CustomerProperty::inst_custom !!});
        customPayment();
    }



    function enableAnn() {
    $('#remaining_amount').val(0);
    document.getElementById('ann_div').style.display = 'block';
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';

    price = parseInt($('#rem_amount').val());
    count = $('#total_annual_installment_count').val();

     $('#installment').val( parseInt($('#per_inst').val()));

    $('#total_installment').val(parseInt($('#per_inst').val()) * parseInt($('#total-months').val()));

    net_amount = parseInt($('#rem_amount').val());
    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    monthly_installment = parseInt($('#total_installment').val());

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - monthly_installment - add_amount - down_payment;

     $('#annual-installment').val( Math.round(remaining_amount / count));

    $('#total_annual_installment').val( Math.round(remaining_amount));

}
function enableQuar() {
    $('#remaining_amount').val(0);
    document.getElementById('quar_div').style.display = 'block';
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('ann_div').style.display = 'none';

    price = $('#net_amount').val();
    count = $('#total_quarterly_installment_count').val();

     $('#installment').val( parseInt($('#per_inst').val()));

    $('#total_installment').val(parseInt($('#per_inst').val()) * parseInt($('#total-months').val()));

    net_amount = parseInt($('#rem_amount').val());
    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    monthly_installment = parseInt($('#total_installment').val());

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount- monthly_installment - add_amount - down_payment;

     $('#quarterly-installment').val( Math.round(remaining_amount / count));
    $('#total-months').val(parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()));

    $('#total_quarterly_installment').val( Math.round(remaining_amount));

}

function enableSemi() {
    $('#remaining_amount').val(0);
    document.getElementById('semi_div').style.display = 'block';
    document.getElementById('ann_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';

    price = $('#net_amount').val();
    count = $('#total_semi_installment_count').val();

    $('#installment').val( parseInt($('#per_inst').val()));

    $('#total_installment').val(parseInt($('#per_inst').val()) * parseInt($('#total-months').val()));

    net_amount = parseInt($('#rem_amount').val());
    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;
    monthly_installment = parseInt($('#total_installment').val());

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - monthly_installment - add_amount - down_payment;

    $('#semi-installment').val( Math.round(remaining_amount / count));
    $('#total-months').val(parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()));

    $('#total_semi_installment').val( Math.round(remaining_amount));

}
function disableAnn(val) {
$('#remaining_amount').val(0);
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('ann_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';
    price = $('#rem_amount').val();

    if(val == {{\App\CustomerProperty::inst_mon}}) {

        net_amount = parseInt($('#rem_amount').val());
        $('#total_installment').val(Math.round(net_amount));

        $('#installment').val(Math.round((net_amount)/parseInt($('#t_inst').val()) - parseInt($('#p_inst').val())));

        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val(parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()));
    }
    else if(val == {{\App\CustomerProperty::inst_quar}}) {

        net_amount = parseInt($('#rem_amount').val());
        if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;

        $('#total_installment').val(Math.round(net_amount));

        $('#installment').val(Math.round((net_amount)/(parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))));
        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val() / 3))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))/3)));

    }
    else if(val == {{\App\CustomerProperty::inst_semi}}) {

        net_amount = parseInt($('#rem_amount').val());
        if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;

        $('#total_installment').val(Math.round(net_amount));

        $('#installment').val(Math.round((net_amount)/(parseInt((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))/6))));

        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()/6))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))/6)));

    }
    else if(val == {{\App\CustomerProperty::inst_ann}}) {

        net_amount = parseInt($('#rem_amount').val());
        if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;
        $('#total_installment').val(Math.round(net_amount));

        $('#installment').val(Math.round((net_amount)/(parseInt((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))/12))));
        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()/12))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt((parseInt($('#t_inst').val()) - parseInt($('#p_inst').val()))/12)));

    }



}

$('#total_annual_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_annual_installment_count').val();

    $('#annual-installment').val($('#total_annual_installment').val()/count);

    //$('#annual-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});

$('#total_semi_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_semi_installment_count').val();

    $('#semi-installment').val($('#total_semi_installment').val()/count);

    //$('#semi-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});

$('#total_quarterly_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_quarterly_installment_count').val();

    $('#quarterly-installment').val($('#total_quarterly_installment').val()/count);

    //$('#quarterly-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});







//update the six installment fee label
    $("#annual-installment").keyup(function(){
    num = $("#annual-installment").val();

    count = $('#total_annual_installment_count').val();


   $('#total_annual_installment').val(Math.round(parseInt($("#annual-installment").val()) * count));


   net_amount = parseInt($('#rem_amount').val());
   if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;
   monthly_installment = parseInt($('#total_installment').val());
   annual_installment = parseInt($('#total_annual_installment').val());

   var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

remaining_amount = net_amount - monthly_installment - annual_installment - add_amount;

$('#remaining_amount').val(Math.round(remaining_amount));



});

//update the semi installment fee label
    $("#semi-installment").keyup(function(){
    num=$("#semi-installment").val();

    count = $('#total_semi_installment_count').val();

   $('#total_semi_installment').val(Math.round(parseInt($("#semi-installment").val()) * count));

    num = $("#total_semi_installment").val();

    net_amount = parseInt($('#rem_amount').val());

    if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;

    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = parseInt($('#total_semi_installment').val());
    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

remaining_amount = net_amount- monthly_installment - annual_installment - add_amount;

$('#remaining_amount').val(Math.round(remaining_amount));

});

//update the quarterly installment fee label
    $("#quarterly-installment").keyup(function(){
    num=$("#quarterly-installment").val();

    count = $('#total_quarterly_installment_count').val();


   $('#total_quarterly_installment').val(Math.round(parseInt($("#quarterly-installment").val()) * count));

    num=$("#total_quarterly_installment").val();




   net_amount = parseInt($('#rem_amount').val());

   if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;

monthly_installment = parseInt($('#total_installment').val());
annual_installment = parseInt($('#total_quarterly_installment').val());

var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

remaining_amount = net_amount - monthly_installment - annual_installment - add_amount;

$('#remaining_amount').val(Math.round(remaining_amount));

});

//update the installment label
    $("#installment").keyup(function(){
    num = $("#installment").val();

   $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months').val())));

   num = $("#total_installment").val();

   net_amount = parseInt($('#rem_amount').val());

   if($('#down_payment_s').val())
        down_payment = parseInt($('#down_payment_s').val());
    else
        down_payment = 0;

        net_amount = net_amount - down_payment;

   monthly_installment = parseInt($('#total_installment').val());

//annual_installment = parseInt($('#total_annual_installment').val());
annual_installment = 0;
        val = parseInt($('input[name="schedule_type"]:checked').val());
        if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
            annual_installment = $('#total_semi_installment').val();
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
            annual_installment = $('#total_annual_installment').val();
        }

var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });
    remaining_amount = net_amount - monthly_installment - add_amount - annual_installment;

//$('#total_annual_installment').val(annual_installment + remaining_amount);

//$('#annual-installment').val((annual_installment + remaining_amount) / 5);

$('#remaining_amount').val(Math.round(remaining_amount));

//$('#remaining_amount').val(0);

});

    function number2TextConversion(num) {

    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';

    return str;
}

function adjustAmount(val) {

    amount = parseInt($('#remaining_amount').val());

    

    if(amount) {
        if(val == 1) { //amount adjustment to per installment
            $('#total_installment').val(parseInt($('#total_installment').val()) + amount);
            $('#installment').val(Math.round( ( parseInt($('#total_installment').val())) / parseInt($('#total-months').val()) ) );

        }
        else {
            val = parseInt($('input[name="schedule_type"]:checked').val());
        if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
            $('#total_semi_installment').val(parseInt($('#total_semi_installment').val()) + amount);
            $('#semi-installment').val(Math.round( ( parseInt($('#total_semi_installment').val())) / parseInt($('#total_semi_installment_count').val()) ) );
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
            $('#total_annual_installment').val(parseInt($('#total_annual_installment').val()) + amount);
            $('#annual-installment').val(Math.round( ( parseInt($('#total_annual_installment').val())) / parseInt($('#total_annual_installment_count').val()) ) );
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {

            $('#total_quarterly_installment').val(parseInt($('#total_quarterly_installment').val()) + amount);
            $('#quarterly-installment').val(Math.round( ( parseInt($('#total_quarterly_installment').val())) / parseInt($('#total_quarterly_installment_count').val()) ) );
        }

        }

        $('#remaining_amount').val(0);
        $("input:radio[name='adjust']").each(function(i) {
            this.checked = false;
        });
       // updateCurrency();
    }
    }

    $('input:checkbox[id^="update_schedule"]').click(function(){
            if($(this).prop("checked") == true){
                $('#update_schedule_div').css('display','block');
            }
            else if($(this).prop("checked") == false){
                $('#update_schedule_div').css('display','none');
            }
        });
</script>


@stop
