@extends('layouts.app')

@section('title')
Print | Agreement
@stop

@section('css')

 <link href="{{asset('css/print/style.css')}}" rel="stylesheet"><!--
 <link href="{{asset('css/print/bootstrap.css')}}" rel="stylesheet"> -->
@stop

@section('content')
    <div class="container mt-44 printableArea">
    	<br><br><br>
    	<div class="text-center">
    		<h2 class="text-uppercase"><u>Terms and condtions</u></h2>
    	</div>
    	<div class="mt-44">
    		<p style="letter-spacing:1px"><b>1. Details of Shop</b></p><br>
    		<div class="row">
                <div class="col-sm-1 col-xs-1">&nbsp;</div>
            <div class="col-sm-5 col-xs-5">
                <div class="row">
                    <div class="col-sm-4 col-xs-4">a. Shop No.</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->inventory->unit_number}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-5 col-xs-5">c. Rate / Sq-ft.</div>
                    <div class="col-sm-7 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{number_format(($statement->inventory->total_price - $statement->inventory->extra_charges) / $statement->inventory->size->name)}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">e. Floor</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->inventory->floor->name}}</b></p>
                </div><br><br>
                    </div>
                </div>
            </div>
            <div class="col-sm-5 col-xs-5">
                <div class="row">
                    <div class="col-sm-4 col-xs-5">b. Total Area.</div>
                    <div class="col-sm-8 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->inventory->size->name}} {{env('SIZE')}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">d. Type.</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->inventory->type->name}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-7">f. Extra Charges(10%).</div>
                    <div class="col-sm-8 col-xs-5">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{number_format($statement->inventory->extra_charges)}}</b></p>
                </div><br><br>
                    </div>
                </div>
            </div>
        </div>
    	</div>
        <div class="mt-44">
            <p style="letter-spacing:1px"><b>2. Payment schedule</b></p><br>
            <div class="row">
                <div class="col-sm-1 col-xs-1">&nbsp;</div>
            <div class="col-sm-5 col-xs-5">
                <div class="row">
                    <div class="col-sm-5 col-xs-5">1. On Booking.</div>
                    <div class="col-sm-7 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{number_format($receipt->amount)}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-5 col-xs-5">3. D/P Adujusted Amount</div>
                    <div class="col-sm-7 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>15000</b></p>
                </div><br><br>
                    </div>
                </div>
            </div>
            <div class="col-sm-5 col-xs-5">
                <div class="row">
                    <div class="col-sm-4 col-xs-5">2. After Discount.</div>
                    <div class="col-sm-8 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{number_format($statement->net_pay)}}</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-5 col-xs-5">5. Remaining Amount.</div>
                    <div class="col-sm-7 col-xs-7">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{number_format($statement->net_pay-$receipt->amount)}}</b></p>
                </div><br><br>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    	<div class="text-center mt-44">
    		<h3><u>On Behalf of (Exective Business Center)</u></h3>
    	</div>
    	<div class="row">
    		<div class="mt-44">
            <div class="row">
            <div class="col-sm-6 col-xs-6">
                <p style="letter-spacing:1px"><b>SELLER</b></p><br>
                <p class="text-right"><u>Exective Business Center</u></p><br>
                <div class="row">
                    <div class="col-sm-4 col-xs-4">Sig Director 1:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">Sig Director 2:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                </div>
                 <div class="col-sm- col-xs-4">Stamp:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
            </div>
        </div>
            <div class="col-sm-6 col-xs-6">
                <p style="letter-spacing:1px"><b>BUYER</b></p><br>
                <div class="row"><br><br><br>
                    <div class="col-sm-4 col-xs-4">Signature:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">Name:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->customer->name}}</b></p>
                </div><br><br>
                    </div>
                <div class="col-sm-4 col-xs-4">CNIC:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b><?php $c = str_split($statement->customer->cnic, 1);?>
                        <?php for($i =0;$i<count($c) ; $i++) {?>
                            @if($i ==5 || $i == 12)
                            -
                            @endif
                        {{$c[$i]}}
                    <?php }?></b></p>
                </div><br><br>
                    </div>
                </div>
            </div>
        </div>
    	</div>
        </div>
        <div class="row">
            <div class="mt-44">
            <div class="row">
            <div class="col-sm-6 col-xs-6">
                <p style="letter-spacing:1px"><b>Witness:</b></p><br>
                <div class="row">
                    <div class="col-sm-4 col-xs-4">Signature:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">Name:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                </div>
                 <div class="col-sm- col-xs-4">CNIC:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
            </div>
        </div>
            <div class="col-sm-6 col-xs-6">
                <p style="letter-spacing:1px"><b>Witness:</b></p><br>
                <div class="row">
                    <div class="col-sm-4 col-xs-4">Signature:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>&nbsp;</b></p>
                </div><br><br>
                    </div>
                    <div class="col-sm-4 col-xs-4">Name:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>{{$statement->customer->nominee_name}}</b></p>
                </div><br><br>
                    </div>
                <div class="col-sm-4 col-xs-4">CNIC:</div>
                    <div class="col-sm-8 col-xs-8">
                        <div class="underline" style="width: 100%">
                     <p class="text-center text-uppercase"><b>

                        <?php $c = str_split($statement->customer->nominee_cnic, 1);?>
                        <?php for($i =0;$i<count($c) ; $i++) {?>
                            @if($i ==5 || $i == 12)
                            -
                            @endif
                        {{$c[$i]}}
                    <?php }?>

                        </b></p>
                </div><br><br>
                    </div>
                </div>
            </div>
        </div>
        </div>
        </div>
</div>
    </div>
@stop

@section('js')

<script>
 window.setTimeout('window.print()',2000);
window.onafterprint = function(){
   window.close();
}

</script>
@stop