@extends('layouts.app')

@section('title')
All Transfer Properties 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Transfers</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
								<a href="{{route('transfer.addView')}}" class="btn  btn-primary">
									<i class="fa fa-plus-square"></i>&nbsp; Add new Transfer
								</a>
							</div>
                            <h3 class="box-title">All Transfers</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
<!--                                            <th>Block & unit</th>
                                            <th>unit Size</th>-->
                                            <th>Unit #</th>
                                            <th>Owner Name</th>
                                            <th>Transfer to</th>
                                            <th>Cost Amount</th>
                                            <th>Paid Amount</th>

                                            <th>Transfer Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($allTransfers as $t)
                                        <tr>
                                            <td>{{$count++}}</td>

                                             <td><b>{{$t->property->inventory->unit_number}}</b></td>
                                            <td>{{$t->owner ? $t->owner->name: ''}}</td>
                                            <td>{{$t->transfer ? $t->transfer->name: ''}}</td>

                                             <td>{{number_format($t->property->net_pay)}} PKR</td>
                                            <td>{{number_format($t->amount_paid)}} PKR</td>




                                            <td>{{date('d-m-Y', strtotime($t->transfer_date)) }}</td>

                                            <td class="text-nowrap">
                                                <a href="{{route('transfer.detail',['id'=>$t->id])}}" data-toggle="tooltip" data-original-title="View"> <i class="fa fa-eye text-inverse m-r-10"></i> </a>
<!--                                                <a href="{{route('transfer.editView',['id'=>$t->id])}}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i> </a>-->
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop