@extends('layouts.app')

@section('title')
Update Statement Schedule 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li ><a href="{{route('statement.all')}}">Statements</a></li>
        <li class="active">Update Statement</li>
      </ol>
@stop

@section('css')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<style type="text/css">
    
</style>

@stop

@section('content')

<div class="container-fluid">
    <div class="row">

            <form method='post' class="form-horizontal" action="{{route('statement.update')}}" enctype="multipart/form-data">
                {{csrf_field()}}
        <div class="col-lg-12 col-sm-12 col-xs-12">
             @if($errors->any())
                        <div class="white-box"><h2>Errors</h2><ul>
    {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
</ul></div>@endif

<div class="col-lg-12">
            <div class="white-box">
                <h3 class="box-title">Unit's Detail</h3>
                            <hr>

                <div class="table-responsive pull-left" >
                    <table class="table" >

                        <tbody>
                            <tr>
                                <td >Floor:</td>
                                <td > {{$property->inventory->floor->name}} </td>
                            </tr>
                            <tr>
                                <td >Category:</td>
                                <td>@foreach($property->inventory->categories as $c)

                                                        @if($loop->last)
                                                        {{$c->category->name}} ({{$c->category->percent}} %)
                                                        @else
                                                        {{$c->category->name}} ({{$c->category->percent}} %),
                                                        @endif
                                                    @endforeach</td>
                            </tr>
                            <tr>
                                <td>Size:</td>
                                <td>
                                                    {{$property->inventory->size->name}}  {{env('SIZE')}}</td>

                            </tr>
                            <tr>
                                <td>Total Price:</td>
                                <td> {{number_format($property->inventory->total_price - $property->inventory->extra_amount)}} </td>
                            </tr>
                            <tr>
                                <td>Net Amt.:</td>
                                <td> {{number_format($property->net_pay)}} </td>
                            </tr>


                            <!-- <tr>
                                <td>Discount:</td>
                                <td> {{$property->discount}} </td>
                            </tr> -->

                        </tbody>
                    </table>
                </div>
                <div class="table-responsive pull-right">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td >Unit No.:</td>
                                <td>{{$property->inventory->unit_number}}</td>
                            </tr>
                            <tr>
                                <td>Unit Type:</td>
                                <td>{{$property->inventory->type->name}}</td>
                            </tr>
                            <tr>
                                <td>Discount:</td>
                                <td> {{$property->discount }} </td>
                            </tr>
                            <tr>
                                <td>Category Cost:</td>
                                <td> {{number_format($property->inventory->extra_amount) }} </td>
                            </tr>
                            <tr>
                                <td >Booking Date:</td>
                                <td> {{date('d-m-Y', strtotime($property->booking_date)) }}</td>
                            </tr>
                            <tr>
                                <td >Schedule Start Date:</td>
                                @if($property->schedule_start_date)
                                <td> {{date('d-m-Y', strtotime($property->schedule_start_date)) }}</td>
                                @endif
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="clear"></div>
            </div>
        </div>

                  <div class="col-lg-12 col-sm-12 col-xs-12">
                        <div class="white-box">
                            <h3 class="box-title">Payment Scheduler</h3>
                            <hr>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Amount Schedule in <span style="color: red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input type='radio' onchange="manToPer()" name="amount_schedule" value='1' > Percentage<br>
                                                            <input type='radio' onchange="perToMan()"  name="amount_schedule" value='2' checked="" > Manual
                                        @if ($errors->has('amount_schedule'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount_schedule') }}</strong>
                                    </span>
                                @endif</div>
                                                    </div>
                            </div>

                             <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Schedule Start Date <span style="color:red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input type="date" class="form-control" name="schedule_start_date" value="{{old('schedule_start_date')}}" id="exampleInputEmail1" placeholder="Enter Schedule Start Date">
                                        @if ($errors->has('schedule_start_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_start_date') }}</strong>
                                    </span>
                                @endif</div>
                                                    </div>
                            </div>
                            <div class='clearfix'></div>
                             
                            
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Down Payment</label>
                                                        <div class="col-md-7">

                                                            <input readonly="" type="integer" id='down_payment1' class="form-control" name="down_payment1" value="{{$receipt->amount}}">
                                                            <div style="color:black;font-size: 11px;" class="help-block" id='down-payment-label'></div>
                                                        </div>

                                                    </div>


                            </div>
                             <!-- <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Down Payment<span style="color: red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input type="integer" id='down-payment' class="form-control" name="down_payment" value="{{old('down_payment')}}" id="exampleInputEmail1" placeholder="Enter Down Payment">
                                        @if ($errors->has('down_payment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('down_payment') }}</strong>
                                    </span>
                                @endif

                            </div> -->
                            <div class="clearfix"></div>
                            <div class="col-md-12">

                                <div class="form-group">
                                  <label class="control-label col-md-2">Schedular Type<span style="color: red">*</span></label>
                                    <div class="col-md-10">
                                        <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)" name="schedule_type" value='{{\App\CustomerProperty::inst_mon}}' > Monthly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="enableQuar()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_quar}}' checked="" > Monthly with Quarterly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="enableSemi()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_semi}}' checked="" > Monthly with Semi Annually
                                    </div>
                                     <div class="col-md-3">
                                        <input type='radio' onchange="enableAnn()"  name="schedule_type" value='{{\App\CustomerProperty::inst_mon_w_ann}}' checked="" > Monthly with Annually
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_quar}}'  > Quarterly
                                    </div>
                                    <div class="col-md-3">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_semi}}'  > SemiAnnually
                                    </div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="disableAnn(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_ann}}'  > Annually
                                    </div>
                                    <div class="col-md-2">
                                        <input type='radio' onchange="enableCustom(this.value)"  name="schedule_type" value='{{\App\CustomerProperty::inst_custom}}'  > Custom
                                    </div>
                                        @if ($errors->has('schedule_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('schedule_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                                                    </div>
                            </div>



                            <div class="clearfix"></div>

                            <div id = "auto">

                           <div class="col-md-10">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">Per Installment <span style="color: red">*</span></label>
                                                        <div class="col-md-7">

                                                            <input style="display: inline-block;width: 49%;" type="integer" id='installment' class="form-control" name="installment" value="{{old('installment')}}" id="exampleInputEmail1" placeholder="Per installment">

                                                            <input style="display: inline-block;width: 49%;" type="integer" readonly="" id='total_installment' class="form-control" name="total_installment" value="{{old('total_installment')}}" placeholder="Total amount">
                                                            <div style="display: inline-block;width: 49%;color:black;font-size: 11px;" class="help-block" id='installment-label'></div>
                                                            <div style="display: inline-block;width: 49%;color:black;font-size: 11px;" class="help-block" id='total-installment-label'></div>
                                        @if ($errors->has('installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>

                                                        <div class="col-md-2">
                                                    <div class="form-group">
                                                        <!-- <label class="control-label col-md-5">Total Installments (Months) <span style="color: red">*</span></label> -->
                                                        <div class="col-md-12">

                                                            <input type="integer" id='total-months' class="form-control" name="installment_plan" value="{{old('installment_plan')}}" id="exampleInputEmail1" placeholder="total installments">
                                        @if ($errors->has('installment_plan'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('installment_plan') }}</strong>
                                    </span>
                                @endif
                                <div style="color:black;font-size: 11px;" class="help-block" id='total-months-label'></div>
                                                        </div>
                                                    </div>
                            </div>
                                                    </div>
                            </div>


                                 <div class="col-md-10" id="ann_div">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Annual Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='annual-installment' class="form-control" name="annual_installment" value="{{old('annual_installment')}}" id="exampleInputEmail1" placeholder=" Annual">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_annual_installment' class="form-control" name="total_annual_installment" value="{{old('total_annual_installment')}}" id="exampleInputEmail1" placeholder="Total Annual">
                          <input style="display: inline-block;width: 15%;" type="integer" id='total_annual_installment_count' class="form-control" name="total_annual_installment_count" value="{{old('total_annual_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='annual-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-annual-installment-label'></div>
                                        @if ($errors->has('annual_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('annual_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>

                                 <div class="col-md-10" id="semi_div" style="display: none">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Semi Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='semi-installment' class="form-control" name="semi_installment" value="{{old('semi_installment')}}" id="exampleInputEmail1" placeholder=" Semi">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_semi_installment' class="form-control" name="total_semi_installment" value="{{old('total_semi_installment')}}" id="exampleInputEmail1" placeholder="Total Semi Annually">
                          <input style="display: inline-block;width: 15%;" type="integer" id='total_semi_installment_count' class="form-control" name="total_semi_installment_count" value="{{old('total_semi_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='semi-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-semi-installment-label'></div>
                                        @if ($errors->has('semi_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('semi_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>

                                 <div class="col-md-10" id="quar_div" style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Quarterly Installments <br> <span style="color: red">*</span></label>
                                       <div class="col-md-9">
                          <input style="display: inline-block;width: 40%;" type="integer" id='quarterly-installment' class="form-control" name="quarterly_installment" value="{{old('quarterly_installment')}}" id="exampleInputEmail1" placeholder=" Quarterly">

                          <input style="display: inline-block;width: 40%;" type="integer" readonly="" id='total_quarterly_installment' class="form-control" name="total_quarterly_installment" value="{{old('total_quarterly_installment')}}" id="exampleInputEmail1" placeholder="Total Quarterly">
                          <input style="display: inline-block;width: 15%;" type="integer" readonly="" id='total_quarterly_installment_count' class="form-control" name="total_quarterly_installment_count" value="{{old('total_quarterly_installment_count')}}" id="exampleInputEmail1" placeholder="Count">
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='quarterly-installment-label'></div>
                          <div style="display: inline-block;width: 40%;color:black;font-size: 11px;" class="help-block"  id='total-quarterly-installment-label'></div>
                                        @if ($errors->has('quarterly_installment'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('quarterly_installment') }}</strong>
                                    </span>
                                @endif

                                                        </div>
                                                    </div>
                                 </div>




                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-5">Remaining Amount</label>
                                                        <div class="col-md-7">

                                                            <input readonly="" type="integer" id='remaining_amount' class="form-control" value="{{old('remaining_amount')}}"  placeholder="Remaining amount">
                                                            Adjust to <br>
                                                            <ul>
                                                                <li><input type="radio" id="adjust" name="adjust" onclick="adjustAmount(1)" > Installment</li>
                                                                <li><input type="radio" name="adjust" id="adjust" onclick="adjustAmount(2)"> Semi-Installment</li>
                                                            </ul>

                                <div style="color:black;font-size: 11px;" class="help-block" id='remaining-amount-label'></div>
                                                        </div>
                                                    </div>
                            </div>

                            <div class="clearfix"></div>
                             <div class="input_fields_wrap1">
        <button type="button" style="float: left!important;" class="btn btn-primary add_field_button" >Add Payment</button>
        <div class="clearfix"></div>
    </div>
 <div class="clearfix"></div>

</div>

 <!---Custom-->
<div id="custom" style="display: none;">

    <div class="col-md-10">
                <div class="form-group">
                                                        <label class="control-label col-md-3">Installment <span style="color: red">*</span></label>
                                                        <div class="col-md-9">

                                                            <input style="display: inline-block;width: 49%;" type="date" id='installment' class="form-control" name="custom_date[]"  placeholder="Date">

                                                            <input style="display: inline-block;width: 49%;" type="integer"  class="form-control" name="custom_amount[]" onkeyup="customPayment()"  placeholder="Amount">
                                                            
                                        

                                                        </div>
                                                    </div>
                            </div>
    

    <div class="clearfix"></div>
                             <div class="input_fields_wrap2">
        
        <div class="clearfix"></div>
    </div>
    <button type="button" style="float: left!important;" class="btn btn-primary add_field_button2" >Add Installment</button>&nbsp;&nbsp;&nbsp;
    <input style="display: inline-block;width: 30%;" type="integer" readonly="" id='custome_rem' class="form-control"   placeholder="Remaining amount">
 <div class="clearfix"></div>
</div>

<!-- Custom End -->


                                    </div>
                                </div>


                                 <div class="col-md-12">
                        <button style="float: right;" type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>



                        </div>
                    </div>
                    <input type="hidden" id="net_amount" name="net_amount" value="{{$property->net_pay}}">
<input type="hidden" id="property_id"  name="property_id" value="{{$property->id}}">
</form>
    </div>
</div>
<input type='hidden' id="registration_per">
<input type='hidden' id="down_payment_per">
<input type='hidden' id="total_month_per">
<input type='hidden' id="annual_installment_per">
<input type='hidden' id="monthly_installment_per">


@stop

@section('js')
<script>

    var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
    var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];

    function number2TextConversion(num) {

    if ((num = num.toString()).length > 9) return 'overflow';
    n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
    if (!n) return; var str = '';
    str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
    str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lac ' : '';
    str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
    str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
    str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + 'only ' : '';

    return str;
}

function updateCurrency() {

    //update the downpayment label
    num = $("#down_payment1").val();
    $("#down-payment-label").text(number2TextConversion(num));
    
    //update the annual installment label
    num = $("#annual-installment").val();
    $("#annual-installment-label").text(number2TextConversion(num));
    

    //update the total annual installment label
    num = $("#total_annual_installment").val();
    $("#total-annual-installment-label").text(number2TextConversion(num));
    
    //update the semi installment label
    num = $("#semi-installment").val();
    $("#semi-installment-label").text(number2TextConversion(num));

    //update the total semi installment label
    num = $("#total_semi_installment").val();
    $("#total-semi-installment-label").text(number2TextConversion(num));

    //update the quarterly installment label
    num = $("#quarterly-installment").val();
    $("#quarterly-installment-label").text(number2TextConversion(num));

    //update the total quarterly installment label
    num = $("#total_quarterly_installment").val();
    $("#total-quarterly-installment-label").text(number2TextConversion(num));

    //update the installment label
    num = $("#installment").val();
    $("#installment-label").text(number2TextConversion(num));
    

    //update the total_installment label
    num = $("#total_installment").val();
    $("#total-installment-label").text(number2TextConversion(num));

}

$(document).ready(function() {
    var max_fields      = 50; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap1"); //Fields wrapper
    var wrapper1         = $(".input_fields_wrap"); //Fields wrapper
    var add_button      = $(".add_field_button"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Add Extra Payment<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" onkeyup="addPayment()" type="integer" class="form-control" name="add_amount[]" placeholder="Amount"><input style="display: inline-block;width: 49%;" type="date" class="form-control" name="add_date[]"  placeholder="Total Quarterly"></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker( {
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});

    //custom
$(document).ready(function() {
    var max_fields      = 100; //maximum input boxes allowed
    var wrapper         = $(".input_fields_wrap2"); //Fields wrapper
    var wrapper1         = $(".input_fields_wrap2"); //Fields wrapper
    var add_button      = $(".add_field_button2"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function(e){ //on add input button click
        e.preventDefault();
        if(x < max_fields){ //max input box allowed
            x++; //text box increment
            $(wrapper).append('<div class="clearfix"><br><div class="form-group"><label class="control-label col-md-3">Installment-'+ x +'<br> <span style="color: red">*</span></label><div class="col-md-9"><input style="display: inline-block;width: 49%;" type="date" class="form-control" name="custom_date[]" placeholder="Date"><input style="display: inline-block;width: 49%;" type="integer" class="form-control" name="custom_amount[]" onkeyup="customPayment()" placeholder="Amount"></div> </div><a href="#" class="remove_field">Remove</a>'); //add input box
            $(".bdpk").datepicker({
                dateFormat: "dd-mm-yy"
            });
        }
    });

    $(wrapper).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
    $(wrapper1).on("click",".remove_field", function(e){ //user click on remove text
        e.preventDefault(); $(this).parent('div').remove(); x--;
    })
});

//start custom

function customPayment() {

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    
    var cus_amount = 0;

    $("input[name='custom_amount[]']").each(function() {
        if(!this.value){
            cus_amount += 0;
        }
        else {
            cus_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - down_payment - registration - cus_amount;

    $('#custome_rem').val(Math.round(remaining_amount));

}


function addPayment() {

    net_amount = parseInt($('#net_amount').val());
    if($('#down_payment1').val())
        down_payment = parseInt($('#down_payment1').val());
    else
        down_payment = 0;
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = 0;

    val = parseInt($('input[name="schedule_type"]:checked').val());
    if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
        annual_installment = $('#total_semi_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
        annual_installment = $('#total_annual_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {
        annual_installment = $('#total_quarterly_installment').val();
    }

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });


    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(remaining_amount);

}



var schedule = {!! json_encode($schedule->toArray()) !!};
var info = {!! json_encode($info->toArray()) !!};

$('#down_payment_per').val(schedule.down_payment);
$('#registration_per').val(schedule.registration);
$('#annual_installment_per').val(schedule.annual_installment);
$('#monthly_installment_per').val(schedule.monthly_installment);
$('#total_month_per').val(schedule.total_months);
$('#total_annual_installment_count').val( Math.round(schedule.total_months / 12));
$('#total_semi_installment_count').val( Math.round(schedule.total_months / 6));
$('#total_quarterly_installment_count').val( Math.round(schedule.total_months / 3));

$('#down-payment').val( Math.round(parseInt(schedule.down_payment) / 100 * info.total_price));
//$('#registration').val( Math.round(schedule.registration / 100 * info.total_price));
$('#annual-installment').val( Math.round(schedule.annual_installment / 100 * info.total_price / (schedule.total_months / 12)));
$('#total-months').val( Math.round(schedule.total_months));

$('#total_annual_installment').val( Math.round(schedule.annual_installment / 100 *info.total_price));

$('#installment').val( Math.round(schedule.monthly_installment / 100 * info.total_price / (schedule.total_months)));

$('#total_installment').val( Math.round(schedule.monthly_installment / 100 * info.total_price));
updateCurrency();

</script>

    <script src="https://s3-us-west-2.amazonaws.com/s.cdpn.io/3/jquery.inputmask.bundle.js"></script>

    <script>
    $(":input").inputmask();

    $('input[type="checkbox"]').click(function(){
            if($(this).prop("checked") == true){
                $('textarea#permanent_address').val($('textarea#mailing_address').val());
            }
            else if($(this).prop("checked") == false){
                $('textarea#permanent_address').val('');
            }
        });

   </script>


   <script>

//update the six installment fee label
   //update the six installment fee label
$("#annual-installment").keyup(function(){

    num = $("#annual-installment").val();
    $("#annual-installment-label").text(number2TextConversion(num));

    count = $('#total_annual_installment_count').val();
    $('#total_annual_installment').val(Math.round(parseInt($("#annual-installment").val()) * count));

    num = $("#total_annual_installment").val();
    $("#total-annual-installment-label").text(number2TextConversion(num));

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = parseInt($('#total_annual_installment').val());

    var add_amount = 0;
    $("input[name='add_amount[]']").each(function() {
        if(!this.value)
            add_amount += 0;
        else 
            add_amount += parseInt($(this).val());
    });

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(Math.round(remaining_amount));
});


//update the semi installment fee label
 //update the semi installment fee label
$("#semi-installment").keyup(function(){
    
    num = $("#semi-installment").val();
    $("#semi-installment-label").text(number2TextConversion(num));

    count = $('#total_semi_installment_count').val();
    $('#total_semi_installment').val(Math.round(parseInt($("#semi-installment").val()) * count));

    num = $("#total_semi_installment").val();
    $("#total-semi-installment-label").text(number2TextConversion(num));

    net_amount = parseInt($('#net_amount').val())
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = parseInt($('#total_semi_installment').val());

    var add_amount = 0;
    $("input[name='add_amount[]']").each(function() {
        if(!this.value)
            add_amount += 0;
        else
            add_amount += parseInt($(this).val());
        
    });

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(Math.round(remaining_amount));

});

//update the quarterly installment fee label
$("#quarterly-installment").keyup(function(){
    
    num = $("#quarterly-installment").val();
    $("#quarterly-installment-label").text(number2TextConversion(num));

    count = $('#total_quarterly_installment_count').val();
    $('#total_quarterly_installment').val(Math.round(parseInt($("#quarterly-installment").val()) * count));

    num = $("#total_quarterly_installment").val();
    $("#total-quarterly-installment-label").text(number2TextConversion(num));

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = parseInt($('#total_quarterly_installment').val());

    var add_amount = 0;
    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;
    $('#remaining_amount').val(Math.round(remaining_amount));

});

//update the installment label
    $("#installment").keyup(function(){
        num = $("#installment").val();
        $("#installment-label").text(number2TextConversion(num));

        $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months').val())));
        
        num = $("#total_installment").val();
        $("#total-installment-label").text(number2TextConversion(num));

        net_amount = parseInt($('#net_amount').val());
        down_payment = parseInt($('#down_payment1').val());
        registration = parseInt($('#registration').val());
        monthly_installment = parseInt($('#total_installment').val());

        annual_installment = 0;
        val = parseInt($('input[name="schedule_type"]:checked').val());
        if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
            annual_installment = $('#total_semi_installment').val();
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
            annual_installment = $('#total_annual_installment').val();
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {
            annual_installment = $('#total_quarterly_installment').val();
        }

        var add_amount = 0;
        $("input[name='add_amount[]']").each(function() {
            if(!this.value) {
                add_amount += 0;
            }
            else {
                add_amount += parseInt($(this).val());
            }
        });

        remaining_amount = net_amount - registration - down_payment - monthly_installment - add_amount - annual_installment;
       
        $('#remaining_amount').val(Math.round(remaining_amount));

});

    //update the total months label
$("#total-months").keyup(function(){

        num = $("#installment").val();
        $("#installment-label").text(number2TextConversion(num));
        
        $('#total_installment').val(Math.round(parseInt($("#installment").val()) * parseInt($('#total-months').val())));

        num = $("#total_installment").val();
        $("#total-installment-label").text(number2TextConversion(num));

});



    function manToPer() {
        cost = $('#net_amount').val();
        if(cost){

        down_payment = $('#down_payment1').val();
         if(down_payment) {
             $('#down_payment1').val(((down_payment / cost) * 100).toFixed(2));

         }
         registration = $('#registration').val();
         if(down_payment) {
             $('#registration').val(((registration / cost) * 100).toFixed(2));

         }

         annual_installment = $('#annual-installment').val();
         if(annual_installment) {
             $('#annual-installment').val( ((annual_installment / cost) * 100).toFixed(2));

         }
         total_annual_installment = $('#total_annual_installment').val();
         if(total_annual_installment) {
             $('#total_annual_installment').val( ((total_annual_installment / cost) * 100).toFixed(2));

         }
         total_months = $('#total-months').val();
         if(total_months) {
             installment = $('#installment').val();
             if(installment) {
                $('#installment').val(  (((installment) / cost) * 100).toFixed(2));

            }
             total_installment = $('#total_installment').val();
             if(total_installment) {
                $('#total_installment').val(  (((total_installment) / cost) * 100).toFixed(2));

            }
         }
          updateCurrency();

    }
    }

    function perToMan() {
        cost = $('#net_amount').val();
        if(cost){

        down_payment = $('#down_payment1').val();
         if(down_payment) {
            $('#down_payment1').val(  ((down_payment * cost) / 100).toFixed(0));

         }
         registration = $('#registration').val();
         if(registration) {
            $('#registration').val(  ((registration * cost) / 100).toFixed(0));

         }


         annual_installment = $('#annual-installment').val();
         if(annual_installment) {
           $('#annual-installment').val(  ((annual_installment  * cost) / 100).toFixed(0));

         }
         total_annual_installment = $('#total_annual_installment').val();
         if(total_annual_installment) {
           $('#total_annual_installment').val(  ((total_annual_installment  * cost) / 100).toFixed(0));

         }
         total_months = $('#total-months').val();
         if(total_months) {
             installment = $('#installment').val();
             if(installment) {
               $('#installment').val(  ( (installment  * cost) / 100).toFixed(0));

               total_installment = $('#total_installment').val();
             if(total_installment) {
               $('#total_installment').val(  ( (total_installment  * cost) / 100).toFixed(0));

            }}
         }
          updateCurrency();

    }
    }

function enableAnn() {

    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

    $('#remaining_amount').val(0);
    document.getElementById('ann_div').style.display = 'block';
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';

    price = parseInt($('#net_amount').val());
    count = $('#total_annual_installment_count').val();

     $('#installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($('#total_month_per').val()))));

    $('#total_installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());

    remaining_amount = net_amount - down_payment - registration - monthly_installment;

     $('#annual-installment').val( Math.round(remaining_amount / count));
    $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));

    $('#total_annual_installment').val( Math.round(remaining_amount));

}
function enableQuar() {

    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

    $('#remaining_amount').val(0);
    document.getElementById('quar_div').style.display = 'block';
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('ann_div').style.display = 'none';

    price = $('#net_amount').val();
    count = $('#total_quarterly_installment_count').val();

     $('#installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($('#total_month_per').val()))));

    $('#total_installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());

    remaining_amount = net_amount - down_payment - registration - monthly_installment;

     $('#quarterly-installment').val( Math.round(remaining_amount / count));
    $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));

    $('#total_quarterly_installment').val( Math.round(remaining_amount));

}

function enableSemi() {

    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

    $('#remaining_amount').val(0);
    document.getElementById('semi_div').style.display = 'block';
    document.getElementById('ann_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';

    price = $('#net_amount').val();
    count = $('#total_semi_installment_count').val();

     $('#installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price / (parseInt($('#total_month_per').val()))));

    $('#total_installment').val( Math.round(parseFloat($('#monthly_installment_per').val()) / 100 * price));

    net_amount = parseInt($('#net_amount').val());
    down_payment = parseInt($('#down_payment1').val());
    registration = parseInt($('#registration').val());

    monthly_installment = parseInt($('#total_installment').val());

    remaining_amount = net_amount - down_payment - registration - monthly_installment;

     $('#semi-installment').val( Math.round(remaining_amount / count));
    $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));

    $('#total_semi_installment').val( Math.round(remaining_amount));

}
function disableAnn(val) {

    document.getElementById('custom').style.display = 'none';
    document.getElementById('auto').style.display = 'block';

$('#remaining_amount').val(0);
    document.getElementById('semi_div').style.display = 'none';
    document.getElementById('ann_div').style.display = 'none';
    document.getElementById('quar_div').style.display = 'none';
    price = $('#net_amount').val();

    if(val == {{\App\CustomerProperty::inst_mon}}) {

        net_amount = parseInt($('#net_amount').val());
        down_payment = parseInt($('#down_payment1').val());
        registration = parseInt($('#registration').val());

        $('#total_installment').val(Math.round(net_amount - down_payment - registration));

        $('#installment').val(Math.round((net_amount - down_payment - registration)/parseInt($('#total_month_per').val())));

        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val())));
    }
    else if(val == {{\App\CustomerProperty::inst_quar}}) {

        net_amount = parseInt($('#net_amount').val());
        down_payment = parseInt($('#down_payment1').val());
        registration = parseInt($('#registration').val());

        $('#total_installment').val(Math.round(net_amount - down_payment - registration));

        $('#installment').val(Math.round((net_amount - down_payment - registration)/(parseInt($('#total_month_per').val())/3)));
        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val() / 3))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/3)));

    }
    else if(val == {{\App\CustomerProperty::inst_semi}}) {

        net_amount = parseInt($('#net_amount').val());
        down_payment = parseInt($('#down_payment1').val());
        registration = parseInt($('#registration').val());

        $('#total_installment').val(Math.round(net_amount - down_payment - registration));

        $('#installment').val(Math.round((net_amount - down_payment - registration)/(parseInt($('#total_month_per').val())/6)));

        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()/6))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/6)));

    }
    else if(val == {{\App\CustomerProperty::inst_ann}}) {

        net_amount = parseInt($('#net_amount').val());
        down_payment = parseInt($('#down_payment1').val());
        registration = parseInt($('#registration').val());

        $('#total_installment').val(Math.round(net_amount - down_payment - registration));

        $('#installment').val(Math.round((net_amount - down_payment - registration)/
            (parseInt($('#total_month_per').val()/12))));
        //$('#installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price / (parseInt($('#total_month_per').val()/12))));
        //$('#total_installment').val( Math.round((parseFloat($('#monthly_installment_per').val()) + parseFloat($('#annual_installment_per').val())) / 100 * price));
        $('#total-months').val( Math.round(parseInt($('#total_month_per').val()/12)));

    }



}

function enableCustom(val) {
    document.getElementById('custom').style.display = 'block';
    document.getElementById('auto').style.display = 'none';

}

$('#total_annual_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_annual_installment_count').val();

    $('#annual-installment').val($('#total_annual_installment').val()/count);

    //$('#annual-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});

$('#total_semi_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_semi_installment_count').val();

    $('#semi-installment').val($('#total_semi_installment').val()/count);

    //$('#semi-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});

$('#total_quarterly_installment_count').keyup(function(){

    price = $('#net_amount').val();
    count = $('#total_quarterly_installment_count').val();

    $('#quarterly-installment').val($('#total_quarterly_installment').val()/count);

    //$('#quarterly-installment').val( Math.round(parseFloat($('#annual_installment_per').val()) / 100 * price / count));

});


net_amount = parseInt($('#net_amount').val());
    if($('#down_payment1').val())
        down_payment = parseInt($('#down_payment1').val());
    else
        down_payment = 0;
    registration = parseInt($('#registration').val());
    monthly_installment = parseInt($('#total_installment').val());
    annual_installment = 0;

    val = parseInt($('input[name="schedule_type"]:checked').val());
    if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
        annual_installment = $('#total_semi_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
        annual_installment = $('#total_annual_installment').val();
    }
    else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {
        annual_installment = $('#total_quarterly_installment').val();
    }

    var add_amount = 0;

    $("input[name='add_amount[]']").each(function() {
        if(!this.value){
            add_amount += 0;
        }
        else {
            add_amount += parseInt($(this).val());
        }
        
    });

    remaining_amount = net_amount - down_payment - registration - monthly_installment - annual_installment - add_amount;

    $('#remaining_amount').val(remaining_amount);
    updateCurrency();
//$('#remaining_amount').val(remaining_amount);



function adjustAmount(val) {

    amount = parseInt($('#remaining_amount').val());

    

    if(amount) {
        if(val == 1) { //amount adjustment to per installment
            $('#total_installment').val(parseInt($('#total_installment').val()) + amount);
            $('#installment').val(Math.round( ( parseInt($('#total_installment').val())) / parseInt($('#total-months').val()) ) );

        }
        else {
            val = parseInt($('input[name="schedule_type"]:checked').val());
        if(val =={{\App\CustomerProperty::inst_mon_w_semi}}) {
            $('#total_semi_installment').val(parseInt($('#total_semi_installment').val()) + amount);
            $('#semi-installment').val(Math.round( ( parseInt($('#total_semi_installment').val())) / parseInt($('#total_semi_installment_count').val()) ) );
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_ann}}) {
            $('#total_annual_installment').val(parseInt($('#total_annual_installment').val()) + amount);
            $('#annual-installment').val(Math.round( ( parseInt($('#total_annual_installment').val())) / parseInt($('#total_annual_installment_count').val()) ) );
        }
        else if(val =={{\App\CustomerProperty::inst_mon_w_quar}}) {

            $('#total_quarterly_installment').val(parseInt($('#total_quarterly_installment').val()) + amount);
            $('#quarterly-installment').val(Math.round( ( parseInt($('#total_quarterly_installment').val())) / parseInt($('#total_quarterly_installment_count').val()) ) );
        }

        }

        $('#remaining_amount').val(0);
        $("input:radio[name='adjust']").each(function(i) {
            this.checked = false;
        });
        updateCurrency();
    }
}

    </script>
@stop