@extends('layouts.app')

@section('title')
All Pre-Condition Generated List
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Pre-Condition Generated List</li>
      </ol>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	 
                            <h3 class="box-title">All  Pre-Condition Generated List</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                             <th>Created Date </th>
                                            
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($ballonpre_condition as $file)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$file->name}}</td>
                                            <td>{{date('Y-m-d',strtotime($file->created_at))}}</td>
                                           
                                            <td class="text-nowrap">
                                                @permission('view-balloting')
                                                <a href="{{route('balloting.precondition.view', $file->id)}}" data-toggle="tooltip" data-original-title="view"> <i class="fa fa-eye  text-inverse m-r-10"></i> </a>
                                                
                                                @endpermission
                                                @permission('create-balloting')
                                                <a href="{{route('balloting.start.balloting.index', $file->id)}}" data-toggle="tooltip" data-original-title="start ballot"> <i class="fa fa-plus-square text-inverse m-r-10"></i> </a>
                                                
                                                @endpermission
                                               
                                               
                                            </td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable();

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop