@extends('layouts.app')

@section('title')
    Start Balloting
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Start Balloting </li>
    </ol>
@stop
@section('css')
    <style>
        .swal2-popup {
            font-size: 1.6rem !important;
        }

        .help-block {
            font-weight: bold;
        }

        span {
            display: inline-block;
        }

        .select2-container--default .select2-selection--single {
            width: 300px;
        }

        .select2-selection--multiple {
            width: 300px;
            /* set the width to 400px */
        }


        .slider {
            height: 30px;
            -webkit-appearance: none;
            appearance: none;
            background-color: #ddd;
            outline: none;
            padding: 0;
            margin: 0;
            border-radius: 0px;
        }

        .slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        .slider::-moz-range-thumb {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }












        #slider {
            height: 34px;
            -webkit-appearance: none;
            appearance: none;
            background-color: #ddd;
            outline: none;
            padding: 0;
            margin: 0;
            border-radius: 0px;
        }

        #slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #slider::-moz-range-thumb {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background-color: #555;
            cursor: pointer;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        #switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        #switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        #slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        #slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked+#slider {
            background-color: #2196F3;
        }

        input:focus+#slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked+#slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        #slider.round {
            border-radius: 34px;
        }

        #slider.round:before {
            border-radius: 50%;
        }
    </style>

@stop

@section('content')

    <div class="container-fluid">
        <div class="row">

            <form class="form-horizontal" method='post' action="{{route('balloting.start.store')}}" id='start_balloting'>
                {{ csrf_field() }}
                <div class="col-md-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa-fw"></i> Start Balloting</h3>
                        <p class="text-muted  font-18">Some Pre-Conditions Before Start Balloting</p>
                        <p class="text-muted  font-13"> Note: All * fields are mandatory </p>

                        <hr>

                    </div>
                </div>










                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <div class="white-box1">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-map"></i> Set Inventory Pre-Condition</h3>



                        <hr>








                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Select<span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">

                                    <select class="form-control" id="pre-condition" name="pre_condition"
                                        onchange="preCondition(this.value)">
                                        <option value="" selected="">None</option>
                                         
                                        <option value="{{ App\BallotingMapDetail::random }}">Random </option>
                                        <option value="{{ App\BallotingMapDetail::custom }}">Custom </option>

                                    </select>



                                    @if ($errors->has('pre_condition'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('pre_condition') }}</strong>
                                        </span>
                                    @endif
                                </div>



                            </div>

                        </div>











                        <div id='custom_precondition' hidden>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Downpayment<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="downpayment_range_check" name="downpayment_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="downpayment_range" id="downpayment_range">
                                            <div class="input-group-addon" id="downpayment_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('downpayment_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('downpayment_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Monthly Installment<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="monthly_installment_range_check"
                                                    name="monthly_installment_range_check" value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="monthly_installment_range"
                                                id="monthly_installment_range">
                                            <div class="input-group-addon" id="monthly_installment_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('monthly_installment_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('monthly_installment_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Possession<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="possession_range_check" name="possession_range_check" value="1"
                                                    checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="possession_range" id="possession_range">
                                            <div class="input-group-addon" id="possession_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('possession_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('possession_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Allotment<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="allotment_range_check" name="allotment_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="allotment_range" id="allotment_range">
                                            <div class="input-group-addon" id="allotment_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('allotment_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('allotment_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Confirmation<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="confirmation_range_check" name="confirmation_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="confirmation_range" id="confirmation_range">
                                            <div class="input-group-addon" id="confirmation_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('confirmation_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('confirmation_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">File Processing<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="fileprocessing_range_check" name="fileprocessing_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="fileprocessing_range" id="fileprocessing_range">
                                            <div class="input-group-addon" id="fileprocessing_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('fileprocessing_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('fileprocessing_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Booking<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="booking_range_check" name="booking_range_check" value="1"
                                                    checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="booking_range" id="booking_range">
                                            <div class="input-group-addon" id="booking_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('booking_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('booking_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Registration<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="registration_range_check" name="registration_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="registration_range" id="registration_range">
                                            <div class="input-group-addon" id="registration_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('registration_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('registration_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Development<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="development_range_check" name="development_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="developmentrange" id="development_range">
                                            <div class="input-group-addon" id="development_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('development_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('development_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Ballon<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox" id="ballon_range_check"
                                                    name="ballon_range_check" value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="ballon_range" id="ballon_range">
                                            <div class="input-group-addon" id="ballon_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('ballon_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('ballon_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">Bulleting<span
                                            style="color:red">*</span></label>
                                    <div class="col-md-8">
                                        <div class="input-group">
                                            <div class="input-group-addon"><input type="checkbox"
                                                    id="bulleting_range_check" name="bulleting_range_check"
                                                    value="1" checked></div>

                                            <input class="slider" type="range" min="0" max="100"
                                                value="50" name="bulleting_range" id="bulleting_range">
                                            <div class="input-group-addon" id="bulleting_range_per">50%</div>
                                        </div>
                                        @if ($errors->has('bulleting_range'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('bulleting_range') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            {{-- <div class="col-md-6">
    
                                <div class="form-group">
                                    <label style="padding-top: 8px;" class="control-label col-md-4">OverDue Amount</label>
                                    <div class="col-md-8">
                                        <label class="switch" id='switch'>
                                            <input type="checkbox" id='overdue_amount' name='overdue_amount'>
                                            <span class="slider round" id='slider'></span>
                                        </label>
                                        @if ($errors->has('overdue_amount'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('overdue_amount') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
     --}}
                            </div>
                        </div>

                      


                        {{-- <div id='preference' hidden>

                            <div class=col-md-12 style="overflow-y:auto;height:381px;">
                                <p class="text-muted  font-13"> Note: You need to select map file first to get Preference
                                    Data </p>

                                <table class="table table-bordered table-responsive-md table-striped text-center">
                                    <thead>
                                        <tr>

                                            <th class="text-center">Select Property </th>
                                            <th class="text-center">Feature Category</th>
                                            <th class="text-center">Sector/Block</th>
                                            <th class="text-center">Road Category</th>




                                        </tr>

                                    </thead>
                                    <tbody id="tbody_data">

                                        <tr height="2px" id="account_tr_" data-id="">

                                            <td class="pt-3-half account" style="width: 40%" contenteditable="true">


                                                <select class="form-control js-example-basic-multiple"
                                                   
                                                    id='select_property' name="select_property[]" multiple="multiple">
                                                    

                                                </select>
                                            </td>

                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select "
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="feature" id='feature_0' data-id='0'>
                                                    <option>None</option>


                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="sector" id='sector_0' data-id='0'>
                                                    <option>None</option>


                                                </select>
                                            </td>
                                            <td class="pt-3-half name" contenteditable="true">
                                                <select class="form-control chosen-select"
                                                    style="width: 80%;height: 26px;font-size: 11px;padding: 0px;padding-left: 18px;cursor: pointer;"
                                                    name="road_category" id='road_category_0' data-id='0'>
                                                    <option>None</option>


                                                </select>
                                            </td>




                                        </tr>









                                    </tbody>
                                </table>
                            </div>







                        </div> --}}
                    </div>

                </div>







                {{-- Balloting Map File --}}
                {{-- <div class="col-lg-12 col-sm-12 col-xs-12" id='balloting_files' hidden>
                    <div class="white-box1">
                        <h3 class="box-title m-b-0"><i class="icon-layers fa fa-globe"></i> Select Balloting Map File</h3>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="padding-top: 8px;" class="control-label col-md-4">Map File<span
                                        style="color:red">*</span></label>
                                <div class="col-md-8">

                                    <select class="form-control" id="map_file" name="map_file"
                                        onchange="getMapData(this)">
                                        <option value="" selected="">None</option>
                                        @foreach ($balloting_files as $file)
                                            <option value='{{ $file->id }}'>{{ $file->name }} </option>
                                        @endforeach

                                    </select>



                                    @if ($errors->has('map_file'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('map_file') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>












                    </div>
                </div> --}}

                {{-- Balloting Map File --}}




                <div class="col-md-12" style="height: 70px;">
                    <div class="alert alert-danger" style="display:none;" role="alert" id="required_field_error">
                        All Fields With * is Required.
                    </div>

                    <button style="float: right;" id='start_button' type="submit"
                        class="btn btn-info  waves-effect waves-light btn-lg">Search</button>
                </div>


        </div>
    </div>


    </form>
    {{-- <input type="checkbox" class="form-check-input" id="toggle-button" > --}}
    </div>
    </div>



@stop


@section('js')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $('#pre-condition').select2({
            width: '300px'
        });
        $('.js-example-basic-single').select2({

        });


        $('#select_property').select2({
            width: '300px',
            placeholder: 'Search Unit Number...',
            ajax: {
 url: '{{route("balloting.get.inventory")}}',
   
    dataType: 'json',
    delay: 250,
    data: function (params) {
      return {
        q: params.term, // search term
        
      };
    },
    processResults: function (data) {
    return {
        results: $.map(data, function (item) {
            return {
                id: item.id,
                text: item.text
            }
        })
    };
},
cache: true

  }


        });

        $('#start_button').disabled;

        function preCondition(value) {



            if (value == '4') {
                $('#custom_precondition').show();
                $('#balloting_files').show();

            } else if (value == '') {
                $('#balloting_files').hide();
                $('#custom_precondition').hide();
                $('#start_button').disabled;
            } else {
                $('#custom_precondition').hide();
                $('#balloting_files').show();
            }



        }


        //  downpayment
        const range1 = document.getElementById('downpayment_range');
        const rangeValue1 = document.getElementById('downpayment_range_per');

        range1.addEventListener('input', () => {
            rangeValue1.textContent = range1.value + '%';
        });


        var myCheckbox1 = document.getElementById("downpayment_range_check");
        var myInput1 = document.getElementById("downpayment_range");

        myCheckbox1.addEventListener("click", function() {
            if (myCheckbox1.checked) {
                myInput1.disabled = false;
            } else {
                myInput1.disabled = true;
            }
        });

        // end downpayment

        //  Monthly Installment
        const range2 = document.getElementById('monthly_installment_range');
        const rangeValue2 = document.getElementById('monthly_installment_range_per');

        range2.addEventListener('input', () => {
            rangeValue2.textContent = range2.value + '%';
        });

        var myCheckbox2 = document.getElementById("monthly_installment_range_check");
        var myInput2 = document.getElementById("monthly_installment_range");
        myCheckbox2.addEventListener("click", function() {
            if (myCheckbox2.checked) {
                myInput2.disabled = false;
            } else {
                myInput2.disabled = true;
            }
        });
        // end Monthly Installment



        //  Possession
        const range3 = document.getElementById('possession_range');
        const rangeValue3 = document.getElementById('possession_range_per');

        range3.addEventListener('input', () => {
            rangeValue3.textContent = range3.value + '%';
        });

        var myCheckbox3 = document.getElementById("possession_range_check");
        var myInput3 = document.getElementById("possession_range");
        myCheckbox3.addEventListener("click", function() {
            if (myCheckbox3.checked) {
                myInput3.disabled = false;
            } else {
                myInput3.disabled = true;
            }
        });
        // Possession




        //  Allotment
        const range4 = document.getElementById('allotment_range');
        const rangeValue4 = document.getElementById('allotment_range_per');

        range4.addEventListener('input', () => {
            rangeValue4.textContent = range4.value + '%';
        });



        var myCheckbox4 = document.getElementById("allotment_range_check");
        var myInput4 = document.getElementById("allotment_range");
        myCheckbox4.addEventListener("click", function() {
            if (myCheckbox4.checked) {
                myInput4.disabled = false;
            } else {
                myInput4.disabled = true;
            }
        });
        // Allotment


        //  Confirmation
        const range5 = document.getElementById('confirmation_range');
        const rangeValue5 = document.getElementById('confirmation_range_per');

        range5.addEventListener('input', () => {
            rangeValue5.textContent = range5.value + '%';
        });

        var myCheckbox5 = document.getElementById("confirmation_range_check");
        var myInput5 = document.getElementById("confirmation_range");
        myCheckbox5.addEventListener("click", function() {
            if (myCheckbox5.checked) {
                myInput5.disabled = false;
            } else {
                myInput5.disabled = true;
            }
        });
        // Confirmation

        //  File Processing
        const range6 = document.getElementById('fileprocessing_range');
        const rangeValue6 = document.getElementById('fileprocessing_range_per');

        range6.addEventListener('input', () => {
            rangeValue6.textContent = range6.value + '%';
        });


        var myCheckbox6 = document.getElementById("fileprocessing_range_check");
        var myInput6 = document.getElementById("fileprocessing_range");
        myCheckbox6.addEventListener("click", function() {
            if (myCheckbox6.checked) {
                myInput6.disabled = false;
            } else {
                myInput6.disabled = true;
            }
        });

        // File Processing

        //  Booking
        const range7 = document.getElementById('booking_range');
        const rangeValue7 = document.getElementById('booking_range_per');

        range7.addEventListener('input', () => {
            rangeValue7.textContent = range7.value + '%';
        });


        var myCheckbox7 = document.getElementById("booking_range_check");
        var myInput7 = document.getElementById("booking_range");
        myCheckbox7.addEventListener("click", function() {
            if (myCheckbox7.checked) {
                myInput7.disabled = false;
            } else {
                myInput7.disabled = true;
            }
        });


        // Booking


        //  Registration
        const range8 = document.getElementById('registration_range');
        const rangeValue8 = document.getElementById('registration_range_per');

        range8.addEventListener('input', () => {
            rangeValue8.textContent = range8.value + '%';
        });

        var myCheckbox8 = document.getElementById("registration_range_check");
        var myInput8 = document.getElementById("registration_range");
        myCheckbox8.addEventListener("click", function() {
            if (myCheckbox8.checked) {
                myInput8.disabled = false;
            } else {
                myInput8.disabled = true;
            }
        });


        // End Registration





        //  Development
        const range9 = document.getElementById('development_range');
        const rangeValue9 = document.getElementById('development_range_per');

        range9.addEventListener('input', () => {
            rangeValue9.textContent = range9.value + '%';
        });


        var myCheckbox9 = document.getElementById("development_range_check");
        var myInput9 = document.getElementById("development_range");
        myCheckbox9.addEventListener("click", function() {
            if (myCheckbox9.checked) {
                myInput9.disabled = false;
            } else {
                myInput9.disabled = true;
            }
        });
        // End Development


        //  bulleting_range
        const range10 = document.getElementById('bulleting_range');
        const rangeValue10 = document.getElementById('bulleting_range_per');

        range10.addEventListener('input', () => {
            rangeValue10.textContent = range10.value + '%';
        });


        var myCheckbox10 = document.getElementById("bulleting_range_check");
        var myInput10 = document.getElementById("bulleting_range");
        myCheckbox10.addEventListener("click", function() {
            if (myCheckbox10.checked) {
                myInput10.disabled = false;
            } else {
                myInput10.disabled = true;
            }
        });

        // End bulleting_range


        //  ballon_range
        const range11 = document.getElementById('ballon_range');
        const rangeValue11 = document.getElementById('ballon_range_per');

        range11.addEventListener('input', () => {
            rangeValue11.textContent = range11.value + '%';
        });

        var myCheckbox11 = document.getElementById("ballon_range_check");
        var myInput11 = document.getElementById("ballon_range");
        myCheckbox11.addEventListener("click", function() {
            if (myCheckbox11.checked) {
                myInput11.disabled = false;
            } else {
                myInput11.disabled = true;
            }
        });
        // End ballon_range






        function preConfirm(self) {

            var pre_condition = $(self).find('#pre-condition').val();
            var map_file = $(self).find('#map_file').val();

            if (pre_condition == "") {

                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Pre-Condition is required!',

                })
                return false;
            }
            if (map_file == "") {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Map File is required!',

                })
                return false;
            }





            // return true;
        }


        // const isOKButtonShown = $('#toggle-button').is(':checked');


        // $('#start_balloting').submit(function(e) {
        //     e.preventDefault();

        //     var form_data = $(this).serialize();
        //     var pre_condition = $('#pre-condition').val();
        //   //  var map_file = $('#map_file').val();

        //     if (pre_condition == "") {

                
        //         Swal.fire({
        //             icon: 'error',
        //             title: 'Oops...',
        //             text: 'Pre-Condition is required!',

        //         })
        //         return false;
             
        //     }
           

            // function updateProgressBar() {

            //     $.ajax({
            //         url: '{{ route('balloting.progress') }}',
            //         success: function(data) {
            //             // Update progress bar
            //             $('.progress-bar').css('width', data.progress + '%').text(data.progress + '%');
            //             $('#progress_val').empty();
            //             $('#progress_val').text(data.progress);

            //             // Check if process is complete
            //             if (data.progress == 100) {

            //                 clearInterval(progressInterval);
            //             }
            //         }
            //     });
            // }
            // var progressInterval = setInterval(updateProgressBar, 2000); // Send a request every 5 seconds





        //     Swal.fire({
        //         title: 'Balloting Start',
        //         html: `  Importing...   <span id='progress_val'></span>%<div class="progress">
        //     <div class="progress-bar" role="progressbar" style="width: {{ session('progress') }}%" aria-valuenow="{{ session('progress') }}" aria-valuemin="0" aria-valuemax="100">{{ session('progress') }}%</div>
        // </div>`,
        //         showConfirmButton: false,
        //         allowOutsideClick: false,
        //         allowEscapeKey: false,


        //     });
        //     //    return false;
        //     $('.preloader').fadeIn();







            // $.ajax({
            //     url: "{{ route('balloting.start.store') }}",
            //     type: 'POST',
            //     data: form_data,
            //     success: function(response) {

            //         $('.preloader').fadeOut();

            //         if (response.success) {
                        
            //             Swal.fire({
            //                 icon: 'success',
            //                 title: 'Your Data has been published',

            //                 confirmButtonText: 'Ok',

            //             }).then((result) => {
            //                 /* Read more about isConfirmed, isDenied below */
            //                 if (result.isConfirmed) {
            //                     {!! session()->forget('progress') !!}
            //                     window.location.href =
            //                         `{{ route('balloting.map.inventory', ':id') }}`.replace(
            //                             ':id', response.id);
            //                 }
            //             })
            //         }
            //     },
            //     error: function(xhr, status, error) {
            //          $('.preloader').fadeOut();
            //         clearInterval(progressInterval);
            //         Swal.fire({
            //             icon: 'error',
            //             title: 'Oops...',
            //             text: 'Something went wrong!',

            //         })
            //     }
            // });

     //   });
        // Get the checkbox element
        const checkbox = document.getElementById('add_preference');

        // Add an event listener to the checkbox
        checkbox.addEventListener('change', function() {
            if (this.checked) {
                // Checkbox is checked

                $('#preference').show();
                $('#balloting_files').show();
                val = $("#map_file").val();
                if(val != ''){
                    getMapData(val);
                }
            } else {
                // Checkbox is not checked
                $('#preference').hide();

                if($('#pre-condition').val() == '')
                {
                    $('#balloting_files').hide();
                }

            }
        });

        function getMapData(self) {

            var chosenSelect1 = $(".chosen-select");
            chosenSelect1.chosen("destroy");
            $("#feature_0").empty();
            $("#sector_0").empty();
            $("#road_category_0").empty();
            val = $("#map_file").val();
            if (val != '' && $("#add_preference").prop("checked")) {

                // val = $(self).val();
                $('.preloader').fadeIn();
                $.ajax({
                    url: `{{ route('balloting.get.map.data', ':id') }}`.replace(':id', val),

                    type: 'GET',

                    success: function(response) {

                        var road = "<option value='' >None</option>";
                        var sector = "<option value='' >None</option>";
                        var feature = "<option value='' >None</option>";
                        for (var i = 0; i < parseInt(response.length); i++) {

                            road += "<option value='" + response[i].unit_floor_id + "'>" + response[i].road_category +
                                "</option>";
                            sector += "<option value='" + response[i].unit_block_id + "'>" + response[i].sector +
                                "</option>";
                            feature += "<option value='" + response[i].unit_category_ids + "'>" + response[i].feature +
                                "</option>";
                        }

                        $("#feature_0").html(feature);
                        $("#sector_0").html(sector);
                        $("#road_category_0").html(road);
                        $(".chosen-select").chosen();
                        $('.preloader').fadeOut();
                    },
                    error: function(xhr, status, error) {
                        $('.preloader').fadeOut();
                        // $('.preloader').fadeOut();
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Unable to fetch Preference data!',

                        })
                    }

                });
            }
        }
    </script>
@stop
