@extends('layouts.app')

@section('title')
Map Inventory
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Map File Inventory</li>
      </ol>
@stop
@section('css')
<style type="text/css">
    .bg-color{
        background-color: #1c3752;
    }
    
</style>
@stop
@section('content')


            <div class="container-fluid">
                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                        	<div class="pull-right">
                                
							</div>
                            <h3 class="box-title">File Detail</h3>

                            <div class="table-responsive">
                                

                                <table id="myTable" class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>
                                                Sr No</th>
                                             <th>	Plot No </th>
                                            <th>Category(Area)</th>
                                           

                                            <th>Feature</th>
                                            <th>
                                                Exact/Odd</th>
                                             <th>	Sector </th>
                                            <th>Road Category</th>
                                           

                                            <th>Customer Property</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count =1;?>
                                        @foreach($balloting_file->mapDetail as $file)
                                        <tr>
                                            <td>{{$count++}}</td>
                                            <td>{{$file->sr_no}} </td>
                                            <td>{{$file->plot_no}} </td>
                                            <td>{{$file->area}} Marla </td>
                                            <td>{{$file->feature}} </td>
                                            <td>{{$file->exact_odd}} </td>
                                            <td>{{$file->sector}} </td>
                                            <td>{{$file->road_category}} </td>
                                              @if($file->customerProperty)
                                            <td><a href='{{route("statement.detail",$file->customerProperty->id)}}'>{{$file->customerProperty->customer->name}} -- {{$file->customerProperty->inventory->unit_number}}  </a></td>
                                           @else
                                           <td>----</td>
                                            @endif                                       

                                            <td>
                                                @permission('edit-balloting')
                                               
                                                <a  href="{{route('balloting.map.inventory.edit',$file->id)}}" data-toggle="tooltip"
                                                    datza-original-title="Edit"> <i
                                                        class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;</a>
                                                @endpermission
                                            </td>
                                        </tr>
                                        
                                        @endforeach

                                    </tbody>
                                     
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        // $('#myTable').DataTable({

        //     "displayLength": 25000,
        // });

        var table = $('#example').DataTable({
            "columnDefs": [{
                "visible": false,
                "targets": 2
            }],
            "order": [
                [2, 'asc']
            ],
            "displayLength": 25,
            "drawCallback": function(settings) {
                var api = this.api();
                var rows = api.rows({
                    page: 'current'
                }).nodes();
                var last = null;
                api.column(2, {
                    page: 'current'
                }).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
                        last = group;
                    }
                });
            }
        });
        // Order by the grouping
        $('#example tbody').on('click', 'tr.group', function() {
            var currentOrder = table.order()[0];
            if (currentOrder[0] === 2 && currentOrder[1] === 'asc') {
                table.order([2, 'desc']).draw();
            } else {
                table.order([2, 'asc']).draw();
            }
        });
    });
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
    </script>
@stop