<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AccountTransfer extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'date','from_account','to_account','amount','memo'
    ];
    
    public function from(){
        return $this->belongsTo('\App\CompanyBank','from_account');
    }
    
    public function to() {
        return $this->belongsTo('\App\CompanyBank','to_account');
    }
}
