<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Events\Approval;

class ApprovelStatus extends Model
{
    protected $table = 'approvel_status_purchase_request';
    
     protected $fillable = [
        'role_id',
        'purchase_request_id',
        'approvel_status',
        'approvel_order'
    ];


    function pusherNotification($role_id , $purchase_request_id)
    {
        event(new Approval($role_id,$purchase_request_id));
    }


public static function getApprovals($purchase_request_id = null )
{
   return ApprovelStatus::where('purchase_request_id', $purchase_request_id)->where('approvel_status', '0')->orderBy('approvel_order', 'ASC')->first();
}

}