<?php
namespace App\Blade;

use App\MultiProject;
use App\Permission;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;

use Zizaco\Entrust\Traits\EntrustUserTrait;
class CustomEntrustDirective extends ServiceProvider
{
   
    public function boot()
    {
    Blade::directive('permission', function ($expression) {

     
       
        
    $permissionName = json_decode(str_replace("'", '"', $expression));
     

        $projectId = request()->cookie('current_project_id');
      
        $user = Auth::user();
        if (empty($projectId)) {
           
            $mproject=  MultiProject::where('name','like','Super Admin')->first();
    
            if(empty($mproject)){
                return "<?php if (false): ?>";
            }
            $projectId=  $mproject->id;
            $roles = $user
            ->roles()
             ->where('name', 'like','admin')
            ->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })
            ->first();
            if(!empty( $roles)){
                if ($user && $projectId) {
                    $roles = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                        $query->where('multi_project_id', $projectId);
                    })->get();
                    foreach ($roles as $role) {
                        $permissions = $role->permissions()->where('name', $permissionName)->get();
                        if ($permissions->count() > 0) {
                            return "<?php if (true): ?>";
                        }
                    }
                }
            }
            else{
                return "<?php if (false): ?>";
            }

          
        }
        $projectId= decrypt( $projectId);
       
        if ($user && $projectId) {
            $roles = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })->get();
            foreach ($roles as $role) {
                $permissions = $role->permissions()->where('name', $permissionName)->get();
               
                if ($permissions->count() > 0) {
                    return "<?php if (true):?>";
                }
                
           
            }
             // Clear the cached permissions
            
        }
        return "<?php if (false): ?>";
    });
    Blade::directive('endpermission', function () {
        return "<?php endif; ?>";
    });
    
}

    public function register()
    {
        //
    }
}

 
