<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BuyBack extends Model
{
    
    protected $table = 'buy_back';
    
    protected $fillable = [
       'is_approve','ref_no','date','term_and_conditions','total_amount','payee_name','payee_cnic','payee_address','buy_back_value_requested_by_client','merging_receipts','roi_as_per_company','roi_as_per_customer','value_of_appreciation_in_pkr','rebate_on_buy_back','merging_selling_expenses','rebate_paid','total_rebate_payable','loss_or_profit_on_merging','rental_discount_paid_to_customer_for_unit','party_code','inventory_id','payment_mode','buy_back_option','total_amount_invested','total_amount_received','if_merging_then_value_of_merging','roi_terms','sales_agents','merging_sold','bank_name','company_account','drawn_date','cheque_number'
    ];
    
      public function DepositorBank(){
        return $this->belongsTo('App\DepositorBank','bank_name');
    }

    public function companyAccount() {
        return $this->belongsTo('\App\CompanyBank','company_account');
    }
    
    
    public function inventory() {
        return $this->belongsTo('\App\inventory','inventory_id')->with('property','floor');
    }

}
