<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CancelProperty extends Model
{
    //
    protected $fillable = [
        'customer_property_id',
        'status',
        'fee'
    ];
    public function customerProperty(){
        return $this->belongsTo('\App\CustomerProperty','customer_property_id');
    }

    public function customerRefundHistory(){
        return $this->hasOne('\App\UnitRefundHistory','cancel_property_id');
    }
    public function customerAdjustHistory(){
        return $this->hasOne('\App\UnitAdjust','cancel_property_id');
    }

    public function includeInReceipt()
    {
        return $this->hasMany('\App\Receipt','cancel_property_id');
    }

}
