<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{

     use SoftDeletes;

     protected $fillable = [
        'category_name',
        'parent_id',
        'description'
    ];

  public function scopeWithAndWhereHas($query, $relation, $constraint){
  return $query->whereHas($relation, $constraint)
  ->with([$relation => $constraint]);
  }

      public function item()
   {
      return $this->hasMany('App\Item' , 'category_id');
   }

   //each category might have one parent
  public function parent() {
    return $this->belongsTo(static::class, 'parent_id');
  }

  //each category might have multiple children
  public function children() {
    return $this->hasMany(static::class, 'parent_id')->orderBy('category_name', 'asc');
  }

}
