<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ChartOfAccount extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'number','name','account_type_id','opening_balance','description','sub_account_id'
    ];

    const FISCAL_YEAR_START = '07';//July
    const FISCAL_YEAR_END = '06';//June

    const CASH = 1;
    const ACCRUAL = 2;

    const ACCOUNTING_TYPE = ChartOfAccount::CASH;
        
    public function type(){
        return $this->belongsTo('\App\AccountType','account_type_id');
    }
}
