<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CompanyBank extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'name','address','description','phone_number','account_number','account_title','opening_balance','status'
    ];

    const INVENTORY = 1;
    const ACCOUNT_RECEIVABLE = 2;
    const ACCOUNT_PAYABLE = 3;
    const CAPITAL = 4;

    const PETTY_CASH = 1;

    
    public function bank(){
        return $this->belongsTo('\App\DepositorBank','name');
    }
    
    public function transactions() {
        return $this->hasMany('App\CompanyBankTransaction','company_account');
    }
}
