<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ComparativeStatement extends Model
{
    protected $fillable = [
        'purchase_request_id',
        'item_id',
        'vendor_id',
        'price',
        'message'
    ];

    public static function getItemPrices($purchase_request_id = null , $vendor_id = null ,$item_id = null )
    {
        $price = 0;
        $message ='';

        $item =  ComparativeStatement::where('purchase_request_id' , $purchase_request_id)
        ->where('vendor_id' , $vendor_id)
        ->where('item_id' , $item_id)
        ->first();
       
         return array('item' => $item );
    }

    public  static function getVendorIds($purchase_request_id=null)
    {
        $total_cs = ComparativeStatement::where('purchase_request_id' , $purchase_request_id)
        ->pluck('vendor_id')->toArray();
        return array_unique($total_cs);
    }

     public  static function countCs($purchase_request_id=null , $vendor_id = null)
    {
        $total_cs = ComparativeStatement::where('purchase_request_id' , $purchase_request_id)
        ->where('vendor_id' , $vendor_id)->count();
        return $total_cs;
    }


   

}
