<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\CustomerProperty;
use App\EmailLog;
use App\EmailSms;
use App\EmailSmsType;
use App\Http\Controllers\SmsController;
use App\Mail\SendDueAmountMail;
use App\Receipt;
use App\SmtpSetting;
use DB;
use App\SmsLog;

class CheckDueAmount extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    
    protected $signature = 'send:dueamount-emails';

    protected $description = 'Send daily emails and sms to users';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
         
        $allStatements = CustomerProperty::where('status',CustomerProperty::approved)->orderBy('created_at', 'desc')->where([['is_deleted', false]])
        ->take(5)
        ->get();

        $allStatements = collect($allStatements)->filter(function ($statement) {
            return DB::table('customer_statements')
                ->where('customer_property_id', $statement->id) // replace 'id' with your statement ID column name
                ->havingRaw('SUM(CASE WHEN customer_statements.due_date < ? THEN customer_statements.balance ELSE 0 END) > 0', [\Carbon\Carbon::today()])
                ->exists();
        });
     

        foreach ($allStatements as $allStatement) {


            $type =   EmailSmsType::where('name', 'like', 'Over Due Amount')->first();
            if (!empty($type)) {
                $project_name=   $allStatement->inventory->multiProject? $allStatement->inventory->multiProject->name:'None';



                $receivedAmt = 0;
                
                    $receivedAmt =  Receipt::where('customer_property_id', $allStatement->id)->where('is_approved', 1)->where('is_deleted', false)->sum('amount');
              




                $detail =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                if (!empty($detail)) {
                    
                    if ($detail->status == EmailSms::status_on) {
                        $msg =  $detail->content;
                        $balance = $allStatement->net_pay -  $receivedAmt;
                        $message = __($msg, [
                            'name' => $allStatement->customer->name,
                            'receivedamount' => $receivedAmt ,
                            'unitnumber' => $allStatement->inventory->unit_number,
                            'balance' =>$balance,
                            'membership' =>  $allStatement->membership_no

                        ]);
                        // if ( $allStatement->customer->mobile_number ) {
                        //     SmsController::sendSMS("92" . substr( $allStatement->customer->mobile_number, 1), $message);
                        // }
                        if ( $allStatement->customer->email) {
                            $customer_email=$allStatement->customer->email;

                          
                            $smtp = SmtpSetting::where('status', 1)->first();
                            $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                                ->setUsername($smtp->smtp_username)
                                ->setPassword($smtp->smtp_password);
                            $mailer = new \Swift_Mailer($transport);
                            $email = (new SendDueAmountMail($message,$project_name))
                                ->subject('Due Payment')
                                ->from($smtp->from_email, $smtp->from_name)
                                ->to($customer_email)
                                ->view('emails.dueamount');
                            $email_message = $email->render();
                            $swiftMessage = (new \Swift_Message())
                                ->setSubject('Due Payment')
                                ->setFrom($smtp->from_email, $smtp->from_name)
                                ->setTo($customer_email)
                                ->setBody($email_message, 'text/html');
                            $response = $mailer->send($swiftMessage);
                            $email_log =  new EmailLog();
                            $email_log->smpt_setting_id = $smtp->id;
                            $email_log->receiver_email = $customer_email;
                            $email_log->content = $message;
                            $email_log->title = 'Due Payment';
                            $email_log->mailable_class = 'new SendDueAmountMail';
                            $email_log->mail_view = 'emails.dueamount';
                            $email_log->project_name = $project_name;

                            if ($response) {

                                $email_log->status = 1;
                            } else {
                                $email_log->status = 1;
                            }
                            $email_log->save();
                        }
                    }
                }
                $detail2 =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                if (!empty($detail2)){
                    if ($detail2->status == EmailSms::status_on) {
                        $balance = $allStatement->net_pay -  $receivedAmt;

                        $msg =  $detail2->content;
                        $message = __($msg, [
                            'name' => $allStatement->customer->name,
                            'receivedamount' => $receivedAmt ,
                            'unitnumber' => $allStatement->inventory->unit_number,
                            'balance' =>  $balance ,
                            'membership' =>  $allStatement->membership_no

                        ]);
                         if ( $allStatement->customer->mobile_number ) {
                            $response=   SmsController::sendSMS("92" . substr( $allStatement->customer->mobile_number, 1), $message);
                            $total_characters = strlen($message);
                            $sms_log= new SmsLog;
                            $sms_log->receiver_number = "92" . substr($allStatement->customer->mobile_number, 1);
                            $sms_log->content =$message;
                            $sms_log->title='Over Due Amount';
                            $sms_log->total_charcter =$total_characters;
                            if (strpos($response, 'Your Message is sent') !== false){
                              $sms_log->status = 1;
                            }
                            else{
                              $sms_log->status = 0;
                            }
                            $sms_log->project_name = $project_name;
                            $sms_log->response = $response;
                          $sms_log->save();
                        }
                       
                    }
                }
            }



           
             
        }

        $this->info('Daily emails sent successfully!');
    }
}
