<?php

namespace App\Console\Commands;

use App\Customer;
use Illuminate\Console\Command;
use App\EmailLog;
use App\EmailSms;
use App\EmailSmsType;
use App\Http\Controllers\SmsController;
use App\Mail\SendBirthDayWish;
use App\Mail\SendDueAmountMail;
use App\Receipt;
use App\SmtpSetting;
use DB;
use App\SmsLog;


class SendBithDay extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:birthday-wish';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send birthday wishes to clients';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $customers = Customer::whereRaw('DATE_FORMAT(dob, "%m-%d") IN (?, ?)', [now()->format('m-d'), now()->addDay()->format('m-d')])
        ->get();

    foreach ($customers as $customer) {
       
        $type =   EmailSmsType::where('name', 'like', 'Customer BirthDay Wish')->first();
        if (!empty($type)) {

            $project_name=env('APP_NAME');
            



            $detail =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
            if (!empty($detail)) {
                
                if ($detail->status == EmailSms::status_on) {
                    $msg =  $detail->content;
                   
                    $message = __($msg, [
                        'name' => $customer->name,
                       
                       

                    ]);
                    
                    if ( $customer->email) {
                        $customer_email=$customer->email;

                      
                        $smtp = SmtpSetting::where('status', 1)->first();
                        $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                            ->setUsername($smtp->smtp_username)
                            ->setPassword($smtp->smtp_password);
                        $mailer = new \Swift_Mailer($transport);
                        $email = (new SendBirthDayWish($message,$project_name))
                            ->subject('BirthDay Wish')
                            ->from($smtp->from_email, $smtp->from_name)
                            ->to($customer_email)
                            ->view('emails.birthdaywish');
                        $email_message = $email->render();
                        $swiftMessage = (new \Swift_Message())
                            ->setSubject('BirthDay Wish')
                            ->setFrom($smtp->from_email, $smtp->from_name)
                            ->setTo($customer_email)
                            ->setBody($email_message, 'text/html');
                        $response = $mailer->send($swiftMessage);
                        $email_log =  new EmailLog();
                        $email_log->smpt_setting_id = $smtp->id;
                        $email_log->receiver_email = $customer_email;
                        $email_log->content = $message;
                        $email_log->title = 'BirthDay Wish';
                        $email_log->mailable_class = 'new SendBirthDayWish';
                        $email_log->mail_view = 'emails.birthdaywish';

                        if ($response) {

                            $email_log->status = 1;
                        } else {
                            $email_log->status = 1;
                        }
                        $email_log->project_name = $project_name;
                        $email_log->save();
                    }
                }
            }
            $detail2 =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
            if (!empty($detail2)){
                if ($detail2->status == EmailSms::status_on) {
                   

                    $msg =  $detail2->content;
                    $message = __($msg, [
                        'name' => $customer->name,
                        
                         

                    ]);
                     if ( $customer->mobile_number ) {
                        $response=   SmsController::sendSMS("92" . substr( $customer->mobile_number, 1), $message);
                   
                        $total_characters = strlen($message);
                        $sms_log= new SmsLog;
                        $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                        $sms_log->content =$message;
                        $sms_log->title='Customer BirthDay Wish';
                        $sms_log->total_charcter =$total_characters;
                        if (strpos($response, 'Your Message is sent') !== false){
                          $sms_log->status = 1;
                        }
                        else{
                          $sms_log->status = 0;
                        }
                        $sms_log->project_name = $project_name;
                        $sms_log->response = $response;
                      $sms_log->save();
                    }
                   
                }
            }
        }
    }
    
    $this->info('Birthday wishes emails sent successfully!');
    }
}
