<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Carbon\Carbon;
use App\CustomerRegistration;
use Mail;
use App\RegistrationNo;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
        Commands\NOCCron::class,
        Commands\CheckDueAmount::class,
        Commands\SendBithDay::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        //run the schedule at every day 11:55 PM
        $schedule->call(function () {
            //get the today date with format
            $today = date('Y-m-d',strtotime(str_replace('-', '/', date('Y-m-d'))));
            //get all the registrations that are reserved and hold upto today date.
            $registrations = CustomerRegistration::where([['status',CustomerRegistration::reserved],['hold_upto',$today]])->get();

            foreach($registrations as $r) {
                //cancel the registration form
                CustomerRegistration::where('id',$r->id)->update(['status'=>CustomerRegistration::cancel]);
                //cancel the registration number
                registrationNo::where('id',$r->registration_id)->update(['status'=>registrationNo::cancel]);

                //send mail to admin about registration cancelation
                $msg="Registration no " . $r->registrationNo->number . " has been canceled due to unpaid.";
                Mail::raw($msg, function ($message){
                            $message->to(Auth::user()->email);

                         });
            }

        })->dailyAt('23:55');

        $schedule->command('backup:run')->everyFiveMinutes();



         $schedule->command('noc:cron')->daily();
         $schedule->command('send:dueamount-emails')
         ->weekly();

         $schedule->command('send:birthday-wish')->daily();

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
