<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ControlAccount extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'name','rep_name','description','type','vendor_type','file','cnic','national_tax_number','address'
    ];

    const CUSTOMER = 1;
    const DEALER = 2;
    const VENDOR = 3;
    const EMPLOYEE = 4;

    //vendor type
    const TRADING = 1;
    const NON_TRADING = 2;

    public function entry() {

      return $this->hasMany('\App\GeneralJournalEntry','name','id')->where('is_post',true);
    }
}
