<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model {

  const CASH = 0;
  const BANK = 1;
  const CHEAQUE = 2;
  const OPEN_CHEAQUE = 3;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'father_name', 'name', 'email', 'mailing_address', 'permanent_address', 'cnic', 'passport_no', 'phone_number', 'res_number', 'mobile_number', 'dob', 'occupation', 'status', 'total_paid_amount', 'img_url', 'nominee_name', 'nominee_so_do_wo', 'nominee_cnic', 'nominee_email', 'nominee_passport_no', 'nominee_phone_number', 'nominee_res_number', 'nominee_mobile_number', 'nominee_relation','father_type','cnic_flag','nominee_cnic_flag','nominee_father_type','password','is_filer','ntn_number','type', 'nominee_address','account_title','bank_id','iban_number','first_owner','second_owner','first_owner_father','second_owner_father','first_owner_cnic','second_owner_cnic','payment_method',
    ];

    const locally = 1;
    const internationally = 2;

    public function receipts() {
        return $this->hasMany('\App\Receipt')->where('is_deleted',false)->with('property');
    }

    public function properties(){
        return $this->hasMany('\App\CustomerProperty')->where('is_deleted',false)->with('inventory');
    }

    public function propertiesWithOutOpenFiles(){
      return $this->hasMany('\App\CustomerProperty')->where('is_deleted',false)->with('inventoryWithOutOpenFile');
  }
    public function documents() {
      return $this->hasMany('\App\CustomerDocument');
    }

    public function nominee() {
      return $this->hasMany('\App\CustomerNominee');
    }


     public function depositerBank() {
      return $this->belongsTo('\App\DepositorBank' , 'bank_id');
    }

    public function insertNewCustomer($request) {
      
      $customer = Customer::create(['father_name'=>$request->father_name, 'name' => $request->name, 'email' => $request->email, 'mailing_address' => $request->mailing_address, 'permanent_address' => $request->permanent_address, 'dob' => $request->dob, 'occupation' => $request->occupation, 'cnic' => $request->cnic, 'passport_no' => $request->passport_no, 'res_number' => $request->res_number, 'phone_number' => $request->phone_number, 'mobile_number' => $request->mobile_number, 'nominee_name' => $request->nominee_name, 'nominee_so_do_wo' => $request->nominee_so_do_wo, 'nominee_cnic' => $request->nominee_cnic, 'nominee_passport_no' => $request->nominee_passport_no, 'nominee_phone_number' => $request->nominee_phone_number, 'nominee_res_number' => $request->nominee_res_number, 'nominee_mobile_number' => $request->nominee_mobile_number, 'nominee_relation' => $request->nominee_relation, 'nominee_email' => $request->nominee_email,'father_type'=>$request->father_type,'cnic_flag'=>$request->cnic_flag,'nominee_cnic_flag'=>$request->nominee_cnic_flag,'nominee_father_type' =>$request->nominee_father_type,'nominee_address' =>$request->nominee_address,'password'=>bcrypt($request->password ? $request->password : $request->cnic),'is_filer'=>$request->is_filer ? 1 : 0 , 'ntn_number' =>$request->ntn_number , 'type' => $request->type   , 'account_title' => $request->account_title , 'bank_id' => $request->depositer_bank , 'iban_number' => $request->iban_number , 'first_owner' => $request->first_owner , 'second_owner' => $request->second_owner , 'first_owner_father' => $request->first_owner_father , 'second_owner_father' => $request->second_owner_father , 'first_owner_cnic' => $request->first_owner_cnic , 'second_owner_cnic' => $request->second_owner_cnic,'payment_method' => $request->payment_method]);

        if ($request->hasfile('file')) {
            $file = $request->file('file');

            $name = $customer->id . '-' . $file->getClientOriginalName();
            $file->move(public_path() . '/uploads/', $name);

            Customer::where('id',$customer->id)->update(['img_url' => $name, 'updated_at' => date('Y-m-d H:i:s')]);
        }

        if ($request->hasfile('photos')) {

          foreach ($request->photos as $photo) {


            $name = $customer->id . '-' . $photo->getClientOriginalName();

            $photo->move(public_path() . '/uploads/', $name);

            CustomerDocument::create(['customer_id'=>$customer->id,'url'=>$name]);
          }
        }

      return $customer;
    }

    public function updateCustomer($request) {

        Customer::where('id', $request->id)->update(['father_name'=>$request->father_name, 'name' => $request->name, 'email' => $request->email, 'mailing_address' => $request->mailing_address, 'permanent_address' => $request->permanent_address, 'dob' => $request->dob, 'occupation' => $request->occupation, 'cnic' => $request->cnic, 'passport_no' => $request->passport_no, 'res_number' => $request->res_number, 'phone_number' => $request->phone_number, 'mobile_number' => $request->mobile_number, 'nominee_name' => $request->nominee_name, 'nominee_so_do_wo' => $request->nominee_so_do_wo, 'nominee_cnic' => $request->nominee_cnic, 'nominee_passport_no' => $request->nominee_passport_no, 'nominee_phone_number' => $request->nominee_phone_number, 'nominee_res_number' => $request->nominee_res_number, 'nominee_mobile_number' => $request->nominee_mobile_number, 'nominee_relation' => $request->nominee_relation, 'nominee_email' => $request->nominee_email,'father_type'=>$request->father_type,'cnic_flag'=>$request->cnic_flag,'nominee_cnic_flag'=>$request->nominee_cnic_flag,'nominee_father_type' =>$request->nominee_father_type,'is_filer'=>$request->is_filer, 'nominee_address' =>$request->nominee_address , 'ntn_number' =>$request->ntn_number , 'account_title' => $request->account_title , 'bank_id' => $request->depositer_bank , 'iban_number' => $request->iban_number , 'first_owner' => $request->first_owner , 'second_owner' => $request->second_owner , 'first_owner_father' => $request->first_owner_father , 'second_owner_father' => $request->second_owner_father , 'first_owner_cnic' => $request->first_owner_cnic , 'second_owner_cnic' => $request->second_owner_cnic,'payment_method' => $request->payment_method
        ]);

        if($request->password) {
          Customer::where('id',$request->id)->update(['password'=>bcrypt($request->password)]);
        }

        if ($request->hasfile('file')) {
            $file = $request->file('file');

            $name = $request->id . '-' . $file->getClientOriginalName();
            $file->move(public_path() . '/uploads/', $name);

            Customer::where('id',$request->id)->update(['img_url' => $name, 'updated_at' => date('Y-m-d H:i:s')]);
        }

        if ($request->hasfile('photos')) {

          foreach ($request->photos as $photo) {


            $name = $request->id . '-' . $photo->getClientOriginalName();

            $photo->move(public_path() . '/uploads/', $name);

            CustomerDocument::create(['customer_id'=>$request->id,'url'=>$name]);
          }
        }
    }

    public function deleteCustomer($id) {

      //get all the properties of customer
      $properties = CustomerProperty::where('customer_id',$id)->with('inventory')->get();

      foreach($properties as $pro) {
        //update the status of invnentry
        if($pro->inventory) {
          Inventory::where('id',$pro->inventory->id)->update(['status'=>0]);
          ProjectAccount::where('inventory_id',$pro->inventory->id)->delete();
        }

        //delete all the statement of this property
        CustomerStatement::where('customer_property_id',$pro->id)->delete();

        //delete the dealer transaction
        DealerTransaction::where('product_id',$pro->id)->delete();

        //delete the receipts
        Receipt::where('customer_property_id',$pro->id)->delete();

        CustomerProperty::where('id',$pro->id)->delete();
      }

      Customer::where('id',$id)->delete();

    }

}
