<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerAdjustment extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'receipt_id','type','description','merge_amount','sold_amount','status'
    ];

    //adjustment
    const property = 1;
    const vehicle = 2;

    //status
    const open = 1;
    const sold = 0;

    public function receipt() {
        return $this->belongsTo('\App\Receipt')->with('customer','property');
    }

}
