<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\Membership;
use Auth;
use App\Http\Controllers\SmsController;


class CustomerProperty extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'customer_id', 'cost', 'booking_date', 'discount', 'discount_type', 'booking_type',
        'down_payemnt', 'confirmation_fee', 'installment', 'possession_fee', 'installment_plan', 'application_form_no', 'dealer_id', 'net_pay', 'inventory_id', 'schedule_start_date', 'booking_date', 'schedular_type', 'membership_no', 'status', 'down_payment_note', 'is_deleted', 'sms_alert', 'email_alert', 'down_payment_rebate', 'installment_rebate', 'paid_installment_rebate', 'reminder_text', 'reminder_date', 'is_book', 'sale_by', 'original_boooking_date',
        'multi_project_id', '
        plot_no', 'allotment_date', 'confirmation_date', 
        'development_date', 'file_processing_date', 'registration_date', 
        'allotment_fee', 'confirmation_fee', 'booking_fee', 'development_fee', 
        'file_processing_fee', 'registration_fee', 'access_amount', 'cancel_date',
        'inc_development'
    ];

    //Booking Types
    const normal = 1;
    const buy_back = 2;
    const full_payment = 3;

    //Return Types
    const monthly = 1;
    const quarterly = 2;
    const semi_annually = 3;
    const annually = 4;

    //installment Schedular
    const inst_mon = 1; //monthly installment
    const inst_mon_w_ann = 2; //monthly with annually installment
    const inst_quar = 3; //quarterly installment
    const inst_semi = 4; //semi annually installment
    const inst_ann = 5; //annually installment
    const inst_mon_w_quar = 6; //monthly with annually installment
    const inst_mon_w_semi = 7; //monthly with annually installment
    const inst_custom = 8;
    const inst_bi_mon = 9;
    const inst_quar_w_semi = 10;


    const inst_mon_exclude_quar = 11; //monthly exclude quatarly installment
    const inst_mon_exclude_semi = 12; //monthly exclude semi annually installment

    const inst_mon_exclude_ann = 13; //monthly exclude annually installment
    const inst_quar_exclude_semi = 14; //quatarly exclude semi annually installment





    const pending = 1;
    const approved = 2;
    const cancel = 3;

    const block = 4;

    public function cancelProperty()
    {
        return $this->hasOne('App\CancelProperty');
    }
    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }

    public function dealer()
    {
        return $this->belongsTo('App\Dealer');
    }

    public function statement()
    {
        return $this->hasMany('App\CustomerStatement')->with('receipt')->orderBy('due_date', 'asc');
    }

    public function buyBackStatement()
    {
        return $this->hasMany('App\CustomerPropertyBuyBackStatement', 'property_id');
    }
    public function fullPaymentStatement()
    {
        return $this->hasMany('App\CustomerPropertyFullPaymentStatement', 'property_id');
    }

    public function size()
    {
        return $this->belongsTo('App\UnitSize', 'unit_size');
    }

    public function type()
    {
        return $this->belongsTo('App\UnitType', 'unit_type');
    }

    public function category()
    {
        return $this->belongsTo('App\UnitCategory', 'unit_category');
    }

    public function receipts()
    {
        return $this->hasMany('App\Receipt')->where('is_deleted', false);
    }

    public function receivedAmount()
    {
        return $this->hasMany('App\Receipt')->sum('amount');
    }

    public function partner()
    {
        return $this->hasMany('\App\CustomerPropertyPartner', 'property_id');
    }

    public function inventory()
    {
        return $this->belongsTo('App\Inventory', 'inventory_id', 'id');
    }
    public function inventoryWithOutOpenFile()
    {
        return $this->belongsTo('App\Inventory')->whereDoesntHave('dealerPackageOpenFileUnit');
    }


    public function buyBack()
    {
        return $this->hasOne('App\CustomerPropertyBuyBack');
    }

    public function fullPayment()
    {
        return $this->hasOne('App\CustomerPropertyFullPayment');
    }

    public function dealerTransaction()
    {
        return $this->hasMany('App\DealerTransaction', 'product_id');
    }


    public function chatHistory()
    {
        return $this->hasMany('App\PropertyChatHistory', 'property_id');
    }

    public function saleBy()
    {
        return $this->belongsTo('App\User', 'sale_by');
    }

    public function propertyTax()
    {
        return $this->hasMany('App\CustomerPropertyTax', 'property_id');
    }
    public function unitRefundHistory()
    {
        return $this->hasOne('App\UnitRefundHistory', 'customer_property_id');
    }

    public function unitAdjustHistory()
    {
        return $this->hasOne('App\UnitAdjust', 'customer_property_id');
    }


    public function customerPrefferedCategory()
    {

        return $this->hasMany('App\CustomerCategoryPreferrence', 'customer_property_id', 'id');
    }

    public function  multiProject() {
        return $this->belongsTo('\App\MultiProject','multi_project_id','id');
    }
    public function unitRefundReceipt()
    {
        return $this->hasOne('App\CustomerRefundUnitReceipt', 'customer_property_id');
    }

    public function customerCancelUnitReceipt()
    {
        return $this->hasOne('App\CustomerCancelUnitReceipt', 'customer_property_id');
    }





    public static function getCancelUnitDetail($monthYear)
    {

        $month = date('m', strtotime($monthYear));
        $year = date('Y', strtotime($monthYear));
        $lastDay =  cal_days_in_month(CAL_GREGORIAN, $month,  $year);

        $from = date('Y-m-d', strtotime('1-' . $monthYear));
        $to = date('Y-m-d', strtotime($lastDay . '-' . $monthYear));


        $properties = CustomerProperty::whereBetween('booking_date', [$from, $to])->where([['status', CustomerProperty::cancel], ['is_deleted', false]])->get();

        $receivedAmt = 0;

        foreach ($properties as $statement) {
            $receivedAmt += Receipt::where('is_deleted', false)->whereIn('customer_property_id', [$statement->id])->where('is_approved', 1)->sum('amount');
        }

        $cancelUnit = $properties->count();

        return [$cancelUnit, $receivedAmt];
    }



    public static function getTransferUnitDetail($monthYear)
    {

        $month = date('m', strtotime($monthYear));
        $year = date('Y', strtotime($monthYear));
        $lastDay =  cal_days_in_month(CAL_GREGORIAN, $month,  $year);

        $from = date('Y-m-d', strtotime('1-' . $monthYear));
        $to = date('Y-m-d', strtotime($lastDay . '-' . $monthYear));


        $allTransfers = TransferProperty::whereBetween('transfer_date', [$from, $to])->get();

        $receivedAmt = 0;

        foreach ($allTransfers as $statement) {
            $receivedAmt += Receipt::where('is_deleted', false)->whereIn('customer_property_id', [$statement->property_id])->where('is_approved', 1)->sum('amount');
        }

        $transferUnit = $allTransfers->count();

        return [$transferUnit, $receivedAmt];
    }


    public function insertNewStatement($request)
    {

        DB::beginTransaction();
        try {
            /*
          Create a customer id by getting existing customer or create new one
        */
            if ($request->customer_id) {

                $customer = Customer::where('id', $request->customer_id)->first();
            } 
            
            else {

                $customer = Customer::create(['father_name' => $request->father_name, 'name' => $request->name, 'email' => $request->email, 'mailing_address' => $request->mailing_address, 'permanent_address' => $request->permanent_address, 'dob' => $request->dob, 'occupation' => $request->occupation, 'cnic' => $request->cnic, 'passport_no' => $request->passport_no, 'res_number' => $request->res_number, 'phone_number' => $request->phone_number, 'mobile_number' => $request->mobile_number, 'nominee_name' => $request->nominee_name, 'nominee_so_do_wo' => $request->nominee_so_do_wo, 'nominee_cnic' => $request->nominee_cnic, 'nominee_passport_no' => $request->nominee_passport_no, 'nominee_phone_number' => $request->nominee_phone_number, 'nominee_res_number' => $request->nominee_res_number, 'nominee_mobile_number' => $request->nominee_mobile_number, 'nominee_relation' => $request->nominee_relation, 'nominee_email' => $request->nominee_email, 'father_type' => $request->father_type, 'cnic_flag' => $request->cnic_flag, 'nominee_cnic_flag' => $request->nominee_cnic_flag, 'nominee_father_type' => $request->nominee_father_type, 'password' => bcrypt($request->password ? $request->password : $request->cnic), 'is_filer' => $request->is_filer, 'nominee_address' => $request->nominee_address, 'ntn_number' => $request->ntn_number, 'type' => $request->user_type, 'account_title' => $request->account_title, 'bank_id' => $request->depositer_bank, 'iban_number' => $request->iban_number, 'first_owner' => $request->first_owner, 'second_owner' => $request->second_owner, 'first_owner_father' => $request->first_owner_father, 'second_owner_father' => $request->second_owner_father, 'first_owner_cnic' => $request->first_owner_cnic, 'second_owner_cnic' => $request->second_owner_cnic, 'payment_method' => $request->payment_method]);


                if ($request->hasfile('file')) {
                    $file = $request->file('file');

                    $name = $customer->id . '-' . $file->getClientOriginalName();
                    $file->move(public_path() . '/uploads/', $name);

                    Customer::where('id', $customer->id)->update(['img_url' => $name, 'updated_at' => date('Y-m-d H:i:s')]);
                }
                if ($request->hasfile('photos')) {
                    foreach ($request->photos as $photo) {
                        $name = $customer->id . '-' . $photo->getClientOriginalName();
                        $photo->move(public_path() . '/uploads/', $name);
                        CustomerDocument::create(['customer_id' => $customer->id, 'url' => $name]);
                    }
                }
            }

            $net_amount = $request->net_amount;

            if ($request->discount_percent) {
                $discount = (int)($request->discount ? ((($request->total_price + $request->extra_charges) * $request->discount) / 100) : 0);
            } else {
                $discount = ($request->discount ?  $request->discount : 0);
            }

            /*
          Update the status of inventry
        */
            Inventory::where('id', $request->inventory_id)->update(['status' => Inventory::sold]);

            $inventory_project_type =  Inventory::where('id', $request->inventory_id)->first();

            /*
          Customer property entry
        */
            $property = CustomerProperty::create(['customer_id' => $customer->id, 'cost' => $request->total_price, 'booking_date' => $request->booking_date, 'original_boooking_date' =>  $request->original_boooking_date,  'schedule_start_date' => $request->schedule_start_date, 'discount' => $discount, 'booking_type' => $request->booking_type, 'net_pay' => $net_amount, 'inventory_id' => $request->inventory_id, 'membership_no' => $request->membership_number, 'schedular_type' => $request->schedule_type, 'status' => CustomerProperty::pending, 'down_payment_note' => $request->down_payment_note, 'sale_by' => Auth::user()->id, 'access_amount' => $request->access_amount, 'multi_project_id' => $inventory_project_type->multi_project_id]);



            //if multiple owners
            //if multiple owners
            // if ($request->has('customer_id')) {
            //     if (count($request->customer_id) > 1) {
            //         for ($i = 1; $i < count($request->customer_id); $i++) {
            //             CustomerPropertyPartner::create(['property_id' => $property->id, 'customer_id' => $request->customer_id[$i]]);
            //         }
            //     }
            // }


            //check if the product sold by dealer  then update their account
            // dd(isset($request->dealer_id[0]),$request->dealer_id);

            // if(isset($request->dealer_id[0] )){
            // dd($request->dealer_id,$request->total_rebate);
            if ($request->dealer_id != 0) {
                $inventory = Inventory::where('id', $request->unit_number)->first();
                if (!$inventory->dealerPackageOpenFileUnit) {

                    for ($i = 0; $i < count($request->dealer_id); $i++) {
                        $dealer = Dealer::where('id', $request->dealer_id[$i])->first();
                        $rebate = $request->total_rebate[$i];
                        Dealer::where('id', $request->dealer_id[$i])->update([
                            'total_sale' =>
                            $dealer->total_sale + $net_amount,
                            'total_rebate' =>
                            $dealer->total_rebate + $rebate
                        ]);
                        //make transation
                        DealerTransaction::create([
                            'product_id' => $property->id,
                            'dealer_id' => $dealer->id,
                            'amount' => $rebate,
                            'status' => DealerTransaction::unpaid
                        ]);

                        //update the product account
                        CustomerProperty::where('id', $property->id)->update(['dealer_id' => $dealer->id]);
                    }
                }
            }
            // }

            //check if booking type normal or full payment
            if ($request->booking_type == CustomerProperty::normal) {

                //Custom Scheduling
                if ($request->schedule_type == CustomerProperty::inst_custom) {
                    // dd('1');
                    $b_date = new Carbon($request->booking_date);
                    $downpayment = $request->down_payment;
                    $possession = $request->possession;
                    //Make a  downpayment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment]);
                    if ($request->custom_amount) {
                        for ($i = 0; $i < count($request->custom_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::installment, 'inst_no' => 1 + $i, 'due_date' => $request->custom_date[$i], 'due' => $request->custom_amount[$i], 'balance' => $request->custom_amount[$i], 'surcharge' => 0]);
                            // $extra_amount += $request->custom_amount[$i];
                            $possesion_date =  $request->custom_date[$i];
                        }
                    }
                    // $possesion_date = $request->custom_date[$request->custom_amount];
                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }
                    //Make a possession Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);
                    //Make a allotment Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0]);
                    //Make a confirmation Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0]);
                    //Make a booking Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0]);
                    //Make a development Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::development, 'inst_no' => 1, 'due_date' => $request->development_date, 'due' => $request->development, 'balance' => $request->development, 'received' => 0]);


                    //Make a file_processing Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0]);

                    //Make a registration Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0]);

                    //Make ballon payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->ballon, 'balance' => $request->ballon, 'received' => 0]);

                    //Make Bulleting payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->bulleting_date, 'due' => $request->bulleting, 'balance' => $request->bulleting, 'received' => 0]);
                }


                //End Custom 



                else if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann || $request->schedule_type == CustomerProperty::inst_mon_exclude_quar || $request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {


                    $date = new Carbon($request->schedule_start_date);
                    $date = $date->subMonth();
                    $b_date = new Carbon($request->booking_date);

                    $tenure = $request->total_annual_installement_count;
                    $total_count = $request->total_annual_installment_count;

                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->down_payment) / 100;
                        $possession = ($net_amount * $request->possession) / 100;
                        $monthy_installment = ($net_amount * $request->installment) / 100 * $request->installment_plan;
                        $per_monthly_inst = ($net_amount * $request->installment) / 100;
                        if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann) {
                            $semi_installment = ($net_amount * $request->annual_installment) / 100 * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {
                            $semi_installment = ($net_amount * $request->semi_installment) / 100 * $request->total_semi_installment_count;
                            $tenure = 6;
                            $total_count = $request->total_semi_installment_count;
                        } else {
                            $semi_installment = ($net_amount * $request->quarterly_installment) / 100 * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                        }
                        $per_semi_installment = $semi_installment;
                    } else {
                        $downpayment = $request->down_payment;
                        $possession = $request->possession;
                        $monthy_installment = $request->installment * $request->installment_plan;
                        $per_monthly_inst = $request->installment;

                        if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann) {
                            $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                            $per_semi_installment = $request->annual_installment;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {
                            $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                            $tenure = ($request->schedule_type == CustomerProperty::inst_quar_exclude_semi) ? 3 : 6;
                            $total_count = $request->total_semi_installment_count;
                            $per_semi_installment = $request->semi_installment;
                        } else {
                            $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                            $per_semi_installment = $request->quarterly_installment;
                        }


                        //   $possession_fee = $request->possession_fee;
                    }

                    $total_months = $total_count;

                    CustomerProperty::where('id', $property->id)->update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $monthy_installment, 'installment_plan' => $request->installment_plan, 'six_installment' => $semi_installment, 'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date, 'development_date' => $request->development_date, 'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->allotment, 'confirmation_fee' => $request->confirmation, 'development_fee' => $request->development, 'file_processing_fee' => $request->file_processing, 'registration_fee' => $request->registration, 'booking_fee' => $request->booking]);

                    $extra_amount = $downpayment + $possession + $monthy_installment + $semi_installment + $request->allotment + $request->confirmation +  $request->file_processing + $request->registration + $request->booking + $request->ballon + $request->bulleting;

                    //Make a  downpayment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }

                    $extra_amount -= $net_amount;

                    $addMonth = ($request->schedule_type == CustomerProperty::inst_quar_exclude_semi) ? 3 : 1;
                    $date->subMonth($addMonth - 1);

                    //Make a installment Entry

                    for ($i = 1; $i <= ($request->installment_plan + $total_months); $i++) {
                        if ($i % $tenure == 0 && $total_count > 0) {
                            if ($i == ($request->installment_plan)) {

                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment  - $extra_amount,
                                    'balance' => $per_semi_installment - $extra_amount, 'surcharge' => 0, 'inst_track' => 1, 'multi_project_id' => $inventory_project_type->multi_project_id
                                ]);
                            } else {

                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment,
                                    'balance' => $per_semi_installment, 'surcharge' => 0, 'inst_track' => 1,
                                    'multi_project_id' => $inventory_project_type->multi_project_id
                                ]);
                            }
                            $total_count--;
                        } else if ($i == ($request->installment_plan)) {

                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst - $extra_amount,
                                'balance' => $per_monthly_inst - $extra_amount, 'surcharge' => 0,
                                'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        } else {

                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst,
                                'balance' => $per_monthly_inst, 'surcharge' => 0,
                                'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        }
                    }

                    $possesion_date = $date;

                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }

                    //Make a possession Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a allotment Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a confirmation Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    //Make a booking Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    //Make a file_processing Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a registration Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    //Make ballon payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->ballon, 'balance' => $request->ballon, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make Bulleting payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->bulleting_date, 'due' => $request->bulleting, 'balance' => $request->bulleting, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                } else if ($request->schedule_type == CustomerProperty::inst_mon_w_ann || $request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_mon_w_quar || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {

                    $date = new Carbon($request->schedule_start_date);
                    $date = $date->subMonth();
                    $b_date = new Carbon($request->booking_date);

                    $tenure = $request->total_annual_installement_count;
                    $total_count = $request->total_annual_installment_count;

                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->down_payment) / 100;
                        $possession = ($net_amount * $request->possession) / 100;
                        $monthy_installment = ($net_amount * $request->installment) / 100 * $request->installment_plan;
                        $per_monthly_inst = ($net_amount * $request->installment) / 100;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                            $semi_installment = ($net_amount * $request->annual_installment) / 100 * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {
                            $semi_installment = ($net_amount * $request->semi_installment) / 100 * $request->total_semi_installment_count;
                            $tenure = 6;
                            $total_count = $request->total_semi_installment_count;
                        } else {
                            $semi_installment = ($net_amount * $request->quarterly_installment) / 100 * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                        }
                        $per_semi_installment = $semi_installment;
                    } else {
                        $downpayment = $request->down_payment;
                        $possession = $request->possession;
                        $monthy_installment = $request->installment * $request->installment_plan;
                        $per_monthly_inst = $request->installment;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                            $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                            $per_semi_installment = $request->annual_installment;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {
                            $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                            $tenure = ($request->schedule_type == CustomerProperty::inst_quar_w_semi) ? 3 : 6;
                            $total_count = $request->total_semi_installment_count;
                            $per_semi_installment = $request->semi_installment;
                        } else {
                            $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                            $per_semi_installment = $request->quarterly_installment;
                        }


                        //   $possession_fee = $request->possession_fee;
                    }
                    CustomerProperty::where('id', $property->id)->update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $monthy_installment, 'installment_plan' => $request->installment_plan, 'six_installment' => $semi_installment, 'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date,  'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->allotment, 'confirmation_fee' => $request->confirmation,  'file_processing_fee' => $request->file_processing, 'registration_fee' => $request->registration, 'booking_fee' => $request->booking]);

                    $extra_amount = $downpayment + $possession + $monthy_installment + $semi_installment + $request->allotment + $request->confirmation + $request->file_processing + $request->registration + $request->booking + $request->ballon + $request->bulleting;

                    //Make a  downpayment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }

                    $extra_amount -= $net_amount;

                    $addMonth = ($request->schedule_type == CustomerProperty::inst_quar_w_semi) ? 3 : 1;
                    $date->subMonth($addMonth - 1);



                    //Make a installment Entry
                    for ($i = 1; $i <= $request->installment_plan; $i++) {

                        if ($i % $tenure == 0 && $total_count > 0) {
                            if ($i == ($request->installment_plan)) {
                                // dd('1',$per_semi_installment + $per_monthly_inst,'t',$per_semi_installment + $per_monthly_inst - $extra_amount,$per_monthly_inst - $extra_amount, $per_monthly_inst);
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment + $per_monthly_inst - $extra_amount,
                                    'balance' => $per_semi_installment + $per_monthly_inst - $extra_amount, 'surcharge' => 0, 'inst_track' => 1,
                                    'multi_project_id' => $inventory_project_type->multi_project_id
                                ]);
                            } else {
                                // dd('2',$per_semi_installment + $per_monthly_inst,'t',$per_semi_installment + $per_monthly_inst - $extra_amount,$per_monthly_inst - $extra_amount, $per_monthly_inst);
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment + $per_monthly_inst,
                                    'balance' => $per_semi_installment + $per_monthly_inst, 'surcharge' => 0, 'inst_track' => 1, 'multi_project_id' => $inventory_project_type->multi_project_id
                                ]);
                            }
                            $total_count--;
                        } else if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst - $extra_amount,
                                'balance' => $per_monthly_inst - $extra_amount, 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        } else {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst,
                                'balance' => $per_monthly_inst, 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        }
                    }

                    $possesion_date = $date;

                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }

                    //Make a possession Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a allotment Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a confirmation Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    //Make a booking Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);



                    //Make a file_processing Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a registration Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make ballon payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->ballon, 'balance' => $request->ballon, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make Bulleting payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->bulleting_date, 'due' => $request->bulleting, 'balance' => $request->bulleting, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                } else {

                    $date = new Carbon($request->schedule_start_date);

                    $count = 1;
                    if ($request->schedule_type == CustomerProperty::inst_mon) {
                        $count = 1;
                    } elseif ($request->schedule_type == CustomerProperty::inst_bi_mon) {
                        $count = 2;
                    } elseif ($request->schedule_type == CustomerProperty::inst_quar) {
                        $count = 3;
                    } elseif ($request->schedule_type == CustomerProperty::inst_semi) {
                        $count = 6;
                    } elseif ($request->schedule_type == CustomerProperty::inst_ann) {
                        $count = 12;
                    }
                    $date = $date->subMonth($count);
                    $b_date = new Carbon($request->booking_date);

                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->down_payment) / 100;
                        $possession = ($net_amount * $request->possession) / 100;
                        $installment = ($net_amount * $request->installment) / 100 * $request->installment_plan;
                        $per_installment = ($net_amount * $request->installment) / 100;
                    } else {
                        $downpayment = $request->down_payment;
                        $possession = $request->possession;
                        $installment = $request->installment * $request->installment_plan;
                        $per_installment = $request->installment;
                    }
                    CustomerProperty::where('id', $property->id)->update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $installment, 'installment_plan' => $request->installment_plan,  'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date, 'development_date' => $request->development_date, 'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->allotment, 'confirmation_fee' => $request->confirmation, 'development_fee' => $request->development, 'file_processing_fee' => $request->file_processing, 'registration_fee' => $request->registration, 'booking_fee' => $request->booking]);

                    $extra_amount = $downpayment + $possession + $installment + $request->allotment + $request->confirmation  + $request->file_processing + $request->registration + $request->booking + $request->ballon + $request->bulleting;

                    //Make a  downpayment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment, 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }


                    $extra_amount -= $net_amount;



                    //Make a installment Entry
                    for ($i = 1; $i <= $request->installment_plan; $i++) {
                        if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - $extra_amount, 'balance' => $per_installment - $extra_amount, 'surcharge' => 0,
                                'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        } else if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - $extra_amount,
                                'balance' => $per_installment - $extra_amount, 'surcharge' => 0,
                                'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        } else {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment,
                                'balance' => $per_installment, 'surcharge' => 0,
                                'multi_project_id' => $inventory_project_type->multi_project_id
                            ]);
                        }
                    }

                    $possesion_date = $date;

                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }


                    //Make a possession Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 2, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a allotment Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a confirmation Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);


                    //Make a booking Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);



                    //Make a file_processing Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make a registration Entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make ballon payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->ballon, 'balance' => $request->ballon, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);

                    //Make Bulleting payment entry
                    CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->bulleting_date, 'due' => $request->bulleting, 'balance' => $request->bulleting, 'received' => 0, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                }
            } else {

                // dd('5');
                $full_date = new Carbon($request->booking_date);
                //Make a  downpayment entry
                CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $full_date, 'due' => $net_amount, 'balance' => $net_amount, 'multi_project_id' => $inventory_project_type->multi_project_id]);
                if ($request->full_discount) {
                    CustomerPropertyFullPayment::create(['customer_property_id' => $property->id, 'total_amount' => $request->net_amount_full_payment, 'total_tenure' => $request->total_tenure_full_payment, 'discount_percentage' => $request->discount_percentage_full_payment, 'return_tenure' => $request->return_tenure_full_payment, 'discount_amount' => $request->discount_amount_full_payment, 'deduction_amount' => $request->deduction_amount_full_payment]);
                    for ($i = 0; $i < ($request->total_tenure_full_payment / $request->return_tenure_full_payment); $i++) {
                        CustomerPropertyFullPaymentStatement::create(['customer_id' => $customer->id, 'property_id' => $property->id, 'due_date' => $full_date->addMonth($request->return_tenure_full_payment), 'due' => $request->per_full_payment, 'received' => 0, 'balance' => $request->per_full_payment, 'receipt_no' => null, 'receipt_date' => null]);
                    }
                }
            }
            //change the  status of reserved forms
            $inventory = Inventory::where('id', $request->unit_number)->first();
            if ($inventory) {
                Inventory::where('id', $request->unit_number)->update(['status' => Inventory::sold]);
            }

            // $i= Inventory::where('unit_number', $request->unit_number)->first();

            $dealer_file =    OpenFileDealerInfo::where('invertory_id', $inventory->id)->first();


            if (!empty($dealer_file)) {
                // $property = CustomerProperty::create(['customer_id' => $customer->id, 'cost' => $request->total_price, 'booking_date' => $request->booking_date, 'original_boooking_date' =>  $request->original_boooking_date,  'schedule_start_date' => $request->schedule_start_date, 'discount' => $discount, 'booking_type' => $request->booking_type, 'net_pay' => $net_amount, 'inventory_id' => $request->inventory_id, 'membership_no' => $request->membership_number, 'schedular_type' => $request->schedule_type, 'status' => CustomerProperty::pending, 'down_payment_note' => $request->down_payment_note, 'sale_by' => Auth::user()->id, 'access_amount' => $request->access_amount]);
                $pro =  CustomerProperty::where('customer_id', $customer->id)->where('inventory_id', $inventory->id)->first();

                if ($request->booking_type == CustomerProperty::normal) {
                    $c_statement = CustomerStatement::where([['customer_id', $customer->id], ['customer_property_id', $pro->id], ['payment_head', CustomerStatement::down_payment]])->first();

                    $c_statement->received = $c_statement->due;
                    $c_statement->balance = 0;
                    $c_statement->save();
                    $result = Receipt::where([['receipt_no', '!=', null]])
                        ->orderby('receipt_no', 'desc')->first();

                    if ($result)
                        $receipt_no = ++$result->receipt_no;
                    else
                        $receipt_no = '50000';

                    $receipt = new Receipt;
                    $receipt->customer_id = $customer->id;
                    $receipt->customer_property_id = $property->id;
                    $receipt->payment_head = Receipt::down_payment;
                    $receipt->payment_mode = Receipt::adjustment;
                    $receipt->amount = $c_statement->received;
                    $receipt->receipt_no = $receipt_no;
                    $receipt->receipt_date = date('Y-m-d');
                    $receipt->adjustment_type = Receipt::other;
                    $receipt->payment_method = Receipt::adjustment;
                    $receipt->save();
                } else {

                    $c_statement = CustomerStatement::where([['customer_id', $customer->id], ['customer_property_id', $pro->id], ['payment_head', CustomerStatement::down_payment]])->first();
                    $invn =    Inventory::where('id', $request->inventory_id)->first();

                    $total_price =  $invn->dealerPackageOpenFileUnit->dealerPackage->package->pricelist;

                    $pr =    PriceListDetail::where([['pricelist_id', $total_price->id], ['unit_type_id', $invn->unit_type_id], ['unit_size_id', $invn->unit_size_id]])->first();
                    $get_total = $pr->total_price;
                    $scheduleplane = SchedulePlan::first();
                    $per =    $scheduleplane->down_payment;

                    $result = $get_total * $per / 100;



                    $c_statement->received =   $result;
                    $c_statement->balance = 0;
                    $c_statement->save();

                    $result = Receipt::where([['receipt_no', '!=', null]])
                        ->orderby('receipt_no', 'desc')->first();

                    if ($result)
                        $receipt_no = ++$result->receipt_no;
                    else
                        $receipt_no = '50000';

                    $receipt = new Receipt;
                    $receipt->customer_id = $customer->id;
                    $receipt->customer_property_id = $property->id;
                    $receipt->payment_head = Receipt::down_payment;
                    $receipt->payment_mode = Receipt::adjustment;
                    $receipt->amount = $c_statement->received;
                    $receipt->receipt_no = $receipt_no;
                    $receipt->receipt_date = date('Y-m-d');
                    $receipt->adjustment_type = Receipt::other;
                    $receipt->payment_method = Receipt::adjustment;
                    $receipt->save();
                }
            }

            if ($inventory->inventory_type == 1 && isset($request->unit_category_id)) {
                if(count($request->unit_category_id) > 0) {
                    $property =  CustomerProperty::where('customer_id', $customer->id)->where('inventory_id', $inventory->id)->first();

                    for ($i = 0; $i < count($request->unit_category_id); $i++) {
                        CustomerCategoryPreferrence::create(['customer_property_id' => $property->id, 'unit_category_id' => $request->unit_category_id[$i]]);
                    }
                }
            }
        } 
        catch (\Exception $e) {

            // dd($e);
            DB::rollback();
            return false;
        }
        DB::commit();
        return $property;
    }



    public function updateStatement($request)
    {
        DB::beginTransaction();
        try {
            $property = CustomerProperty::where('id', $request->property_id)->first();
            CustomerProperty::where('id', $request->property_id)->update(['schedule_start_date' => $request->schedule_start_date, 'schedular_type' => $request->schedule_type, 'booking_type' => CustomerProperty::full_payment]);
            $net_amount = $property->net_pay;
            //Custom Scheduling
            if ($request->schedule_type == CustomerProperty::inst_custom) {

                if ($request->custom_amount) {
                    for ($i = 0; $i < count($request->custom_amount); $i++) {
                        CustomerStatement::create(['customer_id' => $property->customer_id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::installment, 'inst_no' => 1 + $i, 'due_date' => $request->custom_date[$i], 'due' => $request->custom_amount[$i], 'balance' => $request->custom_amount[$i], 'surcharge' => 0]);
                        // $extra_amount += $request->custom_amount[$i];
                    }
                }
            }
            //End Custom 
            else if ($request->schedule_type == CustomerProperty::inst_mon_w_ann || $request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_mon_w_quar) {

                $date = new Carbon($request->schedule_start_date);
                $date = $date->subMonth();

                $tenure = $request->total_annual_installement_count;
                $total_count = $request->total_annual_installment_count;

                if ($request->amount_schedule == CustomerStatement::percentage) {
                    $monthy_installment = ($net_amount * $request->installment) / 100 * $request->installment_plan;
                    $per_monthly_inst = ($net_amount * $request->installment) / 100;
                    if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                        $semi_installment = ($net_amount * $request->annual_installment) / 100 * $request->total_annual_installment_count;
                        $tenure = 12;
                        $total_count = $request->total_annual_installment_count;
                    } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi) {
                        $semi_installment = ($net_amount * $request->semi_installment) / 100 * $request->total_semi_installment_count;
                        $tenure = 6;
                        $total_count = $request->total_semi_installment_count;
                    } else {
                        $semi_installment = ($net_amount * $request->quarterly_installment) / 100 * $request->total_quarterly_installment_count;
                        $tenure = 3;
                        $total_count = $request->total_quarterly_installment_count;
                    }
                    $per_semi_installment = $semi_installment;
                } else {
                    $monthy_installment = $request->installment * $request->installment_plan;
                    $per_monthly_inst = $request->installment;
                    if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                        $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                        $tenure = 12;
                        $total_count = $request->total_annual_installment_count;
                        $per_semi_installment = $request->annual_installment;
                    } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi) {
                        $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                        $tenure = 6;
                        $total_count = $request->total_semi_installment_count;
                        $per_semi_installment = $request->semi_installment;
                    } else {
                        $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                        $tenure = 3;
                        $total_count = $request->total_quarterly_installment_count;
                        $per_semi_installment = $request->quarterly_installment;
                    }
                }
                CustomerProperty::where('id', $property->id)->update(['installment' => $monthy_installment, 'installment_plan' => $request->installment_plan, 'six_installment' => $semi_installment]);
                $extra_amount = 0;
                if ($request->add_amount) {
                    for ($i = 0; $i < count($request->add_amount); $i++) {
                        CustomerStatement::create(['customer_id' => $property->customer_id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);

                        $extra_amount -= $request->add_amount[$i];
                    }
                }
                $extra_amount -= 0;
                //Make a installment Entry
                for ($i = 1; $i <= $request->installment_plan; $i++) {
                    if ($i % $tenure == 0 && $total_count > 0) {
                        if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_semi_installment + $per_monthly_inst - 0,
                                'balance' => $per_semi_installment + $per_monthly_inst - 0, 'surcharge' => 0
                            ]);
                        } else {
                            CustomerStatement::create([
                                'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_semi_installment + $per_monthly_inst,
                                'balance' => $per_semi_installment + $per_monthly_inst, 'surcharge' => 0
                            ]);
                        }
                        $total_count--;
                    } else if ($i == ($request->installment_plan)) {
                        CustomerStatement::create([
                            'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_monthly_inst - 0,
                            'balance' => $per_monthly_inst - 0, 'surcharge' => 0
                        ]);
                    } else {
                        CustomerStatement::create([
                            'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_monthly_inst,
                            'balance' => $per_monthly_inst, 'surcharge' => 0
                        ]);
                    }
                }
            } else {
                $date = new Carbon($request->schedule_start_date);

                $count = 1;
                if ($request->schedule_type == CustomerProperty::inst_mon) {
                    $count = 1;
                } elseif ($request->schedule_type == CustomerProperty::inst_quar) {
                    $count = 3;
                } elseif ($request->schedule_type == CustomerProperty::inst_semi) {
                    $count = 6;
                } elseif ($request->schedule_type == CustomerProperty::inst_ann) {
                    $count = 12;
                }
                $date = $date->subMonth($count);

                if ($request->amount_schedule == CustomerStatement::percentage) {
                    $installment = ($net_amount * $request->installment) / 100 * $request->installment_plan;
                    $per_installment = ($net_amount * $request->installment) / 100;
                } else {
                    $installment = $request->installment * $request->installment_plan;
                    $per_installment = $request->installment;
                }
                CustomerProperty::where('id', $property->id)->update(['installment' => $installment, 'installment_plan' => $request->installment_plan,]);
                $extra_amount = 0;

                if ($request->add_amount) {
                    for ($i = 0; $i < count($request->add_amount); $i++) {
                        CustomerStatement::create(['customer_id' => $property->customer_id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);

                        $extra_amount += 0;
                    }
                }

                $extra_amount -= 0;



                //Make a installment Entry
                for ($i = 1; $i <= $request->installment_plan; $i++) {
                    if ($i == ($request->installment_plan)) {
                        CustomerStatement::create([
                            'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(1), 'due' => $per_installment - 0, 'balance' => $per_installment, 'surcharge' => 0
                        ]);
                    } else if ($i == ($request->installment_plan)) {
                        CustomerStatement::create([
                            'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - 0,
                            'balance' => $per_installment - 0, 'surcharge' => 0
                        ]);
                    } else {
                        CustomerStatement::create([
                            'customer_id' => $property->customer_id, 'customer_property_id' => $property->id,
                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment,
                            'balance' => $per_installment, 'surcharge' => 0
                        ]);
                    }
                }
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();

        return $property;
    }


    public function updateStatements($request)
    {


        $property = CustomerProperty::where('id', $request->property_id)->first();


        DB::beginTransaction();
        try {


            $net_amount = $request->remianing_payable;

            $customer = Customer::find($property->customer_id);


            // dd($request->remianing_payable, $request->net_amount);

            $received_amount = CustomerStatement::where('customer_property_id', $property->id)->sum('received');


            $remaining_amount =    (int)$property->net_pay - (int)$received_amount;
            // dd($request->remianing_payable,$remaining_amount);

            CustomerStatement::where('received', 0)->where('customer_property_id', $request->property_id)->where('payment_head','!=',CustomerStatement::development)->delete();

            //check if booking type normal or full payment

            if ($request->booking_type == CustomerProperty::normal) {

                //Custom Scheduling

                if ($request->schedule_type == CustomerProperty::inst_custom) {

                    
                      
                    $down_payment_date = new Carbon($request->down_date);
                    $b_date = new Carbon($request->booking_date);
                    $downpayment = $request->down_payment;
                    $possession = $request->possession;

                    //Make a  downpayment entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment]);

                    $lastpaid_installemnt = CustomerStatement::where('customer_property_id', $request->property_id)
                    ->where('payment_head', CustomerStatement::installment)
                    ->where('received', '>', 0)
                    ->latest('id')
                    ->first();
                $last_paid_installment_no = 0;
              
                if (!empty($lastpaid_installemnt)) {

                    $cleanString = preg_replace('/[^0-9]/', '', $lastpaid_installemnt->inst_no);
                    $last_paid_installment_no = (int) $cleanString;
                    
                }
                    if ($request->custom_amount) {
                        for ($i = 0; $i < count($request->custom_amount); $i++) {
                            $last_paid_installment_no=    1 +  $last_paid_installment_no;
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $request->custom_date[$i], 'due' => $request->custom_amount[$i], 'balance' => $request->custom_amount[$i], 'surcharge' => 0]);
                            // $extra_amount += $request->custom_amount[$i];

                            $possesion_date =  $request->custom_date[$i];
                        }
                    }

                    // $possesion_date = $request->custom_date[$request->custom_amount];
                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->remaining_down_payment) / 100;
                        $possession = ($net_amount * $request->remaining_possession) / 100;
                        
                    } else {

                        $downpayment = $request->remaining_down_payment;
                        $possession = $request->remaining_possession;
                       

                        //   $possession_fee = $request->possession_fee;
                    }
                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }

                    if ($request->remaining_down_payment > 0) {
                        //Make a  downpayment entry
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' =>  $down_payment_date, 'due' => $downpayment, 'balance' => $downpayment]);
                    }
                    //Make a possession Entry
                    if ($request->remaining_possession > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);
                    }
                    //Make a allotment Entry
                    if ($request->remaining_allotment > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->remaining_allotment, 'balance' => $request->remaining_allotment, 'received' => 0]);
                    }
                    //Make a confirmation Entry
                    if ($request->remaining_confirmation > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->remaining_confirmation, 'balance' => $request->remaining_confirmation, 'received' => 0]);
                    }

                    //Make a booking Entry
                    if ($request->remaining_booking > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->remaining_booking, 'balance' => $request->remaining_booking, 'received' => 0]);
                    }
                    //Make a ballon Entry
                    if ($request->remaining_ballon > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->remaining_ballon, 'balance' => $request->remaining_ballon, 'received' => 0]);
                    }
                    //Make a balloting Entry
                    if ($request->remaining_balloting > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->balloting_date, 'due' => $request->remaining_balloting, 'balance' => $request->remaining_balloting, 'received' => 0]);
                    }

                    //Make a file_processing Entry
                    if ($request->remaining_file_processing > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->remaining_file_processing, 'balance' => $request->remaining_file_processing, 'received' => 0]);
                    }
                    //Make a registration Entry
                    if ($request->remaining_registration > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->remaining_registration, 'balance' => $request->remaining_registration, 'received' => 0]);
                    }


                    // //Make a possession Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);

                    // //Make a allotment Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0]);

                    // //Make a confirmation Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0]);


                    // //Make a booking Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0]);

                    // //Make a development Entry
                    // // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::development, 'inst_no' => 1, 'due_date' => $request->development_date, 'due' => $request->development, 'balance' => $request->development, 'received' => 0]);


                    // //Make a file_processing Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0]);

                    // //Make a registration Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0]);
                }



                //End Custom 
                else if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann || $request->schedule_type == CustomerProperty::inst_mon_exclude_quar || $request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {
                   
                    $date = new Carbon($request->schedule_start_date);

                    $date = $date->subMonth();
                    $b_date = new Carbon($request->booking_date);


                    //need to edit date for array     
                    $down_payment_date = new Carbon($request->down_date);

                    $tenure = $request->total_annual_installement_count;
                    $total_count = $request->total_annual_installment_count;
                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->remaining_down_payment) / 100;
                        $possession = ($net_amount * $request->remaining_possession) / 100;
                        $monthy_installment = ($net_amount * $request->remaining_single_installment) / 100 * $request->remaining_single_installment;
                        $per_monthly_inst = ($net_amount * $request->remaining_single_installment) / 100;
                        if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann) {
                            $semi_installment = ($net_amount * $request->annual_installment) / 100 * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {
                            $semi_installment = ($net_amount * $request->semi_installment) / 100 * $request->total_semi_installment_count;
                            $tenure = 6;
                            $total_count = $request->total_semi_installment_count;
                        } else {
                            $semi_installment = ($net_amount * $request->quarterly_installment) / 100 * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                        }
                        $per_semi_installment = $semi_installment;
                    } else {

                        $downpayment = $request->remaining_down_payment;
                        $possession = $request->remaining_possession;
                        $monthy_installment = $request->remaining_single_installment * $request->remainig_installment_plan;

                        $per_monthly_inst = $request->remaining_single_installment;

                        if ($request->schedule_type == CustomerProperty::inst_mon_exclude_ann) {
                            $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                            $per_semi_installment = $request->annual_installment;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_exclude_semi || $request->schedule_type == CustomerProperty::inst_quar_exclude_semi) {
                            $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                            $tenure = ($request->schedule_type == CustomerProperty::inst_quar_exclude_semi) ? 3 : 6;
                            $total_count = $request->total_semi_installment_count;
                            $per_semi_installment = $request->semi_installment;
                        } else {
                            $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                            $per_semi_installment = $request->quarterly_installment;
                        }


                        //   $possession_fee = $request->possession_fee;
                    }
                    $total_months = $total_count;
                    //  CustomerProperty::where('id', $property->id)->update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $monthy_installment, 'installment_plan' => $request->installment_plan, 'six_installment' => $semi_installment, 'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date, 'development_date' => $request->development_date, 'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->allotment, 'confirmation_fee' => $request->confirmation, 'development_fee' => $request->development, 'file_processing_fee' => $request->file_processing, 'registration_fee' => $request->registration, 'booking_fee' => $request->booking]);
                    // $extra_amount = $downpayment + $possession + $monthy_installment + $semi_installment + $request->remainig_allotment + $request->remainig_confirmation  + $request->remainig_file_processing + $request->remainig_registration + $request->remainig_booking +  $request->remaining_ballon + $request->remaining_balloting;;
                    $extra_amount = $downpayment + $possession + $monthy_installment + $semi_installment + $request->remaining_allotment + $request->remaining_confirmation  + $request->remaining_file_processing + $request->remaining_registration + $request->remaining_booking +  $request->remaining_ballon + $request->remaining_balloting;





                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }

                    $extra_amount -= $net_amount;

                    $addMonth = ($request->schedule_type == CustomerProperty::inst_quar_exclude_semi) ? 3 : 1;
                    $date->subMonth($addMonth - 1);


                    //installment portion
                    $lastpaid_installemnt = CustomerStatement::where('customer_property_id', $request->property_id)
                        ->where('payment_head', CustomerStatement::installment)
                        ->where('received', '>', 0)
                        ->latest('id')
                        ->first();
                    $last_paid_installment_no = 0;
                    $total_istallment = $request->remainig_installment_plan + $total_months;
                    if (!empty($lastpaid_installemnt)) {

                        $cleanString = preg_replace('/[^0-9]/', '', $lastpaid_installemnt->inst_no);
                        $last_paid_installment_no = (int) $cleanString;
                        $date = new Carbon($lastpaid_installemnt->due_date);

                        $date->subMonth($addMonth - 1);

                        $total_istallment =  $last_paid_installment_no +  $request->remainig_installment_plan + $total_months;
                    }



                    if ($request->remaining_total_installment != 0) {

                        $monthy_installment = $request->remaining_total_installment;
                        // $semi_installment = $request->total_semi_installment;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann){
                            $semi_installment = $request->total_annual_installment;
                        }
                        elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {

                            $semi_installment = $request->total_semi_installment;
                        }
                        else{
                            $semi_installment = $request->total_quarterly_installment;
                        }
                        $total_monthly_installemt_amount = $monthy_installment;
                        $total_semi_installemt_amount = $semi_installment;


                        $totalcounts = $total_istallment;


                        for ($i =  $last_paid_installment_no + 1; $i <= ($total_istallment); $i++) {

                            if ($i % $tenure == 0 && $total_count > 0) {
                                if ($i == ($request->remainig_installment_plan)) {
                                    $add =   $per_semi_installment - $extra_amount;

                                    if ($i == $totalcounts) {
                                        if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount > 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $total_monthly_installemt_amount + $total_semi_installemt_amount,
                                                'balance' =>  $total_monthly_installemt_amount + $total_semi_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);

                                            $total_monthly_installemt_amount = 0;
                                            $total_semi_installemt_amount = 0;
                                        } else if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount <= 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_monthly_installemt_amount,
                                                'balance' =>  $total_monthly_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);
                                            $total_monthly_installemt_amount = 0;
                                        } else if ($total_monthly_installemt_amount <= 0 && $total_semi_installemt_amount > 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_semi_installemt_amount,
                                                'balance' =>  $total_semi_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);
                                            $total_semi_installemt_amount = 0;
                                        }
                                    } else {

                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $add,
                                            'balance' =>  $add, 'surcharge' => 0, 'inst_track' => 1
                                        ]);
                                        $total_semi_installemt_amount = $total_semi_installemt_amount -  $add;
                                    }
                                } else {

                                    if ($i == $totalcounts) {
                                        if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount > 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $total_monthly_installemt_amount + $total_semi_installemt_amount,
                                                'balance' =>  $total_monthly_installemt_amount + $total_semi_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);
                                            $total_monthly_installemt_amount = 0;
                                            $total_semi_installemt_amount = 0;
                                        } else if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount <= 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_monthly_installemt_amount,
                                                'balance' =>  $total_monthly_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);
                                            $total_monthly_installemt_amount = 0;
                                        } else if ($total_monthly_installemt_amount <= 0 && $total_semi_installemt_amount > 0) {
                                            $last_paid_installment_no =   $last_paid_installment_no + 1;
                                            CustomerStatement::create([
                                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_semi_installemt_amount,
                                                'balance' =>  $total_semi_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                            ]);
                                            $total_semi_installemt_amount = 0;
                                        }
                                    } else {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment,
                                            'balance' => $per_semi_installment, 'surcharge' => 0, 'inst_track' => 1
                                        ]);
                                        $total_semi_installemt_amount = $total_semi_installemt_amount - $per_semi_installment;
                                    }
                                }
                                $total_count--;
                            } else if ($i == ($request->remainig_installment_plan)) {

                                $add =  $per_monthly_inst - $extra_amount;
                                if ($i == $totalcounts) {
                                    if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount > 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $total_monthly_installemt_amount + $total_semi_installemt_amount,
                                            'balance' =>  $total_monthly_installemt_amount + $total_semi_installemt_amount, 'surcharge' => 0, 'inst_track' => 1
                                        ]);
                                        $total_monthly_installemt_amount = 0;
                                        $total_semi_installemt_amount = 0;
                                    } else if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount <= 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_monthly_installemt_amount,
                                            'balance' =>  $total_monthly_installemt_amount, 'surcharge' => 0
                                        ]);
                                        $total_monthly_installemt_amount = 0;
                                    } else if ($total_monthly_installemt_amount <= 0 && $total_semi_installemt_amount > 0) {

                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_semi_installemt_amount,
                                            'balance' =>  $total_semi_installemt_amount, 'surcharge' => 0
                                        ]);
                                        $total_semi_installemt_amount = 0;
                                    }
                                } else {
                                    $last_paid_installment_no =   $last_paid_installment_no + 1;
                                    CustomerStatement::create([
                                        'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                        'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst - $extra_amount,
                                        'balance' => $add, 'surcharge' => 0
                                    ]);
                                    $total_monthly_installemt_amount =  $total_monthly_installemt_amount - $add;
                                }
                            } else {

                                if ($i == $totalcounts) {

                                    if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount > 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $total_monthly_installemt_amount + $total_semi_installemt_amount,
                                            'balance' =>  $total_monthly_installemt_amount + $total_semi_installemt_amount, 'surcharge' => 0
                                        ]);
                                        $total_monthly_installemt_amount = 0;
                                        $total_semi_installemt_amount = 0;
                                    } else if ($total_monthly_installemt_amount > 0 && $total_semi_installemt_amount <= 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_monthly_installemt_amount,
                                            'balance' =>  $total_monthly_installemt_amount, 'surcharge' => 0
                                        ]);
                                        $total_monthly_installemt_amount = 0;
                                    } else if ($total_monthly_installemt_amount <= 0 && $total_semi_installemt_amount > 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $total_semi_installemt_amount,
                                            'balance' =>  $total_semi_installemt_amount, 'surcharge' => 0
                                        ]);
                                        $total_semi_installemt_amount = 0;
                                    }
                                } else {
                                    if ($total_monthly_installemt_amount >= $per_monthly_inst) {

                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst,
                                            'balance' => $per_monthly_inst, 'surcharge' => 0
                                        ]);
                                        $total_monthly_installemt_amount =   $total_monthly_installemt_amount - $per_monthly_inst;
                                    } else if ($total_monthly_installemt_amount > 0) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        $amnt = $total_monthly_installemt_amount;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $amnt,
                                            'balance' => $amnt, 'surcharge' => 0
                                        ]);
                                        $total_monthly_installemt_amount =   $total_monthly_installemt_amount - $amnt;
                                    }
                                }
                            }
                        }
                    }

                    $possesion_date = $date;
                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }


                    // //Make a possession Entry

                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);

                    // //Make a allotment Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0]);

                    // //Make a confirmation Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0]);


                    // //Make a booking Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0]);

                    // //Make a development Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::development, 'inst_no' => 1, 'due_date' => $request->development_date, 'due' => $request->development, 'balance' => $request->development, 'received' => 0]);


                    // //Make a file_processing Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0]);

                    // //Make a registration Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0]);


                    if ($request->remaining_down_payment > 0) {
                        //Make a  downpayment entry
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' =>  $down_payment_date, 'due' => $downpayment, 'balance' => $downpayment]);
                    }
                    //Make a possession Entry
                    if ($request->remaining_possession > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);
                    }
                    //Make a allotment Entry
                    if ($request->remaining_allotment > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->remaining_allotment, 'balance' => $request->remaining_allotment, 'received' => 0]);
                    }
                    //Make a confirmation Entry
                    if ($request->remaining_confirmation > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->remaining_confirmation, 'balance' => $request->remaining_confirmation, 'received' => 0]);
                    }

                    //Make a booking Entry
                    if ($request->remaining_booking > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->remaining_booking, 'balance' => $request->remaining_booking, 'received' => 0]);
                    }
                    //Make a ballon Entry
                    if ($request->remaining_ballon > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->remaining_ballon, 'balance' => $request->remaining_ballon, 'received' => 0]);
                    }
                    //Make a balloting Entry
                    if ($request->remaining_balloting > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->balloting_date, 'due' => $request->remaining_balloting, 'balance' => $request->remaining_balloting, 'received' => 0]);
                    }

                    //Make a file_processing Entry
                    if ($request->remaining_file_processing > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->remaining_file_processing, 'balance' => $request->remaining_file_processing, 'received' => 0]);
                    }
                    //Make a registration Entry
                    if ($request->remaining_registration > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->remaining_registration, 'balance' => $request->remaining_registration, 'received' => 0]);
                    }


                    $property->update(['schedular_type' => $request->schedule_type]);
                } else if ($request->schedule_type == CustomerProperty::inst_mon_w_ann || $request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_mon_w_quar || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {
                     
                    $date = new Carbon($request->schedule_start_date);
                    $date = $date->subMonth();
                    $b_date = new Carbon($request->booking_date);
                    $down_payment_date = new Carbon($request->down_date);
                    $tenure = $request->total_annual_installement_count;
                    $total_count = $request->total_annual_installment_count;

                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->remaining_down_payment) / 100;
                        $possession = ($net_amount * $request->remaining_possession) / 100;
                        $monthy_installment = ($net_amount * $request->remaining_single_installment) / 100 * $request->remainig_installment_plan;
                        $per_monthly_inst = ($net_amount * $request->remaining_single_installment) / 100;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                            $semi_installment = ($net_amount * $request->annual_installment) / 100 * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {
                            $semi_installment = ($net_amount * $request->semi_installment) / 100 * $request->total_semi_installment_count;
                            $tenure = 6;
                            $total_count = $request->total_semi_installment_count;
                        } else {
                            $semi_installment = ($net_amount * $request->quarterly_installment) / 100 * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                        }
                        $per_semi_installment = $semi_installment;
                    } else {
                        $downpayment = $request->remaining_down_payment;
                        $possession = $request->remaining_possession;
                        $monthy_installment = $request->remaining_single_installment * $request->remainig_installment_plan;
                        $per_monthly_inst = $request->remaining_single_installment;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                            $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                            $tenure = 12;
                            $total_count = $request->total_annual_installment_count;
                            $per_semi_installment = $request->annual_installment;
                        } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {
                            $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                            $tenure = ($request->schedule_type == CustomerProperty::inst_quar_w_semi) ? 3 : 6;
                            $total_count = $request->total_semi_installment_count;
                            $per_semi_installment = $request->semi_installment;
                        } else {
                            $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                            $tenure = 3;
                            $total_count = $request->total_quarterly_installment_count;
                            $per_semi_installment = $request->quarterly_installment;
                        }
                       


                        //   $possession_fee = $request->possession_fee;
                    }

                    $extra_amount = $downpayment + $possession + $monthy_installment + $semi_installment + $request->remaining_allotment + $request->remaining_confirmation  + $request->remaining_file_processing + $request->remaining_registration + $request->remaining_booking +  $request->remaining_ballon + $request->remaining_balloting;



                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }


                    $extra_amount -= $net_amount;

                    $addMonth = ($request->schedule_type == CustomerProperty::inst_quar_w_semi) ? 3 : 1;
                    $date->subMonth($addMonth - 1);
                    $total_months = $total_count;
                    $lastpaid_installemnt = CustomerStatement::where('customer_property_id', $request->property_id)
                        ->where('payment_head', CustomerStatement::installment)
                        ->where('received', '>', 0)
                        ->latest('id')
                        ->first();
                    $last_paid_installment_no = 0;
                 
                    // if($semi_installment > 0){
                    // $total_istallment = $request->remainig_installment_plan + $total_months;
                    // }
                    // else{
                        $total_istallment = $request->remainig_installment_plan; 
                    // }
                    // dd( $total_istallment,$request->remainig_installment_plan , $total_months);
                    if (!empty($lastpaid_installemnt)) {

                        $cleanString = preg_replace('/[^0-9]/', '', $lastpaid_installemnt->inst_no);
                        $last_paid_installment_no = (int) $cleanString;
                        $date = new Carbon($lastpaid_installemnt->due_date);

                        $date->subMonth($addMonth - 1);

                        $total_istallment =  $last_paid_installment_no +  $request->remainig_installment_plan ;
                    }

                    // dd($last_paid_installment_no+1,$total_istallment);
                    //  dd($last_paid_installment_no, $total_istallment);
                    //Make a installment Entry
                    if ($request->remaining_total_installment != 0) {
                        $monthy_installment = $request->remaining_total_installment;
                        // $semi_installment = $request->total_semi_installment;
                        if ($request->schedule_type == CustomerProperty::inst_mon_w_ann){
                            $semi_installment = $request->total_annual_installment;
                        }
                        elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_quar_w_semi) {

                            $semi_installment = $request->total_semi_installment;
                        }
                        else{
                            $semi_installment = $request->total_quarterly_installment;
                        }
                        $total_monthly_installemt_amount = $monthy_installment;
                        $total_semi_installemt_amount = $semi_installment;

                        $sum_istallment_amount =  $total_monthly_installemt_amount + $total_semi_installemt_amount;
// dd( $sum_istallment_amount,$total_monthly_installemt_amount,$total_semi_installemt_amount );

                        // dd($total_istallment);
                        //  dd( $sum_istallment_amount,$total_istallment, $total_monthly_installemt_amount,$total_semi_installemt_amount);
                        $totalcounts = $total_istallment;
                        // dd($request->remainig_installment_plan);
                        for ($i =  $last_paid_installment_no+1; $i <= ( $total_istallment); $i++) {
                            if ($i % $tenure == 0 && $total_count > 0) {
                                
                                if ($i == ( $totalcounts)) {

                                //   dd($i,$sum_istallment_amount,$per_semi_installment + $per_monthly_inst - $extra_amount);
                                        //    if ($i == $totalcounts) {
                                                            // if ( $sum_istallment_amount > 0 ) {
                                                            //     $last_paid_installment_no =   $last_paid_installment_no + 1;
                                                            //     CustomerStatement::create([
                                                            //         'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                            //         'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $sum_istallment_amount,
                                                            //         'balance' =>   $sum_istallment_amount, 'surcharge' => 0, 'inst_track' => 1
                                                            //     ]);
                                                                
                                                            //     $sum_istallment_amount = 0;
                                                                 
                                                            // }   
                                                            
                                                        // }
                                    // else{
                                        $add =   $per_semi_installment + $per_monthly_inst - $extra_amount;
                              
                                        // dd($i,$add);
                                    $last_paid_installment_no =   $last_paid_installment_no + 1;
                                    CustomerStatement::create([
                                        'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                        'payment_head' => CustomerStatement::installment, 'inst_no' =>$last_paid_installment_no , 'due_date' => $date->addMonth($addMonth), 'due' => $add,
                                        'balance' => $add, 'surcharge' => 0, 'inst_track' => 1
                                    ]);
                                    // dd('anual', $add ,   $per_semi_installment , $per_monthly_inst , $extra_amount);
                                    // $sum_istallment_amount =  $sum_istallment_amount -$add;
                                    if ($sum_istallment_amount >= $add) {
                                        $sum_istallment_amount =  $sum_istallment_amount -$add;
                                      }
                                // }
                            }
                                else {
                                  
                                    if ($i == $totalcounts) {
                                                            if ( $sum_istallment_amount > 0 ) {
                                                                $last_paid_installment_no =   $last_paid_installment_no + 1;
                                                                CustomerStatement::create([
                                                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $sum_istallment_amount,
                                                                    'balance' =>   $sum_istallment_amount, 'surcharge' => 0, 'inst_track' => 1
                                                                ]);
                                                                
                                                                $sum_istallment_amount = 0;
                                                                 
                                                            }   
                                                            
                                                        }
                                                        else{
                                                         $add=   $per_semi_installment + $per_monthly_inst;
                                                         
                                    $last_paid_installment_no =   $last_paid_installment_no + 1;
                                    CustomerStatement::create([
                                        'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                        'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_semi_installment + $per_monthly_inst,
                                        'balance' => $add, 'surcharge' => 0, 'inst_track' => 1
                                    ]);
                                    // $sum_istallment_amount =  $sum_istallment_amount -$per_semi_installment + $per_monthly_inst;
                                    if ($sum_istallment_amount >= $add) {
                                        $sum_istallment_amount =  $sum_istallment_amount -$add;
                                      }
                                }
                            }
                                $total_count--;
                            } else if ($i == ($request->remainig_installment_plan)) {

                                if($i==30){
                                    // dd('1',$i);
                                }
                                if ($i == $totalcounts) {
                                    if ( $sum_istallment_amount > 0 ) {
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $sum_istallment_amount,
                                            'balance' =>   $sum_istallment_amount, 'surcharge' => 0
                                        ]);
                                        
                                        $sum_istallment_amount = 0;
                                         
                                    }   
                                    
                                }
                                else{
                                $last_paid_installment_no =   $last_paid_installment_no + 1;
                               $sum= $per_monthly_inst - $extra_amount;
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst - $extra_amount,
                                    'balance' => $per_monthly_inst - $extra_amount, 'surcharge' => 0
                                ]);
                                // $sum_istallment_amount =  $sum_istallment_amount -$per_monthly_inst - $extra_amount;
                                if ($sum_istallment_amount >= $sum) {
                                    $sum_istallment_amount = $sum_istallment_amount - $sum;
                                  } 
                            }                           
                            } else {
                                // if($i==30){
                                //     // dd('2',$i);
                                // }
                                if ($i == $totalcounts) {
                                    // if($i==30){
                             
                                    // dd('2',$i,$sum_istallment_amount,$per_monthly_inst);
                                    // }
                                if ( $sum_istallment_amount > 0 ) {
                                    $last_paid_installment_no =   $last_paid_installment_no + 1;
                                    CustomerStatement::create([
                                        'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                        'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' =>  $sum_istallment_amount,
                                        'balance' =>   $sum_istallment_amount, 'surcharge' => 0
                                    ]);
                                    
                                    $sum_istallment_amount = 0;
                                     
                                }
                            }
                                else{

                                    
                                        $last_paid_installment_no =   $last_paid_installment_no + 1;
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $last_paid_installment_no, 'due_date' => $date->addMonth($addMonth), 'due' => $per_monthly_inst,
                                            'balance' => $per_monthly_inst, 'surcharge' => 0
                                        ]);
                                        // $sum_istallment_amount =  $sum_istallment_amount -$per_monthly_inst;
                                        if ($sum_istallment_amount >= $per_monthly_inst) {
                                            $sum_istallment_amount = $sum_istallment_amount -  $per_monthly_inst;
                                          } 
                                   
                                   
                              
                            }

                        }
                        }

                        // dd( $sum_istallment_amount);
                    }

                                        // dd($total_istallment, $sum_istallment_amount,$total_monthly_installemt_amount + $total_semi_installemt_amount);
                    // // dd('totla');



                    //other paymentheads
                    $possesion_date = $date;

                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }
                    if ($request->remaining_down_payment > 0) {
                        //Make a  downpayment entry
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment]);
                    }

                    //Make a possession Entry
                    if ($request->remaining_possession > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);
                    }
                    //Make a allotment Entry
                    if ($request->remaining_allotment > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->remaining_allotment, 'balance' => $request->remaining_allotment, 'received' => 0]);
                    }
                    //Make a confirmation Entry
                    if ($request->remaining_confirmation > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->remaining_confirmation, 'balance' => $request->remaining_confirmation, 'received' => 0]);
                    }

                    //Make a booking Entry
                    if ($request->remaining_booking > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->remaining_booking, 'balance' => $request->remaining_booking, 'received' => 0]);
                    }
                    //Make a ballon Entry
                    if ($request->remaining_ballon > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->remaining_ballon, 'balance' => $request->remaining_ballon, 'received' => 0]);
                    }

                    //Make a balloting Entry
                    if ($request->remaining_balloting > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->balloting_date, 'due' => $request->remaining_balloting, 'balance' => $request->remaining_balloting, 'received' => 0]);
                    }
                    //Make a file_processing Entry
                    if ($request->remaining_file_processing > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->remaining_file_processing, 'balance' => $request->remaining_file_processing, 'received' => 0]);
                    }
                    //Make a registration Entry
                    if ($request->remaining_registration > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->remaining_registration, 'balance' => $request->remaining_registration, 'received' => 0]);
                    }

                    $property->update(['schedular_type' => $request->schedule_type]);
                } else {
                  
                    $date = new Carbon($request->schedule_start_date);

                    $count = 1;
                    if ($request->schedule_type == CustomerProperty::inst_mon) {
                        $count = 1;
                    } elseif ($request->schedule_type == CustomerProperty::inst_bi_mon) {
                        $count = 2;
                    } elseif ($request->schedule_type == CustomerProperty::inst_quar) {
                        $count = 3;
                    } elseif ($request->schedule_type == CustomerProperty::inst_semi) {
                        $count = 6;
                    } elseif ($request->schedule_type == CustomerProperty::inst_ann) {
                        $count = 12;
                    }
                    // dd($count);
                    $date = $date->subMonth($count);
                    $b_date = new Carbon($request->booking_date);
                    $down_payment_date = new Carbon($request->down_date);












                    if ($request->amount_schedule == CustomerStatement::percentage) {
                        $downpayment = ($net_amount * $request->remaining_down_payment) / 100;
                        $possession = ($net_amount * $request->remaining_possession) / 100;
                        $installment = ($net_amount * $request->remaining_single_installment) / 100 * $request->remainig_installment_plan;
                        $per_installment = ($net_amount * $request->remaining_single_installment) / 100;
                    } else {
                        $downpayment = $request->remaining_down_payment;
                        $possession = $request->remaining_possession;
                        $installment = $request->remaining_single_installment * $request->remainig_installment_plan;
                        $per_installment = $request->remaining_single_installment;
                    }
                    // CustomerProperty::where('id', $property->id)->update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $installment, 'installment_plan' => $request->remainig_installment_plan,  'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date, 'development_date' => $request->development_date, 'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->remainig_allotment, 'confirmation_fee' => $request->remainig_confirmation, 'development_fee' => $request->remainig_development, 'file_processing_fee' => $request->remainig_file_processing, 'registration_fee' => $request->remainig_registration, 'booking_fee' => $request->remainig_booking]);

                    $extra_amount = $downpayment + $possession + $installment + $request->remaining_allotment + $request->remaining_confirmation + $request->remaining_development + $request->remaining_file_processing + $request->remaining_registration + $request->remaining_booking +  $request->remaining_ballon + $request->remaining_balloting;

                    //Make a  downpayment entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $b_date, 'due' => $downpayment, 'balance' => $downpayment, 'surcharge' => 0]);
                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }
                    $extra_amount -= $net_amount;



                        $lastpaid_installemnt = CustomerStatement::where('customer_property_id', $request->property_id)
                        ->where('payment_head', CustomerStatement::installment)
                        ->where('received', '>', 0)
                        ->latest('id')
                        ->first();
                   
                        $last_paid_installment_no = 0;
                 
                   
                        $total_istallment = $request->remainig_installment_plan; 
                     
                    if (!empty($lastpaid_installemnt)) {

                        $cleanString = preg_replace('/[^0-9]/', '', $lastpaid_installemnt->inst_no);
                        $last_paid_installment_no = (int) $cleanString;
                        $date = new Carbon($lastpaid_installemnt->due_date);

                        $date->subMonth($count - 1);

                        $total_istallment =  $last_paid_installment_no +  $request->remainig_installment_plan ;
                    }




                    //Make a installment Entry
                    if ($request->remaining_total_installment != 0) {

                       
                        $totalcounts = $total_istallment;
                        
                        $sum_istallment_amount =   $request->remaining_total_installment;
                 

                        for ($i = $last_paid_installment_no+1; $i <= $total_istallment; $i++) {
                            if ($i == ($totalcounts)) {

                                // else{
                                $add=    $per_installment - $extra_amount;
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count),
                                    'due' => $per_installment - $extra_amount, 'balance' => $per_installment - $extra_amount, 'surcharge' => 0,
                                ]);
                                if ($sum_istallment_amount >= $add) {
                                    $sum_istallment_amount =  $sum_istallment_amount -$add;
                                  }
                            // }
                            } else if ($i == ($request->remainig_installment_plan)) {
                                if ($i == $totalcounts) {
                                    if ( $sum_istallment_amount > 0 ) {
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $sum_istallment_amount,
                                            'balance' => $sum_istallment_amount, 'surcharge' => 0, 
                                        ]);
                                        $sum_istallment_amount =0;
                                    }}
                                else{
                                $add=$per_installment - $extra_amount;
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - $extra_amount,
                                    'balance' => $per_installment - $extra_amount, 'surcharge' => 0,
                                ]);
                                if ($sum_istallment_amount >= $add) {
                                    $sum_istallment_amount =  $sum_istallment_amount -$add;
                                  }
                                }
                            } else {

                                if ($i == $totalcounts) {
                                    if ( $sum_istallment_amount > 0 ) {
                                        CustomerStatement::create([
                                            'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                            'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $sum_istallment_amount,
                                            'balance' => $sum_istallment_amount, 'surcharge' => 0
                                        ]);
                                        $sum_istallment_amount =0;
                                    }}
                                else{
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment,
                                    'balance' => $per_installment, 'surcharge' => 0
                                ]);
                                if ($sum_istallment_amount >=$per_installment) {
                                    $sum_istallment_amount =  $sum_istallment_amount -$per_installment;
                                  }
                                }
                            }
                        }
                    }
                    $possesion_date = $date;

                    if (!empty($request->possession_date)) {
                        $possesion_date = $request->possession_date;
                    }

                    if ($request->remaining_down_payment > 0) {
                        //Make a  downpayment entry
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $down_payment_date, 'due' => $downpayment, 'balance' => $downpayment]);
                    }
                    //Make a possession Entry
                    if ($request->remaining_possession > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 1, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);
                    }
                    //Make a allotment Entry
                    if ($request->remaining_allotment > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->remaining_allotment, 'balance' => $request->remaining_allotment, 'received' => 0]);
                    }
                    //Make a confirmation Entry
                    if ($request->remaining_confirmation > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->remaining_confirmation, 'balance' => $request->remaining_confirmation, 'received' => 0]);
                    }

                    //Make a booking Entry
                    if ($request->remaining_booking > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->remaining_booking, 'balance' => $request->remaining_booking, 'received' => 0]);
                    }
                    //Make a ballon Entry
                    if ($request->remaining_ballon > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::ballon, 'inst_no' => 1, 'due_date' => $request->ballonpayment_date, 'due' => $request->remaining_ballon, 'balance' => $request->remaining_ballon, 'received' => 0]);
                    }
                    //Make a balloting Entry
                    if ($request->remaining_balloting > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::balloting, 'inst_no' => 1, 'due_date' => $request->balloting_date, 'due' => $request->remaining_balloting, 'balance' => $request->remaining_balloting, 'received' => 0]);
                    }

                    //Make a file_processing Entry
                    if ($request->remaining_file_processing > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->remaining_file_processing, 'balance' => $request->remaining_file_processing, 'received' => 0]);
                    }
                    //Make a registration Entry
                    if ($request->remaining_registration > 0) {
                        CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->remaining_registration, 'balance' => $request->remaining_registration, 'received' => 0]);
                    }
                    // //Make a possession Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::possession, 'inst_no' => 2, 'due_date' => $possesion_date, 'due' => $possession, 'balance' => $possession, 'received' => 0]);

                    // //Make a allotment Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::allotment, 'inst_no' => 1, 'due_date' => $request->allotment_date, 'due' => $request->allotment, 'balance' => $request->allotment, 'received' => 0]);

                    // //Make a confirmation Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::confirmation, 'inst_no' => 1, 'due_date' => $request->confirmation_date, 'due' => $request->confirmation, 'balance' => $request->confirmation, 'received' => 0]);


                    // //Make a booking Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::booking, 'inst_no' => 1, 'due_date' => $request->booking_date, 'due' => $request->booking, 'balance' => $request->booking, 'received' => 0]);

                    // //Make a development Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::development, 'inst_no' => 1, 'due_date' => $request->development_date, 'due' => $request->development, 'balance' => $request->development, 'received' => 0]);


                    // //Make a file_processing Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::file_processing, 'inst_no' => 1, 'due_date' => $request->file_processing_date, 'due' => $request->file_processing, 'balance' => $request->file_processing, 'received' => 0]);
                    // //Make a registration Entry
                    // CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::registration, 'inst_no' => 1, 'due_date' => $request->registration_date, 'due' => $request->registration, 'balance' => $request->registration, 'received' => 0]);
                    $property->update(['schedular_type' => $request->schedule_type]);
                }
            } else {

                // dd('full');
                $full_date = new Carbon($request->booking_date);
                //Make a  downpayment entry
                CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::down_payment, 'inst_no' => 2, 'due_date' => $full_date, 'due' => $net_amount, 'balance' => $net_amount]);

                if ($request->full_discount) {
                    CustomerPropertyFullPayment::create(['customer_property_id' => $property->id, 'total_amount' => $request->net_amount_full_payment, 'total_tenure' => $request->total_tenure_full_payment, 'discount_percentage' => $request->discount_percentage_full_payment, 'return_tenure' => $request->return_tenure_full_payment, 'discount_amount' => $request->discount_amount_full_payment, 'deduction_amount' => $request->deduction_amount_full_payment]);



                    for ($i = 0; $i < ($request->total_tenure_full_payment / $request->return_tenure_full_payment); $i++) {
                        CustomerPropertyFullPaymentStatement::create(['customer_id' => $customer->id, 'property_id' => $property->id, 'due_date' => $full_date->addMonth($request->return_tenure_full_payment), 'due' => $request->per_full_payment, 'received' => 0, 'balance' => $request->per_full_payment, 'receipt_no' => null, 'receipt_date' => null]);
                    }
                }
            }


            if ($request->remianing_payable > $remaining_amount) {
                $extra = $request->remianing_payable - $remaining_amount;
                $new_net_pay =  $property->net_pay + $extra;

                $customer_stat =   CustomerStatement::where('customer_property_id', $request->property_id)->get();
                $new_down_payment = $customer_stat->where('payment_head', CustomerStatement::down_payment)->sum('due');
                $new_possession = $customer_stat->where('payment_head', CustomerStatement::possession)->sum('due');
                $new_installment = $customer_stat->where('payment_head', CustomerStatement::installment)->sum('due');
                $new_allotment_fee = $customer_stat->where('payment_head', CustomerStatement::allotment)->sum('due');
                $new_confirmation_fee = $customer_stat->where('payment_head', CustomerStatement::confirmation)->sum('due');

                $new_file_processing_fee = $customer_stat->where('payment_head', CustomerStatement::file_processing)->sum('due');
                $new_registration_fee = $customer_stat->where('payment_head', CustomerStatement::registration)->sum('due');
                $new_booking_fee = $customer_stat->where('payment_head', CustomerStatement::booking)->sum('due');




                CustomerProperty::where('id', $request->property_id)->update(['net_pay' => $new_net_pay, 'down_payment' => $new_down_payment, 'possession_fee' =>  $new_possession, 'installment' =>  $new_installment,  'allotment_fee' => $new_allotment_fee, 'confirmation_fee' => $new_confirmation_fee,  'file_processing_fee' => $new_file_processing_fee, 'registration_fee' => $new_registration_fee, 'booking_fee' => $new_booking_fee]);




                // $property = CustomerProperty::update(['cost' => $request->total_price, 'booking_date' => $request->booking_date, 'original_boooking_date' =>  $request->original_boooking_date,  'discount' => '', 'booking_type' => $request->booking_type, 'net_pay' => $net_amount,   'schedular_type' => $request->schedule_type]);

                // CustomerProperty::update(['down_payment' => $downpayment, 'possession_fee' => $possession, 'installment' => $monthy_installment, 'installment_plan' => $request->installment_plan,  'allotment_date' => $request->allotment_date, 'confirmation_date' => $request->confirmation_date, 'development_date' => $request->development_date, 'file_processing_date' => $request->file_processing_date, 'registration_date' => $request->registration_date, 'allotment_fee' => $request->allotment, 'confirmation_fee' => $request->confirmation, 'development_fee' => $request->development, 'file_processing_fee' => $request->file_processing, 'registration_fee' => $request->registration, 'booking_fee' => $request->booking]);



            }
            if ($request->newdiscount > 0) {
                $old_disount =  $property->discount;
                $new_discount =  $old_disount + $request->newdiscount;
                $new_cost = $property->cost - $request->newdiscount;
                $net_pay =    $property->net_pay - $request->newdiscount;
                $property->update(['discount' => $new_discount]);
                $property->update(['cost' =>  $new_cost]);
                $property->update(['net_pay' =>  $net_pay]);



                $customer_stat =   CustomerStatement::where('customer_property_id', $request->property_id)->get();
                $new_down_payment = $customer_stat->where('payment_head', CustomerStatement::down_payment)->sum('due');
                $new_possession = $customer_stat->where('payment_head', CustomerStatement::possession)->sum('due');
                $new_installment = $customer_stat->where('payment_head', CustomerStatement::installment)->sum('due');
                $new_allotment_fee = $customer_stat->where('payment_head', CustomerStatement::allotment)->sum('due');
                $new_confirmation_fee = $customer_stat->where('payment_head', CustomerStatement::confirmation)->sum('due');

                $new_file_processing_fee = $customer_stat->where('payment_head', CustomerStatement::file_processing)->sum('due');
                $new_registration_fee = $customer_stat->where('payment_head', CustomerStatement::registration)->sum('due');
                $new_booking_fee = $customer_stat->where('payment_head', CustomerStatement::booking)->sum('due');




                CustomerProperty::where('id', $request->property_id)->update(['down_payment' => $new_down_payment, 'possession_fee' =>  $new_possession, 'installment' =>  $new_installment,  'allotment_fee' => $new_allotment_fee, 'confirmation_fee' => $new_confirmation_fee,  'file_processing_fee' => $new_file_processing_fee, 'registration_fee' => $new_registration_fee, 'booking_fee' => $new_booking_fee]);
            }

            //change the  status of reserved forms
            $inventory = Inventory::where('id', $request->unit_number)->first();
            if ($inventory) {
                Inventory::where('id', $request->unit_number)->update(['status' => Inventory::sold]);
            }
        } catch (\Exception $e) {

            // dd($e);
            DB::rollback();
            return false;
        }
        DB::commit();

        return $property;
    }

    public function updateInstallmentStatement($request)
    {


        DB::beginTransaction();
        try {

            CustomerProperty::where('id', $request->id)->update(['down_payment_note' => $request->down_payment_note, 'schedule_start_date' => $request->schedule_start_date, 'schedular_type' => $request->schedule_type, 'booking_type' => CustomerProperty::full_payment]);

            if ($request->sms_alert) {
                CustomerProperty::where('id', $request->id)->update(['sms_alert' => $request->sms_alert]);
            }
            if ($request->email_alert) {
                CustomerProperty::where('id', $request->id)->update(['email_alert' => $request->email_alert]);
            }

            $property = CustomerProperty::where('id', $request->id)->with('customer')->first();

            if ($request->update_schedule) {

                //get the property info

                $customer = Customer::where('id', $property->customer_id)->first();

                $net_amount = $request->rem_amount;

                //delete privious unpaid installment
                CustomerStatement::where([['customer_property_id', $request->id], ['payment_head', CustomerStatement::installment], ['received', 0]])->delete();

                //Custom Scheduling




                //End Custom 


                //   // $statement = CustomerStatement::where([['customer_property_id',$request->id],['payment_head',CustomerStatement::installment]])->orderBy('id','desc')->first();

                //     if($statement) {

                //     $date = new Carbon($statement->due_date);

                //     $b_date = new Carbon($statement->due_date);
                //     }
                //     else {
                //          $date = Carbon::now();
                //          $b_date = Carbon::now();
                //     }

                $date = new Carbon($request->schedule_start_date);
                $date = $date->subMonth();


                if ($request->schedule_type == CustomerProperty::inst_custom) {

                    if ($request->custom_amount) {
                        for ($i = 0; $i < count($request->custom_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::installment, 'inst_no' => 3 + $i, 'due_date' => $request->custom_date[$i], 'due' => $request->custom_amount[$i], 'balance' => $request->custom_amount[$i], 'surcharge' => 0]);
                            // $extra_amount += $request->custom_amount[$i];
                        }
                    }
                } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_ann || $request->schedule_type == CustomerProperty::inst_mon_w_semi || $request->schedule_type == CustomerProperty::inst_mon_w_quar) {




                    $tenure = $request->total_annual_installement_count;
                    $total_count = $request->total_annual_installment_count;


                    $monthy_installment = $request->installment * $request->installment_plan;
                    $per_monthly_inst = $request->installment;
                    if ($request->schedule_type == CustomerProperty::inst_mon_w_ann) {
                        $semi_installment = $request->annual_installment * $request->total_annual_installment_count;
                        $tenure = 12;
                        $total_count = $request->total_annual_installment_count;
                        $per_semi_installment = $request->annual_installment;
                    } elseif ($request->schedule_type == CustomerProperty::inst_mon_w_semi) {
                        $semi_installment = $request->semi_installment * $request->total_semi_installment_count;
                        $tenure = 6;
                        $total_count = $request->total_semi_installment_count;
                        $per_semi_installment = $request->semi_installment;
                    } else {
                        $semi_installment = $request->quarterly_installment * $request->total_quarterly_installment_count;
                        $tenure = 3;
                        $total_count = $request->total_quarterly_installment_count;
                        $per_semi_installment = $request->quarterly_installment;
                    }

                    $extra_amount = $monthy_installment + $semi_installment;

                    //add other amount
                    CustomerStatement::where([['customer_property_id', $property->id], ['payment_head', CustomerStatement::other]], ['received', 0])->delete();

                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }


                    $extra_amount -= $net_amount;

                    $co = CustomerStatement::where('customer_property_id', $request->id)->where('received', '>', 0)->count() - 1;

                    //Make a installment Entry
                    for ($i =  $co; $i < $request->installment_plan + $co; $i++) {
                        if ($i % $tenure == 0 && $total_count > 0) {
                            if ($i == ($request->installment_plan)) {
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_semi_installment + $per_monthly_inst - $extra_amount,
                                    'balance' => $per_semi_installment + $per_monthly_inst - $extra_amount, 'surcharge' => 0
                                ]);
                            } else {
                                CustomerStatement::create([
                                    'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                    'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_semi_installment + $per_monthly_inst,
                                    'balance' => $per_semi_installment + $per_monthly_inst, 'surcharge' => 0
                                ]);
                            }
                            $total_count--;
                        } else if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_monthly_inst - $extra_amount,
                                'balance' => $per_monthly_inst - $extra_amount, 'surcharge' => 0
                            ]);
                        } else {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth(), 'due' => $per_monthly_inst,
                                'balance' => $per_monthly_inst, 'surcharge' => 0
                            ]);
                        }

                        //$co++;
                    }
                } else {

                    $count = 1;

                    if ($request->schedule_type == CustomerProperty::inst_mon) {
                        $count = 1;
                    } elseif ($request->schedule_type == CustomerProperty::inst_quar) {
                        $count = 3;
                    } elseif ($request->schedule_type == CustomerProperty::inst_semi) {
                        $count = 6;
                    } elseif ($request->schedule_type == CustomerProperty::inst_ann) {
                        $count = 12;
                    }


                    $installment = $request->installment * $request->installment_plan;
                    $per_installment = $request->installment;

                    $extra_amount = $installment;

                    //add other amount
                    CustomerStatement::where([['customer_property_id', $property->id], ['payment_head', CustomerStatement::other]], ['received', 0])->delete();

                    if ($request->add_amount) {
                        for ($i = 0; $i < count($request->add_amount); $i++) {
                            CustomerStatement::create(['customer_id' => $customer->id, 'customer_property_id' => $property->id, 'payment_head' => CustomerStatement::other, 'inst_no' => 3 + $i, 'due_date' => $request->add_date[$i], 'due' => $request->add_amount[$i], 'balance' => $request->add_amount[$i], 'surcharge' => 0]);
                            $extra_amount += $request->add_amount[$i];
                        }
                    }


                    $extra_amount -= $net_amount;



                    //Make a installment Entry
                    for ($i = 1; $i <= $request->installment_plan; $i++) {
                        if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - $extra_amount, 'balance' => $per_installment - $extra_amount, 'surcharge' => 0
                            ]);
                        } else if ($i == ($request->installment_plan)) {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment - $extra_amount,
                                'balance' => $per_installment - $extra_amount, 'surcharge' => 0
                            ]);
                        } else {
                            CustomerStatement::create([
                                'customer_id' => $customer->id, 'customer_property_id' => $property->id,
                                'payment_head' => CustomerStatement::installment, 'inst_no' => $i, 'due_date' => $date->addMonth($count), 'due' => $per_installment,
                                'balance' => $per_installment, 'surcharge' => 0
                            ]);
                        }
                    }
                }

                CustomerProperty::where('id', $request->id)->update(['schedular_type' => $request->schedule_type]);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();

        return $property;
    }

    public function deleteProperty($id)
    {

        //get all the properties of customer
        $pro = CustomerProperty::where('id', $id)->with('inventory')->first();

        //update the status of invnentry
        if ($pro->inventory) {
            // Inventory::where('id', $pro->inventory->id)->update(['status' => Inventory::open]);
            ProjectAccount::where('inventory_id', $pro->inventory->id)->delete();
        }

        //delete all the statement of this property
        CustomerStatement::where('customer_property_id', $pro->id)->delete();

        //delete the dealer transactio
        DealerTransaction::where('product_id', $pro->id)->delete();
        //delete the receipts
        Receipt::where('customer_property_id', $pro->id)->delete();

        $amount = Receipt::where([['customer_id', $pro->customer_id], ['is_deleted', false]])->sum('amount');

        Customer::where('id', $pro->customer_id)->update(['total_paid_amount' => $amount]);

        CustomerProperty::where('id', $pro->id)->delete();
    }

    public function updateClientId($request)
    {

        CustomerProperty::where('id', $request->id)->update(['status' => $request->status, 'membership_no' => $request->membership_no]);

        if ($request->status == CustomerProperty::approved) {

            $property = CustomerProperty::where('id', $request->id)->first();

            $customer = Customer::where('id', $property->customer_id)->first();

            $inventory = Inventory::where('id', $property->inventory_id)->first();

            $received_amount = Receipt::where('customer_property_id', $request->id)->sum('amount');

            $balance = $property->net_pay - $received_amount;

            // if ($request->notify_sms && $customer->mobile_number) {
            //send sms
            // $message = "Asalam o Alikum, Dear " . $customer->name . " your apartment # " . $inventory->unit_number . " with The Amaar Lodges is booked successfully.
            // Total amount received is PKR " . $received_amount . " only. Remaining amount is PKR " . $balance . " only.
            //  Sales Department
            // The Amaar Lodges";

            $type =   EmailSmsType::where('name', 'like', 'Property Approved')->first();
            if (!empty($type)) {
                
  $project_name=    $inventory->multiProject? $inventory->multiProject->name:'None';

                $detail =   $type->detail->where('content_type', EmailSms::content_type_email)->first();
                if (!empty($detail)) {
                    if ($detail->status == EmailSms::status_on) {
                        $msg = $detail->content;
                        $message = __($msg, [
                            'name' => $customer->name,
                            'receivedamount' => $received_amount,
                            'unitnumber' => $inventory->unit_number,
                            'balance' => $balance,
                            'membership' => $property->membership_no

                        ]);


                        if ($request->notify_email && $customer->email) {

                            //   Mail::to($customer->email)->send(new Membership($message));
                            $smtp = SmtpSetting::where('status', 1)->first();
                            $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                                ->setUsername($smtp->smtp_username)
                                ->setPassword($smtp->smtp_password);
                            $mailer = new \Swift_Mailer($transport);
                            $email = (new Membership($message,$project_name))
                                ->subject('Property Approved')
                                ->from($smtp->from_email, $smtp->from_name)
                                ->to($customer->email)
                                ->view('emails.membership');
                            $email_message = $email->render();
                            $swiftMessage = (new \Swift_Message())
                                ->setSubject('Property Approved')
                                ->setFrom($smtp->from_email, $smtp->from_name)
                                ->setTo($customer->email)
                                ->setBody($email_message, 'text/html');
                            $response = $mailer->send($swiftMessage);
                            $email_log =  new EmailLog;
                            $email_log->smpt_setting_id = $smtp->id;
                            $email_log->receiver_email = $customer->email;
                            $email_log->content = $message;
                            $email_log->title = 'Property Approved';
                            $email_log->mailable_class = 'new Membership';
                            $email_log->mail_view = 'emails.membership';
                            $email_log->project_name = $project_name;
                            if ($response) {

                                $email_log->status = 1;
                            } else {
                                $email_log->status = 0;
                            }
                            $email_log->save();
                        }
                    }
                }

                $detail2 =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                if (!empty($detail2)) {
                  
                    if ($detail2->status == EmailSms::status_on) {
                        $msg = $detail2->content;
                        $message = __($msg, [
                            'name' => $customer->name,
                            'receivedamount' => $received_amount,
                            'unitnumber' => $inventory->unit_number,
                            'balance' => $balance,
                            'membership' => $property->membership_no

                        ]);
                     
                        if ($request->notify_sms && $customer->mobile_number) {
                          
                       $response=     SmsController::sendSMS("92" . substr($customer->mobile_number, 1), $message);
                       $total_characters = strlen($message);
                          $sms_log= new SmsLog;
                          $sms_log->receiver_number = "92" . substr($customer->mobile_number, 1);
                          $sms_log->content =$message;
                          $sms_log->title='Property Approved';
                          $sms_log->total_charcter =$total_characters;
                          if (strpos($response, 'Your Message is sent') !== false){
                            $sms_log->status = 1;
                          }
                          else{
                            $sms_log->status = 0;
                          }
                          $sms_log->response = $response;
                          $sms_log->project_name = $project_name;
                        $sms_log->save();
                        
                    }
                    }
                }

                //           $message = "Hi ".$customer->name.",
                // Congratulations! Your Booking of Unit #. ".$inventory->unit_number." is confirmed now. Your client ID is ".$request->membership_no.". Welcome to J7!";


            }

            //send mail
            // if ($request->notify_email && $customer->email) {

            //   Mail::to($customer->email)->send(new Membership($customer,$registration_number,$property,$inventory));
            // }
        } elseif ($request->status == CustomerProperty::cancel) {
            $property = CustomerProperty::where('id', $request->id)->first();

            Inventory::where('id', $property->inventory_id)->update(['status' => Inventory::open]);
        }
    }

    public function insertDevelopmentChargesOLD($request)
    {
        try {
            $customer_pro =   CustomerProperty::where('id', $request->customer_property_id)->first();
            $cs =    CustomerStatement::where([['customer_id', $customer_pro->customer_id], ['customer_property_id', $customer_pro->id], ['payment_head', CustomerStatement::development]])->count();

            if ($request->schedule_type == CustomerProperty::full_payment) {
                CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $cs + 1, 'due_date' => $request->development_date, 'due' => $request->development_charges, 'balance' => $request->development_charges, 'received' => 0]);
                $customer_pro->development_fee = $customer_pro->development_fee + $request->development_charges;
                $customer_pro->net_pay = $customer_pro->net_pay + $request->development_charges;
                $customer_pro->save();
            } elseif ($request->schedule_type == CustomerProperty::inst_custom) {
                $deve_fee = 0;
                foreach ($request->custom_date as $index => $value) {
                    CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $index + $cs, 'due_date' => $value, 'due' => $request->custom_amount[$index], 'balance' => $request->custom_amount[$index], 'received' => 0]);
                    $deve_fee = $request->custom_amount[$index] + $deve_fee;
                }
                $customer_pro->development_fee = $customer_pro->development_fee +  $deve_fee;
                $customer_pro->net_pay = $deve_fee + $customer_pro->net_pay;
                $customer_pro->save();
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();
        return true;
    }


    public function insertDevelopmentCharges($request)
    {
        try {
            $development_charges =    DevelopmentCharges::where('id', $request->id)->first();

            $customer_pro =   CustomerProperty::where('id', $development_charges->customer_property_id)->first();
            //  $cs=  CustomerStatement::where([['customer_id', $customer_pro->customer_id], ['customer_property_id', $customer_pro->id], ['payment_head', CustomerStatement::development]])->count();

            if ($development_charges->schedule_type == CustomerProperty::full_payment) {
                $data =  unserialize($development_charges->charges_detail);


                CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $data['inst_no'], 'due_date' => $data['due_date'], 'due' => $data['due'], 'balance' => $data['balance'], $data['received'] => 0]);
                $customer_pro->development_date = $data['due_date'];
                $customer_pro->development_fee = $customer_pro->development_fee + $data['due'];
                $customer_pro->net_pay = $customer_pro->net_pay + $data['due'];
                $customer_pro->save();



                $development_charges->is_approved = 1;
                $development_charges->save();
            } elseif ($development_charges->schedule_type == CustomerProperty::inst_custom) {

                $data =  unserialize($development_charges->charges_detail);

                $deve_fee = 0;
                foreach ($data['due_date'] as $index => $value) {
                    CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $data['inst_no'][$index], 'due_date' => $value, 'due' => $data['due'][$index], 'balance' => $data['balance'][$index], 'received' => 0]);
                    $deve_fee = $data['due'][$index] + $deve_fee;
                }
                $customer_pro->development_fee = $customer_pro->development_fee +  $deve_fee;
                $customer_pro->net_pay = $deve_fee + $customer_pro->net_pay;
                $customer_pro->save();
                $development_charges->is_approved = 1;
                $development_charges->save();
            }
        } catch (\Exception $e) {
            DB::rollback();
            $data = [

                'status' => false
            ];
            return $data;
        }
        DB::commit();
        $data = [
            'id' => $customer_pro->id,
            'status' => true
        ];
        return $data;
    }

    public function updateDevelopmentCharges($request)
    {
        // dd($request->all());
     
        try {
           
            $customer_pro =   CustomerProperty::where('id',$request->customer_property_id)->first();
          //  $cs=  CustomerStatement::where([['customer_id', $customer_pro->customer_id], ['customer_property_id', $customer_pro->id], ['payment_head', CustomerStatement::development]])->count();
        $delete_customerstatement_amount=  CustomerStatement::where('received', 0)->where('customer_property_id', $customer_pro->id)->where('payment_head','=',CustomerStatement::development)->sum('due');
        $lastpaid_installemnt = CustomerStatement::where('customer_property_id', $request->property_id)
        ->where('payment_head', CustomerStatement::development)
        ->where('received', '>', 0)
        ->latest('id')
        ->first();
        $last_paid_installment_no = 0;
          CustomerStatement::where('received', 0)->where('customer_property_id', $customer_pro->id)->where('payment_head','=',CustomerStatement::development)->delete();

            if ($request->schedule_type == CustomerProperty::full_payment) {
                

                // CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $data['inst_no'], 'due_date' => $data['due_date'], 'due' => $data['due'], 'balance' => $data['balance'], $data['received'] => 0]);
              
                $last_paid_installment_no=   $last_paid_installment_no + 1;
                CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $last_paid_installment_no, 'due_date' => $request->development_date, 'due' => $request->development_charges, 'balance' => $request->development_charges, 'received' => 0]);
              
                $customer_pro->development_date =  $request->development_date;
                $customer_pro->development_fee = $customer_pro->development_fee + $request->development_charges - $delete_customerstatement_amount;
                $customer_pro->net_pay = $customer_pro->net_pay +$request->development_charges - $delete_customerstatement_amount;
                $customer_pro->save();



              
            } elseif ($request->schedule_type == CustomerProperty::inst_custom) {
                
       
           
            if (!empty($lastpaid_installemnt)) {

                $cleanString = preg_replace('/[^0-9]/', '', $lastpaid_installemnt->inst_no);
                $last_paid_installment_no = (int) $cleanString;
             
            }
               

                $deve_fee = 0;
                for ($i = 0; $i < (sizeof($request->custom_date)); $i++){
                    if($request->custom_amount[$i] > 0){
                    $last_paid_installment_no=   $last_paid_installment_no + 1;
                    CustomerStatement::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $last_paid_installment_no, 'due_date' => $request->custom_date[$i], 'due' => $request->custom_amount[$i], 'balance' => $request->custom_amount[$i], 'received' => 0]);
                    $deve_fee = $request->custom_amount[$i] + $deve_fee;
                }
            }
                $customer_pro->development_fee = $customer_pro->development_fee - $delete_customerstatement_amount +  $deve_fee;
                $customer_pro->net_pay = $deve_fee + $customer_pro->net_pay - $delete_customerstatement_amount;
                $customer_pro->save();
                
            }
        } catch (\Exception $e) {
           
            DB::rollback();
            $data = [

                'status' => false
            ];
            return $data;
        }
        DB::commit();
        $data = [
            'id' => $customer_pro->id,
            'status' => true
        ];
        return $data;
    }
}
