<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerPropertyPartner extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'property_id','customer_id'    ];
    
    public function property() {
        return $this->belongsTo('\App\CustomerProperty','property_id');
    }
    
    public function customer() {
        return $this->belongsTo('\App\Customer','customer_id');
    }
}
