<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerPropertyTax extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    //tax pay Status
    const paid = 1;
    const unpaid = 0;


    protected $fillable = [
       'customer_id','property_id','installment_id','tax','status','tax_pay_by','tax_payment_received','reference','cpr','multi_project_id'
    ];

    public function statement() {
      return $this->belongsTo('App\CustomerStatement','installment_id')->with('receipt');
    }

  
}
