<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerRefundUnitReceipt extends Model
{
    //
    protected $fillable = [
        'customer_id',
        'customer_property_id',
        
        'payment_mode',
        'bank_name',
        'cheque_number',
        'cheque_title',
        'cheaque_status',
        'drawn_date',
        'amount',
        'receipt_no',
        'receipt_date',
        'reference_no',
        'receipt_id',
        'company_account',
        'adjustment_type',
        'adjustment_detail',
        'inventory_id',
        'is_deleted',
        'is_approved',
        'payment_method',
        'dealer_adjustment_unit_id',
        'vendor_purchase_order_id',
        'notes',
        'is_book',
        'tax_paid_by',
        'tax_payment_received',
        'tax_amount',
        'cancel_property_id',
        'notify_sms',
        'notify_email',
        'multi_project_id'
    ];


    
    const pending = 0;
    const approve = 1;
    const cancel = 2;
     //tax pay by
     const customer = 1;
     const company = 2;
     const dealer = 3;


     public function documents()
     {
         return $this->hasMany('App\RefundReceiptDocument', 'refund_receipt_id')->where('close_unit',1);
     }
     public function customer()
     {
         return $this->belongsTo('\App\Customer');
     }
    public function property()
    {
        return $this->belongsTo('App\CustomerProperty', 'customer_property_id')->with('inventory');
    }
    public function multiProject()
    {
        return $this->belongsTo('\App\MultiProject', 'multi_project_id','id');
    }
}
