<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;

class Dealer extends Model
{
   /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'address','cnic','phone_number','status','total_sale','reg_no',
        'total_paid_amount','total_rebate','percentage','city_id','dealer_type_id','code','is_deleted','password','rebate_in_percent','is_filer','ntn_number'
    ];



    public function dealerTransaction() {
        return $this->hasMany('App\DealerTransaction')->with('property');
    }

    public function dealerRebate() {
        return $this->hasMany('\App\DealerPaidRebate');
    }
    public function city() {
        return $this->belongsTo('\App\City');
    }
    public function dealerType() {
      return $this->belongsTo('\App\DealerType');
    }
    public function parentDealer(){
      return $this->belongsTo('\App\Dealer','parent_dealer');
    }


  public function package()
  {
    return $this->belongsToMany('\App\DealerPackage', 'dealer_packages');
  }

    public function insertNewDealer($request) {

      return  Dealer::create(['name'=>$request->name,'email'=>$request->email,
            'city_id'=>$request->city_id,'address'=>$request->address,'percentage'=>$request->percentage,'cnic'=>$request->cnic,'phone_number'=>$request->phone_number,'dealer_type_id'=>$request->incentive_type,'code' => $request->code,'password'=>bcrypt($request->password),'rebate_in_percent' =>$request->rebate_in_percent,'is_filer'=>$request->is_filer,'ntn_number'=>$request->ntn_number,'reg_no'=>$request->reg_no]);

    }

    public function updateDealer($request) {

        Dealer::where('id',$request->id)->update(['name'=>$request->name,'email'=>$request->email,
            'city_id'=>$request->city_id,'address'=>$request->address,'percentage'=>$request->percentage,'cnic'=>$request->cnic,'phone_number'=>$request->phone_number,
            'status'=>$request->status,'dealer_type_id'=>$request->incentive_type,'code' => $request->code,'rebate_in_percent' =>$request->rebate_in_percent,'is_filer'=>$request->is_filer,'ntn_number'=>$request->ntn_number]);
        if($request->password) 
          Dealer::where('id',$request->id)->update(['password'=>bcrypt($request->password)]);

    }

    public function createDealerPayment($request) {
        $input=$request->all();
        $dealer = DealerReceivedAmount::create($input);

        return $dealer;
    }
}
