<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Jobs\AddInventoryForDealerPackage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
class DealerPackage extends Model
{
    //
    const pending = 1;
    const completed = 2;

    const inventory_created = 1;
    const inventory_not_created = 0;


    public function dealerPackagePayment()
    {
        return $this->hasMany('\App\DealerPackagePaidAmount', 'dealer_package_id');
    }

    public function dealerPackagePaymentReceipt()
    {
        return $this->hasMany('\App\DealerPackageReceipt', 'dealerpackage_id');
    }
    public function dealer()
    {
        return $this->belongsTo('\App\Dealer', 'dealer_id');
    }

    public function package()
    {
        return $this->belongsTo('\App\OpenFilePackage', 'package_id');
    }

    public function openFileDealerInfo()
    {
        return $this->hasMany('\App\OpenFileDealerInfo', 'dealer_package_id');
    }    
    

    public function multiProject()
    {
        return $this->belongsTo('\App\MultiProject', 'multi_project_id','id');
    }


    public function insertData($request,$ids){
        DB::beginTransaction();
        try {
            $dealerpackage=new DealerPackage;
            $openfilepackage = OpenFilePackage::where('id',$request->package_id)->first();
            if(!empty($openfilepackage)){
            $dealerpackage->package_id = $request->package_id;
            $dealerpackage->dealer_id = $request->dealer;
            $dealerpackage->issue_date = $request->date;
    
            $dealerpackage->multi_project_id=$ids[0];
            
                $dealerpackage->payment_status = DealerPackage::pending;
             
            $dealerpackage->save();
            


            
    

     

     
            
            
            DB::commit();

            // dispatch(new AddInventoryForDealerPackage($openfilepackage->id));

            return true;
        } else
                return false;
        }
        catch (\Exception $e) {
            DB::rollback();
            return false;
        }

        DB::commit();
        return true;
    }

    public  function createInventory($array)
    {
        // dd($array['openfilepackage_id'],$array['dealerpackage_id']);
         DB::beginTransaction();
         $openfilepackage = OpenFilePackage::where('id', $array['openfilepackage_id'])->first();
        try {
           
            $price_list = PriceList::where('id',$openfilepackage->pricelist_id)->first();
            $dealerpackage = DealerPackage::where('id',$array['dealerpackage_id'])->first();
            $dealerpackage->inventory_status = 1;
            $dealerpackage->save();
            $expire_date = Carbon::createFromFormat('Y-m-d',$dealerpackage->issue_date)->addMonth();
            foreach ($openfilepackage->packageDetail as $detail) {
                $detail_price = $price_list->pricedetail->where('unit_type_id', $detail->unit_type_id)->where('unit_size_id', $detail->unit_size_id)->first();
                for ($i = 0; $i < $detail->unit_quantity; $i++) {
                 
                    $randomNumber = $this->generateUniqueNumber('inventories', 'unit_number');
                    $inventory = new Inventory;
                    $inventory->unit_size_id = $detail->unit_size_id;
                    $inventory->unit_number = $randomNumber; //$unit_number;
                    $inventory->total_price = $detail_price->total_price;
                    $inventory->status = Inventory::package_open_file;
                    $inventory->description = 'Dealer Package Open File ';
                    $inventory->extra_amount = 0;
                    $inventory->unit_type_id = $detail->unit_type_id;
                    $inventory->inventory_type = Inventory::unallocated;
                    $inventory->pricelist_id = $openfilepackage->pricelist_id;
                    $inventory->multi_project_id = $dealerpackage->multi_project_id;
                    $inventory->save();
                    $openfile_dealer = new OpenFileDealerInfo;
                    $openfile_dealer->dealer_package_id = $dealerpackage->id;
                    $openfile_dealer->dealer_id = $dealerpackage->dealer_id;
                    $openfile_dealer->invertory_id = $inventory->id;
                    $openfile_dealer->issue_date = $dealerpackage->issue_date;

                    $openfile_dealer->valid_until_date = $expire_date;
                    $openfile_dealer->unit_size_id = $detail->unit_size_id;
                    $openfile_dealer->unit_type_id = $detail->unit_type_id;
                    $openfile_dealer->save();



                }


            }
        }
        catch (\Exception $e) {
            DB::rollback();
            return false;
        }

        DB::commit();
        return $openfilepackage;
    }
    public  function createSpecificInventory($array)
    {
        
        // "dealer_package_id" => $request->dealer_package_id,
        // "package_detail_id" => $request->package_detail_id,
        // "inventory_quantity" => $request->inventory_quantity
       
        $dealerpackage = DealerPackage::where('id',$array['dealer_package_id'])->first();
         DB::beginTransaction();
         $openfilepackage = OpenFilePackage::where('id', $dealerpackage->package_id)->first();
        try {
           
            $price_list = PriceList::where('id',$openfilepackage->pricelist_id)->first();
            
            $dealerpackage->inventory_status = 1;
            $dealerpackage->save();
            $expire_date = Carbon::createFromFormat('Y-m-d',$dealerpackage->issue_date)->addMonth();
          $detail=  $openfilepackage->packageDetail->where('id', $array['package_detail_id'])->first();
           
        //   foreach ($required_data as $detail) {
               
                $detail_price = $price_list->pricedetail->where('unit_type_id', $detail->unit_type_id)->where('unit_size_id', $detail->unit_size_id)->first();
                // dd(  $detail_price);
                for ($i = 0; $i < $array['inventory_quantity']; $i++) {
                  
                   
                    $randomNumber = $this->generateUniqueNumber('inventories', 'unit_number');
                    $inventory = new Inventory;
                    $inventory->unit_size_id = $detail->unit_size_id;
                    $inventory->unit_number = $randomNumber; //$unit_number;
                    $inventory->total_price = $detail_price->total_price;
                    $inventory->status = Inventory::package_open_file;
                    $inventory->description = 'Dealer Package Open File ';
                    $inventory->extra_amount = 0;
                    $inventory->unit_type_id = $detail->unit_type_id;
                    $inventory->inventory_type = Inventory::unallocated;
                    $inventory->pricelist_id = $openfilepackage->pricelist_id;
                    $inventory->multi_project_id = $dealerpackage->multi_project_id;
                    $inventory->save();
                    $openfile_dealer = new OpenFileDealerInfo;
                    $openfile_dealer->dealer_package_id = $dealerpackage->id;
                    $openfile_dealer->dealer_id = $dealerpackage->dealer_id;
                    $openfile_dealer->invertory_id = $inventory->id;
                    $openfile_dealer->issue_date = $dealerpackage->issue_date;

                    $openfile_dealer->valid_until_date = $expire_date;
                    $openfile_dealer->unit_size_id = $detail->unit_size_id;
                        $openfile_dealer->unit_type_id = $detail->unit_type_id;
                    $openfile_dealer->save();



                }


            // }
        }
        catch (\Exception $e) {
            DB::rollback();
            return false;
        }

        DB::commit();
        return $openfilepackage;
    } 
    function generateUniqueNumber($table, $column)
    {
        $number = random_int(100000, 999999);
        $exists = DB::table($table)->where($column, $number)->exists();
        if ($exists) {
            return $this->generateUniqueNumber($table, $column);
        }
        return $number;
    }


   



}
