<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class DealerPackageReceipt extends Model
{
    //
    protected $fillable = [
        'dealer_id', 
        'dealerpackage_id', 
        'payment_head',
        'payment_mode',
        'bank_name',
        'cheque_number',
        'cheque_title',
        'drawn_date',
        'amount',
        
        'receipt_no',
        'receipt_date',
        'reference_no',
        'receipt_id',
        'company_account',
        'adjustment_type',
        'adjustment_detail',
        'inventory_id',
        'is_deleted',
        'is_approved',
        'payment_method',
        'dealer_adjustment_unit_id',
        'vendor_purchase_order_id',
        'notes',
        'is_book',
        'tax_paid_by',
        'tax_payment_received',
        'tax_amount',
        'notify_email',
        'notify_sms',
        'multi_project_id'
    ];


    public function dealer()
    {
        return $this->belongsTo('\App\Dealer', 'dealer_id');
    }
    public function dealerPackage()
    {
    
        return $this->belongsTo('\App\DealerPackage', 'dealerpackage_id');
    }

    public function  multiProject() {
        return $this->belongsTo('\App\MultiProject','multi_project_id','id');
    }



    
    public function insertReceipt($request) {

//   $dpa=new  DealerPackagePaidAmount;
        
 
        
         DB::beginTransaction();
         try 
         {
            $dealerpackage =  DealerPackage::where('id',$request->dealerpackage_id)->first();
            $openfilepackage = OpenFilePackage::where('id', $dealerpackage->package_id)->first();

            if (!empty($openfilepackage)) {
                
               

              
                    $dealerpackage->payment_status = DealerPackage::pending;
              
                $dealerpackage->save();
            }
            // $dealer_package_paid_amount =   new DealerPackagePaidAmount;
            // $dealer_package_paid_amount->dealer_package_id  = $request->dealerpackage_id;
            // $dealer_package_paid_amount->amount = $request->amount;
            // $dealer_package_paid_amount->payment_method = $request->payment_method;
            // $dealer_package_paid_amount->save();
            
            $request->merge(['multi_project_id' =>  $dealerpackage->multi_project_id]);
             $receipt = DealerPackageReceipt::create($request->all());
             DB::commit();
             return $receipt;
         }
         catch (\Exception $e) 
         {
             //dd($e);
             DB::rollback();
             return false;
         }
 
     }

    public function approvedAllReceipt($ids=null)
    {
        DB::beginTransaction();
        try {
            $current_receipt = DealerPackageReceipt::where('is_approved',0)
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
                                })
            ->orderBy('id', 'desc')->get();
            foreach ($current_receipt as $receipt) {

                DealerPackageReceipt::where('id', $receipt->id)->update(['is_approved' => 1]);

                $pid=   $receipt->dealerPackage->package->id;
                $dealerpackage = DealerPackage::where('id', $receipt->dealerpackage_id)->first();
                $openfilepackage = OpenFilePackage::where('id', $pid)->first();
               
                if (!empty($openfilepackage)) {
    
    
                    if ($openfilepackage->total_price > $receipt->amount) {
                        $dealerpackage->payment_status = DealerPackage::pending;
                    } elseif ($openfilepackage->total_price >= $receipt->amount) {
                        $dealerpackage->payment_status = DealerPackage::completed;
                    } else {
                        $dealerpackage->payment_status = DealerPackage::pending;
                    }
                    $dealerpackage->save();
                }

            }
      
            DB::commit();
            return true;
        }
        catch (\Exception $e) 
        {
            //dd($e);
            DB::rollback();
            return false;
        }
    }
}
