<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DealerPaidRebate extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
     protected $fillable = [
        'dealer_id', 
        'amount', 
        'date',
        'property_id',
        'account_id',
        'description',
        'payment_method',
        'bank_name',
        'company_account',
        'drawn_date',
        'cheque_number',
        'description',
        'tax_amount',
        'dealer_package_id'
    ];

    const CASH = 1;
    const BANK_TRANSFER = 2;
    
    public function dealer(){
        return $this->belongsTo('\App\Dealer','dealer_id');
    }

    public function account() {
        return $this->belongsTo('\App\ChartOfAccount','account_id');
    }

    public function property() {
        return $this->belongsTo('\App\CustomerProperty','property_id');
    }

    public function customer() {
        return $this->belongsTo('\App\Customer','customer_id');
    }
    public function dealerPackage(){
        return $this->belongsTo('App\DealerPackage','dealer_package_id');
    }

}
