<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DealerReceivedAmount extends Model
{
    protected $fillable = [
       'dealer_id','customer_property_id','payment_mode','bank_name','cheque_number','cheque_title','date','amount','adjacement_type','adjacement_detail','note'
   ];

   public function dealer() {
   	return $this->belongsTo('\App\Dealer');
   }

   public function property() {
   	return $this->belongsTo('\App\CustomerProperty','customer_property_id')->with('inventory');
   }

   public function DepositorBank(){
        return $this->belongsTo('App\DepositorBank','bank_name');
    }

    public function companyAccount() {
        return $this->belongsTo('\App\CompanyBank','company_account');
    }
}
