<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DealerTransaction extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'product_id','dealer_id','amount','status','dealer_package_id'
    ];

    //status
    const unpaid = 0;
    const paid = 1;

    public function property(){
        return $this->belongsTo('App\CustomerProperty','product_id')->with('inventory');
    }
    public function dealerPackage(){
        return $this->belongsTo('App\DealerPackage','dealer_package_id');
    }

    public function dealer(){
        return $this->belongsTo('App\Dealer');
    }
}
