<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Department extends Model
{
  
  use SoftDeletes;

   protected $fillable = [
      'department_name','role_id'
  ];

  public function itemReleses()
  {
    return $this->hasMany('App\ItemRelease' , 'department_id');
  }

  public function role() {
    return $this->belongsTo('App\Role');
  }

    
}
