<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use DB;

class DevelopmentCharges extends Model
{
    protected $fillable = [
        'customer_id','customer_property_id', 'charges_detail','is_approved','schedule_type'
    ];


    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }
    public function customerProperty()
    {
        return $this->belongsTo('App\CustomerProperty','customer_property_id');
    }
    //
    public function insertDevelopmentCharges($request){      
        try{
            
         $customer_pro=   CustomerProperty::where('id', $request->customer_property_id)->first();
           
         $cs=    CustomerStatement::where([['customer_id', $customer_pro->customer_id], ['customer_property_id', $customer_pro->id], ['payment_head', CustomerStatement::development]])->count();
            
             if ($request->schedule_type == CustomerProperty::full_payment) {
                
                $charges_array = array(
                    'payment_head' => CustomerStatement::development, 
                    'inst_no' => $cs+1, 
                    'due_date' => $request->development_date,
                     'due' => $request->development_charges, 
                     'balance' => $request->development_charges, 
                     'received' => 0
                    
                     
                );
                $charges_array=   serialize($charges_array);
                DevelopmentCharges::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'charges_detail' => $charges_array,'schedule_type'=>$request->schedule_type]);
                 }
         elseif($request->schedule_type == CustomerProperty::inst_custom){
                $inst_no = [];
                $due_date = [];
                $due = [];
                $balance = [];

             foreach($request->custom_date as $index => $value) {
                $inst_no[$index]= $index+$cs+1;
                $due_date[$index]=$value;
                
                $due[$index] = $request->custom_amount[$index];
                    $balance[$index] = $request->custom_amount[$index];
                   
             }
             $charges_array = array(
                'payment_head' => CustomerStatement::development, 
                'inst_no' => $inst_no, 
                'due_date' =>  $due_date,
                 'due' =>  $due, 
                 'balance' =>  $balance, 
                 'received' => 0
                
                 
            );
                
            $charges_array=   serialize($charges_array);
            // DevelopmentCharges::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'payment_head' => CustomerStatement::development, 'inst_no' => $index+$cs, 'due_date' => $value, 'due' => $request->custom_amount[$index], 'balance' => $request->custom_amount[$index], 'received' => 0]);
            DevelopmentCharges::create(['customer_id' => $customer_pro->customer_id, 'customer_property_id' => $customer_pro->id, 'charges_detail' => $charges_array,'schedule_type'=>$request->schedule_type]);
            
     
         }
         } catch (\Exception $e) {
             DB::rollback();
             return false;
         }
         DB::commit();
         return true;
         }
     
}
