<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;

class DirectBallotingMapDetail extends Model
{
    //
    const not_ballot_yet = 0;
    const balloting_pending = 1;
    const balloting_complete = 2;

    public function customerProperty()
    {


        return $this->belongsTo('\App\CustomerProperty', 'customer_property_id', 'id');
    }
    public function Inventory()
    {


        return $this->belongsTo('\App\Inventory', 'inventory_id', 'id');
    }

    public function category()
    {
        return $this->hasMany('\App\DirectBallonMapDetailCategory', 'ballon_map_detail_id', 'id');
    }


    public function startBallotingInventory($request)
    {
        DB::beginTransaction();
        try {
            $progress = 0;

            $map = DirectBallotingMapFile::where('id', $request->map_id)->first();









            if (!empty($map->mapDetail)) {
                $total_count = count($map->mapDetail);
                foreach ($map->mapDetail as $invent) {
                    $progress++;
                    session(['balloting_progress' => ($progress / $total_count) * 100]);

                    if (!empty($invent->cnic) && !empty($invent->membershipno)) {
                        $customer_pro =  CustomerProperty::where('membership_no', 'like', $invent->membershipno)->first();
                        if (!empty($customer_pro)) {
                            $customer =   $customer_pro->customer;
                            if (!empty($customer)) {
                                if ($customer->cnic == $invent->cnic) {
                                    $inventory_data = Inventory::where('id',  $customer_pro->inventory_id)->where('inventory_type', Inventory::unallocated)->first();
                                  if(!empty($inventory_data)){
                                    $invent->inventory_id =  $inventory_data->id;
                                    $invent->balloting_status = DirectBallotingMapDetail::balloting_pending;
                                    $invent->save();

                                    $unit_floor =    UnitFloor::where('unit_block_id', $invent->unit_block_id)->where('id', $invent->unit_floor_id)->first();
                                    if (empty($unit_floor)) {
                                        if (!empty($invent->unit_block_id) && !empty($invent->unit_floor_id)) {


                                            $unit_floor = new UnitFloor;
                                            $unit_floor->name = $invent->street;
                                            $unit_floor->unit_block_id = $invent->unit_block_id;
                                            $unit_floor->save();
                                        }
                                    }
                                    $old_unit_number = $inventory_data->unit_number;
                                    $inventory_data->unit_floor_id = $unit_floor->id;
                                    $inventory_data->unit_number = $invent->plot_no;
                                    $inventory_data->old_unit_number = $old_unit_number;
                                    $inventory_data->inventory_type = Inventory::allocated;
                                    $inventory_data->save();
                                    if (!empty($invent->category)) {
                                        foreach ($invent->category as $r) {


                                            InventoryCategory::create(['inventory_id' => $inventory_data->id, 'unit_category_id' => $r->category_id]);
                                        }
                                    }
                                  }
                                    
                                }
                            }
                        }
                    }
                }
            }


            session(['balloting_progress' => 100]);
            $map->status = 1;
            $map->save();
        } catch (\Exception $e) {

            // dd($e);
            DB::rollback();
            $val = [
                'status' => false,
                'id' => null
            ];
            return $val;
        }
        DB::commit();
        $val = [
            'status' => true,
            'id' =>  $map->id
        ];
        return $val;
    }
}
