<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Input;
use Carbon\Carbon;

class Employee extends Model {

    //status 
    const active = 1;
    const pending = 2;
    const terminated = 3;
    //type 
    const full = 1;
    const part = 2;
    const intern = 3;
    //gender
    const male = 1;
    const female = 2;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'basic_salary', 'employee_id', 'manager_id', 'department_id', 'designation_id',
        'start_date', 'status', 'employee_type', 'working_hours', 'working_days', 'bank_name',
        'account_name', 'account_number', 'name', 'email', 'phone_number', 'address',
        'gender', 'dob', 'emer_person', 'emer_relation', 'emer_phone_number', 'emer_email','reference'
    ];

    public function department() {
        return $this->belongsTo('\App\Department');
    }

    public function designation() {
        return $this->belongsTo('\App\Designation');
    }

    public function policies() {
        return $this->hasMany('\App\EmployeePolicy');
    }

    public function documents() {
      return $this->hasMany('\App\EmployeeDocument');
    }
    
    public function payroll(){
        return $this->hasMany('\App\Payroll');
    }
    
    public function checkSalaryPaidOrNot($id) {
       
        $paid = false;
        //check given employee already taken salary or not
        $payrolls = Payroll::where('employee_id', $id)->get();
        foreach ($payrolls as $payroll) {
            if (date('m-y', strtotime($payroll->date)) == date('m-y')) {
                $paid = true;
            }
        }
        return $paid;
    }

    public function insertNewEmployee($request) {

        $employee = Employee::create(Input::except('photos'));

        if ($request->policies) {
            foreach ($request->policies as $policy) {
                EmployeePolicy::create(['employee_id' => $employee->id, 'policy_id' => $policy]);
            }
        }

        if ($request->hasfile('photos')) {

          foreach ($request->photos as $photo) {


            $name = $request->id . '-' . $photo->getClientOriginalName();

            $photo->move(public_path() . '/uploads/', $name);

            EmployeeDocument::create(['employee_id'=>$employee->id,'url'=>$name]);
          }
        }

        return $employee;
    }

    public function updateEmployee($request) {

        Employee::where('id', $request->id)->update(Input::except('_token', 'policies','photos'));

        EmployeePolicy::where('employee_id', $request->id)->delete();

        if ($request->policies) {
            foreach ($request->policies as $policy) {
                EmployeePolicy::create(['employee_id' => $request->id, 'policy_id' => $policy]);
            }
        }

        if ($request->hasfile('photos')) {

          foreach ($request->photos as $photo) {


            $name = $request->id . '-' . $photo->getClientOriginalName();

            $photo->move(public_path() . '/uploads/', $name);

            EmployeeDocument::create(['employee_id'=>$request->id,'url'=>$name]);
          }
        }
    }
    
    public function  runPayrollByEmployeeId($id) {
        
        $paid = false;
        //check given employee already taken salary or not
        $payrolls = Payroll::where('employee_id',$id)->get();
        foreach($payrolls as $payroll) {
            if(date('m-y',strtotime($payroll->date )) == date('m-y')) {
                $paid = true;
            }
        }
        if($paid == true) {
            return false;
        }
        else {
            $employee = Employee::with('policies')->where('id',$id)->first();
            $allowance = 0;
            $deduction = 0;
            
            foreach ($employee->policies as $policy) {
                if ($policy->policy->type == \App\Policy::allowance) {
                    $allowance += $policy->policy->amount;
                } elseif ($policy->policy->type == \App\Policy::deduction) {
                    $deduction += $policy->policy->amount;
                }
            }
            
            $net_pay = $employee->basic_salary + $allowance - $deduction;
            Payroll::create(['date'=>date('y-m-d'),'employee_id'=>$id,'benefits'=>$allowance,'deductions'=>$deduction,'net_pay'=>$net_pay]);

            return true;
        }
        
    }

}
