<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class Approval implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

     public $role_id; public $purchase_request_id;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($roleId,$purchaseRequestId)
    {
        $this->role_id = $roleId;
        $this->purchase_request_id = $purchaseRequestId;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return ['approval-channel'];
    }

    public function broadcastAs()
  {
      return '' . $this->role_id;
  }
}
