<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ExpensePayment extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'bill_id', 'amount', 'date','account_id','payment_method','reference','notes','approval_status','file','is_reconciled','is_book'
    ];

    const CASH = 1;
    const BANK_TRANSFER = 2;
    const CHEQUE = 3;

    

    public function bill() {
        return $this->belongsTo('\App\Expense','bill_id');
    }

    public function account() {
        return $this->belongsTo('\App\ChartOfAccount','account_id');
    }
}
