<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class FixedAsset extends Model
{
    protected $table = 'fixed_assets';


    protected $fillable = [
   
        'asset_tag' ,
        'name' ,
        'item_id' ,
        'warranty',
        'status',
        'cost',
        'serial'  ,
        'description',
        'purchase_date',
        'asset_type',
        'depreciation_policy' ,
        'depreciation_rate',
        'asset_location',
        'physical_status',
        'is_sent',
  ];

      public function item() 
      {
        return $this->belongsTo('App\Item','item_id')->with(['manufacture']);
      }

        public function asset_type()
    {
      return $this->belongsTo('App\FixedAssetType' , 'asset_type');
    }


}
