<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class GeneralJournalEntry extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [  
 'cancel_open_unit','cancel_close_unit','dealer_refund_openfile', 'customer_refund_unit', 'multi_project_id', 'dealer_package_voucher',  'date','entry_no','adjusting_entry','account_id','amount','name','memo','name_type','type','voucher_type','transaction_type','transaction_id','is_check','check_by','is_post','post_by','prepare_by','voucher_no','is_cleared','bank_name','cheaque_no'
    ];

    //voucher type
    const CRV = 1;
    const BRV = 2;
    const CPV = 3;
    const BPV = 4;
    const JV = 5;

    //transaction type
    const booking = 1;
    const receipt = 2;
    const bill = 3;
    const payment = 4;
    const massPayment = 5;
    const rebate = 6;
    const procurment_receipt = 7;
    const dealer_receipt = 8;
    const customer_tax_receipt = 9;

    
    const customer_refund_unit = 10;

    const dealer_open_file_package = 11;
    const dealer_refunded_open_file = 12;
    const customer_cancel_unit = 13;
    const dealer_cancel_open_unit = 14;

    public function account() {
    	return $this->belongsTo('App\ChartOfAccount','account_id');
    }

    public function customer() {
        return $this->belongsTo('App\Customer','name');
    }

    public function vendor() {
        return $this->belongsTo('App\Vendor','name');
    }

    public function dealer() {
        return $this->belongsTo('App\Dealer','name');
    }

    public function class() {

        return $this->belongsTo('App\AccountClass','class_id');
    }

    public function preparedBy() {
        return $this->belongsTo('App\User','prepare_by');
    }

    public function checkedBy() {
        return $this->belongsTo('App\User','check_by');
    }

    public function postedBy() {
        return $this->belongsTo('App\User','post_by');
    }

    public function property() {
        return $this->belongsTo('App\CustomerProperty','transaction_id');
    }

    public function receipt() {
        return $this->belongsTo('App\Receipt','transaction_id');
    }

    public function dealerReceipt() {
        return $this->belongsTo('App\DealerPackageReceipt','transaction_id');
    }

    public function customerUnitRefundReceipt() {
        return $this->belongsTo('App\CustomerRefundUnitReceipt','transaction_id');
    }
    public function dealerOpenFileRefundReceipt() {
        return $this->belongsTo('App\DealerRefundOpenFileUnitReceipt','transaction_id');
    }
    public function CustomerCancelUnitReceipt() {
        return $this->belongsTo('App\CustomerCancelUnitReceipt','transaction_id');
    }
    public function DealerOpenFileCancelReceipt() {
        return $this->belongsTo('App\DealerOpenFileCancelReceipt','transaction_id');
    }
    public function bill() {
        return $this->belongsTo('App\Expense','transaction_id');
    }

    public function bills() {
        return $this->hasMany('App\Expense','entry_no','entry_no');
    }

    public function controlAccount() {
        return $this->belongsTo('\App\ControlAccount','name');
    }

    public function voucher() {
        return $this->belongsTo('App\Voucher','entry_no','entry_no');
    }

    public static function getAccountBalance($account_id = null)
    {
            $from = date("Y-m-d",strtotime('-29 days'));
            $to  = date("Y-m-d");

            $balance = 0;

            $openingBalance = GeneralJournalEntry::where('date','<',$from)->where([['is_post',true],['account_id',$account_id]])->sum('amount');

            $entries = GeneralJournalEntry::whereBetween('date',[$from,$to])->where([['is_post',true],['account_id',$account_id]])->orderBy('date','ASC')->get();

            $account = ChartOfAccount::find($account_id);



        if($account->type->name == 'Bank' || $account->type->name == 'Fixed Asset' || $account->type->name == 'Other CurrentAsset' || $account->type->name == 'Other Asset' || $account->type->name == 'Non-Current Asset' || $account->type->name == 'Expense' || $account->type->name == 'Direct Cost' || $account->type->name == 'Income')
        {
            $balance = $openingBalance;$debit = 0; $credit = 0;$monthlyDebit = 0;$monthlyCredit = 0;

            foreach($entries as $entry)
            {
                $balance += $entry->amount;
            }
        }
        elseif($account->type->name == 'Accounts Receivable')

        {
            $balance = $openingBalance;$debit = 0; $credit = 0;
            foreach($entries as $entry)
            {
                $balance += $entry->amount;
            }
        }
        elseif($account->type->name == 'Accounts Payable')

        {
            $balance = $openingBalance;$debit = 0; $credit = 0;
            foreach($entries as $entry)
            {
                $balance += $entry->amount;
            }
        }
        elseif($account->type->name == 'Other Current Liability' || $account->type->name == 'Long Term Liability' || $account->type->name == 'Current Liability' || $account->type->name == 'Equity')

        {
            $balance = $openingBalance;$debit = 0; $credit = 0;
            foreach($entries as $entry)
            {
                $balance += $entry->amount;
            }
        }
        

            if($balance < 0)
            {
                 return '('.number_format(abs($balance)).')';
            }          
            else
            {
                 return number_format($balance);
            }
    }
 }
