<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class HrmAttendance extends Model
{
  
    protected $table ='hrm_attendances';

 
    
    protected $fillable = [
        'employ_id', 'present_absent','date','user_id','checkin','checkout','status','leave_type'
        
    ];

    public function hrmEmployee() {
       return $this->belongsTo('App\HrmEmployee','employ_id');
    }

    public static function getMonthlyAttandancePer($id = null , $date_of_joining = null)
    {    
        $total_per = 0;

        $total = HrmAttendance::where('employ_id' , $id)->count();

        $total_absent = HrmAttendance::where('employ_id' , $id)
        ->where('present_absent' , 0)
        ->count();

        $total_present = ($total - $total_absent);


         $diff = strtotime(date('Y-m-d')) - strtotime($date_of_joining);  

          
 
        if ($diff != 0 ) 
        {

            $diff = strtotime(date('Y-m-d')) - strtotime($date_of_joining);


            $diff = abs(round($diff / 86400));
    

            $total_per = ($total_present /  $diff) *100; 

            $total_per = round($total_per) ;

            return $total_per;

        }
        else
        {
           return  $total_per ;
        }

    	
    }




}
							