<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class HrmCompanyDetail extends Model
{
  use SoftDeletes;
    protected $table ='hrm_company_detail';

    protected $dates = ['deleted_at'];
    
    protected $fillable = [
        'employee_code', 'department','employ_id','country','city','date_of_joining','monthly_salary','designation', 'contract_type','salary_method'
        
    ];

    public function hrmEmployee() {
       return $this->belongsTo('App\HrmEmployee','employ_id');
    }

    public function department() {
       return $this->belongsTo('App\Department','department');
    }

    public function country() {
       return $this->belongsTo('App\Country','country');
    }
    public function city() {
       return $this->belongsTo('App\City','city');
    }
     public function designation() {
       return $this->belongsTo('App\HrmEmployeeDesignation','designation');
    }
}
										