<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HrmEmployee extends Model
{
    use SoftDeletes;	

    protected $table ='hrm_employees';

    protected $dates = ['deleted_at'];
    
    protected $fillable = [
        'name', 'email', 'cnic','gender','dob','phone_no','residential_address',
        'pemanent_address','status', 'user_id'
    ];

    public function companyDetail() {
        return $this->hasOne('App\HrmCompanyDetail','employ_id')->with(['designation','department']);
    }
    
     public function accountDetail() {
        return $this->hasOne('App\HrmBankAccountDetail','employ_id');
    }

      public function docunmentDetail() {
        return $this->hasOne('App\HrmEmployeeDocument','employ_id');
    }
     

     public function earningDetail() {
        return $this->hasMany('App\HrmEmployeeSalary','employ_id');
    }

    public function deductionDetail() {
        return $this->hasMany('App\HrmEmployeeSalary','employ_id');
    }


     public function role() {
        return $this->belongsTo('App\Role','user_id');
    }

    public function attendance() {
        return $this->hasOne('App\HrmAttendance','employ_id');
    }

    public function allowanceDetail() {
        return $this->hasMany('App\HrmEmployeeSalary','employ_id');
    }

    public function earningDeduction() {
        return $this->hasOne('App\HrmEmployeeEarningDeduction','employ_id');
    }

    public function employeeSalary() {
        return $this->hasMany('App\HrmEmployeeTotalSalary','employ_id');
    }

    public function employeeEarningDeduction() {
        return $this->hasMany('App\HrmEmployeeMonthlyEarningDeduction','employ_id');
    }

    public function HrmEmployeeDesignation() {
        return $this->hasMany('App\HrmEmployeeMonthlyEarningDeduction','employ_id');
    }

    public function benevolentFund() {
        return $this->hasMany('App\HrmEmployeeBenevolentFound','employ_id');
    }

    public function loan() {
        return $this->hasMany('App\HrmEmployeeLoan','employ_id');
    }

}
								