<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class HrmEmployeeBenevolentFound extends Model
{
    protected $table ='hrm_employees_benevolent_funds';
   

    protected $fillable = [
        'employ_id','month','year','bf_fund', 'status' , 'bf_fund_company_con','is_approved'];

        public function hrmEmployee() {
       return $this->belongsTo('App\HrmEmployee','employ_id');
    }


   public static function getData($employ_id = null , $month = null , $year = null)
    {
    	
        $status = 1 ;

    	$total_calculated_benevolent_fund = HrmEmployeeBenevolentFound::where('employ_id' , $employ_id)->sum('bf_fund');

        $employee_benevolent_fund = HrmEmployeeBenevolentFound::where('employ_id' , $employ_id)->sum('bf_fund');

        $employer_con_benevolent_fund = HrmEmployeeBenevolentFound::where('employ_id' , $employ_id)->sum('bf_fund_company_con');

        $employee_status = HrmEmployeeBenevolentFound::where('employ_id' , $employ_id)->first();

        if($employee_status == true)
        {
           $status = $employee_status->status; 
        }

    
        return [$total_calculated_benevolent_fund , $employee_benevolent_fund , $status ,$employer_con_benevolent_fund];

    }	
}


